/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.language;

import coldfusion.tagext.language.NodeNotFoundException;
import coldfusion.tagext.language.RegNode;
import coldfusion.tagext.language.RegReader;
import coldfusion.tagext.language.RegistryException;
import com.adobe.cfsetup.commands.AbstractCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;

public class RegMgr {
    private File _file = null;
    private RegNode _root = null;
    private Map _att;
    private static RegMgr _rmgr = null;
    private static boolean _loaded = false;

    private RegMgr() {
    }

    public Map dump() {
        return this._root;
    }

    public static RegMgr getInstance() {
        if (_rmgr == null) {
            _rmgr = new RegMgr();
        }
        return _rmgr;
    }

    public synchronized void load(File f) {
        this._file = f;
        if (this._root == null) {
            try {
                RegReader rr = new RegReader(this._file);
                this._root = rr.load();
                _loaded = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void store(File f) {
        if (AbstractCommand.isLambdaMode()) {
            return;
        }
        try {
            PrintWriter out = null;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f))));
            if (this._root != null) {
                this._root.traverseChildren(out);
            }
            out.println();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RegistryException("Error while storing");
        }
    }

    public synchronized void store() {
        try {
            PrintWriter out = null;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this._file))));
            if (this._root != null) {
                this._root.traverseChildren(out);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RegistryException("Error while storing");
        }
    }

    public boolean isLoaded() {
        return _loaded;
    }

    public void setAttributes(Map m) {
        this._att = m;
    }

    public synchronized void set(String branch, String entry, String value, String type) {
        if (type == null) {
            type = "string";
        }
        if (value == null) {
            if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("key")) {
                value = "";
            } else if (type.equalsIgnoreCase("dword")) {
                value = "0";
            }
        }
        if (this._root == null) {
            this._root = new RegNode(RegNode.popLeft(branch));
        }
        this._root.doSet(branch, entry, value, type);
    }

    public Map getAll(String branch, String type) throws NodeNotFoundException {
        Map ret = null;
        if (this._root != null) {
            ret = this._root.doGetAll(branch);
        }
        return ret;
    }

    public Object get(String branch, String entry, String type) {
        Object ret = null;
        if (this._root != null) {
            try {
                ret = this._root.doGet(branch, entry, type);
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                // empty catch block
            }
        }
        return ret;
    }

    public synchronized void delete(String branch, String entry) throws NodeNotFoundException {
        if (this._root != null) {
            if (entry == null) {
                this._root.doDelete(branch);
            } else {
                this._root.doDelete(branch, entry);
            }
        }
    }
}

