/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.language;

import coldfusion.tagext.language.RegNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.perl.Perl5Util;

public class RegReader {
    private File _file;
    private String _filename;

    public RegReader(File file) {
        this._file = file;
    }

    public RegReader(String s) {
        this._filename = s;
        this._file = new File(this._filename);
    }

    public synchronized RegNode load() throws IOException {
        RegNode node = null;
        boolean first = true;
        try {
            Perl5Util util = new Perl5Util();
            BufferedReader br = new BufferedReader(new FileReader(this._file));
            String str = br.readLine();
            String path = null;
            while (br.ready() && str != null) {
                if (util.match("/^[Hh][Kk][Ee][Yy].*:[0-9]*$/", str)) {
                    path = this.splitPath(str);
                    if (first) {
                        first = false;
                        node = new RegNode(RegNode.popLeft(path));
                    }
                } else if (str.length() > 0) {
                    Vector v = this.splitEntry(str);
                    node.doSet(path, (String)v.elementAt(0), (String)v.elementAt(1), (String)v.elementAt(2));
                }
                str = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return node;
    }

    public Vector splitEntry(String s) {
        Vector<String> v = new Vector<String>();
        Perl5Util util = new Perl5Util();
        String sub1 = s;
        try {
            util.match("m/\\:/", sub1);
            String entry = util.preMatch();
            int eoff = util.beginOffset(0);
            v.addElement(entry);
            int count = 0;
            int off = 0;
            while (util.match("m/\\;/", sub1)) {
                sub1 = util.postMatch();
                off = util.beginOffset(0);
                count += off + 1;
            }
            String value = s.substring(eoff + 1, --count);
            String type = util.postMatch();
            value = util.substitute("s/\\s*((\\S)*)/$1/", value);
            v.addElement(RegNode.fromStorage(value));
            type = util.substitute("s/\\s*((\\S)*)/$1/", type);
            v.addElement(type);
        }
        catch (Exception e) {
            System.err.println("Registry: Problem splitting: " + s);
            e.printStackTrace();
        }
        return v;
    }

    public String splitPath(String s) {
        StringTokenizer tk = new StringTokenizer(s, ":");
        String t = tk.nextToken();
        return t;
    }

    static void main(String[] args) {
        RegReader rr = null;
        if (args.length == 1) {
            rr = new RegReader(args[0]);
        } else {
            System.out.println("Usage: java coldfusion.tagext.lang.RegReader <filename>");
        }
    }
}

