/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.language;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.language.NodeNotFoundException;
import coldfusion.tagext.language.RegMgr;
import coldfusion.tagext.language.RegistryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class RegistryServiceImpl
extends ServiceBase {
    private File _rfile;
    private File _configFile;
    private RegMgr _rm = null;
    private boolean _isDirtyBit = false;
    private int _timeDelay = 60000;
    private boolean _disabled = false;

    public boolean isCrossPlatform() {
        return !this._disabled;
    }

    private boolean IsNativeRegistrySupportAvaible(String path) {
        boolean rc = true;
        try {
            System.load(path + File.separator + "cfregistry.dll");
            System.load(path + File.separator + SystemInfo.getCFXNeoLibName());
        }
        catch (Throwable tLibraryProblem) {
            rc = false;
        }
        return rc;
    }

    public RegistryServiceImpl(File rfile, File config, String path) {
        String os = System.getProperty("os.name");
        if (os.toUpperCase().startsWith("WINDOWS")) {
            if (this.IsNativeRegistrySupportAvaible(path)) {
                this._disabled = true;
            } else {
                this._rfile = rfile;
                this._configFile = config;
                this._rm = RegMgr.getInstance();
                this._disabled = false;
            }
        } else {
            this._rfile = rfile;
            this._configFile = config;
            this._rm = RegMgr.getInstance();
            this._disabled = false;
        }
    }

    @Override
    public void load() throws ServiceException {
        if (!this._disabled) {
            try {
                Vector v = (Vector)this.deserialize(this._configFile);
                ConfigMap map = (ConfigMap)v.elementAt(0);
                Object obj = map.get("time_delay");
                int t = Integer.parseInt(obj.toString());
                if (t > 60000) {
                    this._timeDelay = t;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._rm.load(this._rfile);
        }
    }

    @Override
    public void store() throws ServiceException {
        if (!this._disabled) {
            this._rm.store(this._rfile);
        }
    }

    @Override
    public void stop() throws ServiceException {
        if (!this._disabled) {
            this.store();
        }
    }

    public void set(String branch, String entry, String value, String type) {
        branch = this.escapeSlash(branch);
        entry = this.escapeSlash(entry);
        value = this.escapeSlash(value);
        type = this.escapeSlash(type);
        if (this._disabled) {
            if ("KEY".equalsIgnoreCase(type)) {
                this.executeRegCommand("reg add \"" + branch + "\\" + entry + "\" /f");
            } else {
                if ("STRING".equalsIgnoreCase(type)) {
                    type = "REG_SZ";
                }
                if ("DWORD".equalsIgnoreCase(type)) {
                    type = "REG_DWORD";
                }
                String q = "reg add \"" + branch + "\" /v \"" + entry + "\" /t " + type + " /d \"" + value + "\" /f";
                this.executeRegCommand(q);
            }
        } else {
            this._rm.set(branch, entry, value, type);
        }
    }

    private String escapeSlash(String v) {
        if (StringUtils.isNotBlank((CharSequence)v) && ((String)v).charAt(((String)v).length() - 1) == '\\') {
            v = (String)v + "\\";
        }
        return v;
    }

    public String executeRegCommand(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            RegCommandOutPutReader reader = new RegCommandOutPutReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getOutput();
            if (StringUtils.isBlank((CharSequence)output)) {
                return null;
            }
            String[] parsed = output.trim().split(" ");
            return parsed[parsed.length - 1];
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object get(String branch, String entry, String type) {
        if (this._disabled) {
            return this.executeRegCommand("reg query \"" + branch + "\" /v " + entry);
        }
        return this._rm.get(branch, entry, type);
    }

    public void delete(String branch, String entry) throws RegistryException {
        try {
            this._rm.delete(branch, entry);
        }
        catch (NodeNotFoundException e) {
            throw new RegistryException("Node Not Found");
        }
    }

    static class RegCommandOutPutReader
    extends Thread {
        private InputStream is;
        private StringWriter stringWriter = new StringWriter();

        public RegCommandOutPutReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int read;
                while ((read = this.is.read()) != -1) {
                    this.stringWriter.write(read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getOutput() {
            return this.stringWriter.toString();
        }
    }
}

