/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.File;
import java.io.IOException;

public class FileLock {
    private File lockFile = null;
    private int sleepInterval = 1000;
    private int maxSleeps = 10;

    public FileLock(String dir, String name) {
        String lockFileName = name.substring(0, name.lastIndexOf(".")) + ".lck";
        this.lockFile = new File(dir, lockFileName);
    }

    public void obtain() throws IOException {
        if (this.lockFile.exists()) {
            long lastmod = this.lockFile.lastModified();
            long currentTime = System.currentTimeMillis();
            long diff = currentTime - lastmod;
            if (diff > 50000L) {
                this.lockFile.delete();
            }
        }
        int sleepCount = 0;
        while (!this.lockFile.createNewFile()) {
            if (++sleepCount == this.maxSleeps) {
                throw new IOException("Timed out waiting for: " + this);
            }
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (InterruptedException e) {
                throw new IOException(e.toString());
            }
        }
    }

    public void release() {
        this.lockFile.delete();
    }

    public String toString() {
        return "Lock::" + this.lockFile;
    }
}

