/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.server.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;

public class FileUtils {
    public static boolean setUnixModes(String path, int modeString) throws IOException {
        if (SystemInfo.isWindows()) {
            return false;
        }
        if (String.valueOf(modeString).trim().length() == 0) {
            return false;
        }
        if (path == null || path.trim().length() == 0) {
            return false;
        }
        final String[] execArg = new String[]{"chmod", String.valueOf(modeString), path};
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (SystemInfo.isAIX()) {
                        return Runtime.getRuntime().exec(execArg, new String[0]);
                    }
                    return FileUtils.exec(execArg, true);
                }
            });
            return true;
        }
        catch (PrivilegedActionException ex) {
            Exception e = ex.getException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (IOException)e;
        }
    }

    private static Process exec(String[] command, boolean wait) {
        Process p;
        try {
            p = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            return null;
        }
        if (wait) {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return p;
    }

    public static boolean setFileAttributes(File file, String attributes) throws IOException {
        if (attributes != null) {
            if (attributes.trim().toUpperCase().equals("READONLY")) {
                file.setReadOnly();
            } else {
                try {
                    FileUtils.setWindowsFileAttribs(file.getAbsolutePath(), attributes);
                }
                catch (IOException e) {
                    throw new IOException(e);
                }
            }
            return true;
        }
        return false;
    }

    protected static void setWindowsFileAttribs(String path, String attribString) throws IOException {
        if (!SystemInfo.isWindows()) {
            return;
        }
        if (attribString == null || attribString.trim().length() == 0) {
            return;
        }
        if (path == null || path.trim().length() == 0) {
            return;
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("attrib");
        if (attribString.toUpperCase().indexOf("READONLY") > -1) {
            cmdList.add("+R");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-R");
        }
        if (attribString.toUpperCase().indexOf("HIDDEN") > -1) {
            cmdList.add("+H");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-H");
        }
        if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-S");
        }
        if (attribString.toUpperCase().indexOf("ARCHIVE") > -1) {
            cmdList.add("+A");
        } else if (attribString.toUpperCase().indexOf("NORMAL") > -1) {
            cmdList.add("-A");
        }
        if (cmdList.size() > 1) {
            if (!cmdList.contains("+A") && !cmdList.contains("-A")) {
                cmdList.add("-A");
            }
            if (!cmdList.contains("+R") && !cmdList.contains("-R")) {
                cmdList.add("-R");
            }
            if (!cmdList.contains("+H") && !cmdList.contains("-H")) {
                cmdList.add("-H");
            }
            if (!cmdList.contains("+S") && !cmdList.contains("-S")) {
                cmdList.add("-S");
            }
        }
        if (cmdList.size() != 1 || attribString.length() >= 1) {
            // empty if block
        }
        cmdList.add(path);
        final String[] execArg = cmdList.toArray(new String[cmdList.size()]);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return FileUtils.exec(execArg, true);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception e = ex.getException();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (IOException)e;
        }
    }
}

