/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

public class Hex {
    public static byte[] hexToBytes(String strInput) {
        try {
            int nLen = strInput.length();
            int nNumDigits = nLen / 2;
            byte[] bytes = new byte[nNumDigits];
            for (int i = 0; i < nNumDigits; ++i) {
                String sDigit = strInput.substring(i * 2, i * 2 + 2);
                bytes[i] = (byte)Integer.parseInt(sDigit, 16);
            }
            return bytes;
        }
        catch (NumberFormatException ex) {
            return new byte[0];
        }
    }

    public static String bytesToHex(byte[] input) {
        StringBuffer strResult = new StringBuffer();
        for (byte ch : input) {
            int firstDigit = ch >>> 4 & 0xF;
            int secondDigit = ch & 0xF;
            strResult.append(Integer.toHexString(firstDigit).toUpperCase() + Integer.toHexString(secondDigit).toUpperCase());
        }
        return strResult.substring(0);
    }

    public static boolean isHexString(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Hex.isHexDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
    }
}

