/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.ApplicationException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Enumeration;
import javax.crypto.Cipher;

public class KeystoreUtils {
    private static final String BC = "BC";
    private static final String JKS_TYPE = "jks";
    private static final String PKCS12_TYPE = "pkcs12";

    public static KeyStore getKeyStore(String keystoreFile, String keystorePassword) {
        try {
            return KeystoreUtils.getKeyStore(keystoreFile, keystorePassword, JKS_TYPE);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                return KeystoreUtils.getKeyStore(keystoreFile, keystorePassword, PKCS12_TYPE);
            }
            catch (ApplicationException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new InvalidKeystoreException(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keystoreFile, String keystorePassword, String storeType) throws Exception {
        try (FileInputStream fis = null;){
            fis = new FileInputStream(keystoreFile);
            KeyStore keystore = storeType == PKCS12_TYPE ? KeyStore.getInstance(storeType, BC) : KeyStore.getInstance(storeType);
            keystore.load(fis, keystorePassword.toCharArray());
            KeyStore keyStore = keystore;
            return keyStore;
        }
    }

    public static String getKeyAlias(KeyStore keystore) throws KeyStoreException {
        Enumeration<String> aliases = keystore.aliases();
        if (aliases.hasMoreElements()) {
            return aliases.nextElement();
        }
        return null;
    }

    protected static String getSubjectDN(String subjectDN, String spName) {
        if (subjectDN == null || ((String)subjectDN).trim().length() == 0) {
            subjectDN = "CN=cfserviceprovider_" + spName + "_signer";
        }
        return subjectDN;
    }

    public static void removeBCProvider() {
        if (Security.getProvider(BC) != null) {
            Security.removeProvider(BC);
        }
    }

    private static boolean isPolicyFilesInstalled() {
        try {
            int keyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (keyLength == Integer.MAX_VALUE) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public static void writeKeystoreToFile(KeyStore keystore, OutputStream os, char[] password) throws FileNotFoundException, KeyStoreException, IOException, java.security.cert.CertificateException, NoSuchAlgorithmException {
        keystore.store(os, password);
    }

    public static class InvalidKeystoreException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public InvalidKeystoreException(Throwable e) {
            super(e);
        }
    }

    public static class CertificateException
    extends ApplicationException {
        public String exceptionMessage = "";

        public CertificateException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }

    public static class KeystoreException
    extends ApplicationException {
        public String exceptionMessage = "";

        public KeystoreException(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }
    }
}

