/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.MissingAttributeException;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import java.util.Vector;
import org.xml.sax.AttributeList;

class ArrayHandler
extends WddxElement {
    private static final String LENGTH_ATTRIBUTE_NAME = "length";
    private Vector<Object> m_array = null;

    ArrayHandler() {
    }

    @Override
    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        String length = attributes.getValue(LENGTH_ATTRIBUTE_NAME);
        if (length == null) {
            throw new MissingAttributeException("array", LENGTH_ATTRIBUTE_NAME);
        }
        try {
            this.m_array = new Vector(Integer.parseInt(length));
        }
        catch (NumberFormatException e) {
            throw new IllegalArrayLengthAttributeException(LENGTH_ATTRIBUTE_NAME);
        }
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_array);
        this.setType(2000, "OBJECT");
    }

    @Override
    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        this.m_array.addElement(childElement.getValue());
    }

    public static class IllegalArrayLengthAttributeException
    extends WddxDeserializationException {
        private static final long serialVersionUID = 1L;
        public String attrName;

        public IllegalArrayLengthAttributeException(String attrName) {
            this.attrName = attrName;
        }
    }
}

