/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.ApplicationException;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;
import java.util.Hashtable;

public class ElementFactory {
    private Hashtable m_elementClasses = new Hashtable();

    public WddxElement makeWddxElement(String name) throws WddxDeserializationException {
        try {
            Class wddxElementClass = (Class)this.m_elementClasses.get(name);
            return (WddxElement)wddxElementClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new WddxElementCreationException(name, ex);
        }
    }

    public void registerWddxElement(String name, String className) {
        try {
            Class<?> wddxElementClass = Class.forName(className);
            this.m_elementClasses.put(name, wddxElementClass);
        }
        catch (Throwable ex) {
            throw new WddxElementRegistrationException(name, ex);
        }
    }

    public class WddxElementCreationException
    extends ApplicationException {
        public String elementName;
        public String detailMessage;

        public WddxElementCreationException(String elementName, Throwable rootCause) {
            this.elementName = elementName;
            this.detailMessage = rootCause.getMessage();
        }
    }

    public class WddxElementRegistrationException
    extends ApplicationException {
        public String elementName;
        public String detailMessage;

        public WddxElementRegistrationException(String elementName, Throwable rootCause) {
            this.elementName = elementName;
            this.detailMessage = rootCause.getMessage();
        }
    }
}

