/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.IntegerParser;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ISO8601 {
    public static Date parseDate(String dateString) {
        try {
            StringCharacterIterator it = new StringCharacterIterator(dateString);
            IntegerParser ip = new IntegerParser(it, 10);
            int year = ip.parseInt(4, 4, '-');
            it.next();
            int month = ip.parseInt(1, 2, '-');
            it.next();
            int day = ip.parseInt(1, 2, 'T');
            it.next();
            int hours = ip.parseInt(1, 2, ':');
            it.next();
            int minutes = ip.parseInt(1, 2, ':');
            it.next();
            int seconds = ip.parseInt(1, 2);
            boolean bHasOffset = false;
            int nRawTimezoneOffset = 0;
            char charOffset = it.current();
            if (charOffset != '\uffff') {
                if (charOffset != '+' && charOffset != '-') {
                    return null;
                }
                bHasOffset = true;
                it.next();
                nRawTimezoneOffset = 60 * ip.parseInt(1, 2, ':');
                it.next();
                nRawTimezoneOffset = 60000 * (nRawTimezoneOffset + ip.parseInt(1, 2));
                if (charOffset == '-') {
                    nRawTimezoneOffset *= -1;
                }
                if (it.current() != '\uffff') {
                    return null;
                }
            }
            int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
            int nNetTimezoneOffset = nCurrentTimezoneOffset - nRawTimezoneOffset;
            GregorianCalendar gc = new GregorianCalendar(year, month - 1, day, hours, minutes, seconds);
            int dstSavings = gc.get(16);
            gc.add(14, nNetTimezoneOffset += dstSavings);
            return gc.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stringValueOf(Date date, boolean useTimezoneInfo) {
        StringBuffer sb = new StringBuffer();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        sb.append(gc.get(1));
        sb.append('-');
        ISO8601.adjustPrefixSet(gc.get(2) + 1, sb);
        sb.append('-');
        ISO8601.adjustPrefixSet(gc.get(5), sb);
        sb.append('T');
        ISO8601.adjustPrefixSet(gc.get(11), sb);
        sb.append(':');
        ISO8601.adjustPrefixSet(gc.get(12), sb);
        sb.append(':');
        ISO8601.adjustPrefixSet(gc.get(13), sb);
        if (useTimezoneInfo) {
            int nCurrentTimezoneOffset = TimeZone.getDefault().getRawOffset();
            int dstSavings = gc.get(16);
            int nOffsetInMins = (nCurrentTimezoneOffset += dstSavings) / 60000;
            if (nOffsetInMins < 0) {
                sb.append('-');
                nOffsetInMins *= -1;
            } else {
                sb.append('+');
            }
            ISO8601.adjustPrefixSet(nOffsetInMins / 60, sb);
            sb.append(':');
            ISO8601.adjustPrefixSet(nOffsetInMins % 60, sb);
        }
        return sb.toString();
    }

    static void adjustPrefixSet(int n, StringBuffer sb) {
        if (n < 10) {
            sb.append("0");
        }
        sb.append(n);
    }
}

