/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.BadCharacterDataException;
import coldfusion.wddx.WddxDeserializationException;
import coldfusion.wddx.WddxElement;

class NumberHandler
extends WddxElement {
    private StringBuffer buffer = new StringBuffer();

    NumberHandler() {
    }

    @Override
    public void onEndElement() throws WddxDeserializationException {
        try {
            this.setValue(new Double(this.buffer.toString()));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new BadCharacterDataException("number");
        }
        catch (NumberFormatException e) {
            throw new NumberConversionException();
        }
        this.setType(8, "DOUBLE");
    }

    @Override
    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        this.buffer.append(ch, start, length);
    }

    public static class NumberConversionException
    extends WddxDeserializationException {
    }
}

