/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlNameMatcher;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlAttrMap
extends HashMap {
    private NamedNodeMap attrMap;
    private Element elem;
    protected boolean isCaseSensitive = false;

    public XmlAttrMap(Element element, NamedNodeMap attributesMap, boolean caseSensitive) {
        this.attrMap = attributesMap;
        this.elem = element;
        this.isCaseSensitive = caseSensitive;
    }

    private Attr findAttribute(String name) {
        for (int i = 0; i < this.attrMap.getLength(); ++i) {
            Attr attr = (Attr)this.attrMap.item(i);
            if (!XmlNameMatcher.isMatch(name, attr.getName(), this.isCaseSensitive)) continue;
            return attr;
        }
        return null;
    }

    protected Object resolveName(String name) {
        Attr attr = this.findAttribute(name);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    protected boolean containsName(String name) {
        Attr attr = this.findAttribute(name);
        return attr != null;
    }

    @Override
    public void clear() {
        XmlFunctions.removeAttributes(this.elem);
    }

    @Override
    public boolean isEmpty() {
        return this.attrMap.getLength() == 0;
    }

    @Override
    public int size() {
        return this.attrMap.getLength();
    }
}

