/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.CommandLogger;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.ClearScreen;
import com.adobe.cfsetup.base.CommandHelpRenderer;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.LineReaderBuilderAdobe;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.AddCommand;
import com.adobe.cfsetup.commands.AliasCommand;
import com.adobe.cfsetup.commands.DeleteCommand;
import com.adobe.cfsetup.commands.DeselectCommand;
import com.adobe.cfsetup.commands.ExitCommand;
import com.adobe.cfsetup.commands.ExportCommand;
import com.adobe.cfsetup.commands.GetCommand;
import com.adobe.cfsetup.commands.HelpCommand;
import com.adobe.cfsetup.commands.ImportCommand;
import com.adobe.cfsetup.commands.SelectCommand;
import com.adobe.cfsetup.commands.SetCommand;
import com.adobe.cfsetup.commands.ShowCommand;
import com.adobe.cfsetup.commands.VersionCommand;
import com.adobe.cfsetup.commands.WhichDirCommand;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.json.JsonUtil;
import java.io.DataInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.fusesource.jansi.AnsiConsole;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliJLineCompleter;

@CommandLine.Command(name="", optionListHeading="%nOptions:%n", footer={""}, sortOptions=false)
public class EntryPoint {
    LineReaderImpl reader;
    PrintWriter out;
    public static CommandLine cmd;
    private static EntryPoint command;
    public static boolean isNonInteractive;
    public static boolean isSilent;
    private static final Logger logger;
    public static final String PROMPT = "cfsetup";
    public static HashMap<String, String> userSettingMap;

    public LineReaderImpl getReader() {
        return this.reader;
    }

    public static EntryPoint getCommand() {
        return command;
    }

    private void setReader(LineReader reader) {
        this.reader = (LineReaderImpl)reader;
        this.out = reader.getTerminal().writer();
    }

    public static void main(String[] args) {
        String logProps = System.getProperty("log4j.configuration");
        PropertyConfigurator.configure((String)logProps);
        EntryPoint.readProposedSettings(Util.getConfigHome());
        EntryPoint.registerFromFile(Util.getConfigHome() + File.separator + "registeredAlias.json");
        boolean windows = System.getProperty("os.name").toLowerCase().startsWith("win");
        try {
            if (windows) {
                AnsiConsole.systemInstall();
            }
            cmd = new CommandLine((Object)command);
            EntryPoint.addSubcommands(cmd);
            cmd.setCaseInsensitiveEnumValuesAllowed(true);
            cmd.setUsageHelpWidth(106);
            cmd.setResourceBundle(Messages.isJaLocale() ? Messages.jaBundle : Messages.enBundle);
            CommandHelpRenderer helpRenderer = new CommandHelpRenderer();
            cmd.getSubcommands().forEach((k, v) -> v.getHelpSectionMap().put("description", helpRenderer));
            CommandLine.Help.ColorScheme colorScheme = new CommandLine.Help.ColorScheme.Builder().commands(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bold, CommandLine.Help.Ansi.Style.bg_green}).options(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bg_red}).parameters(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).build();
            cmd.setColorScheme(colorScheme);
            CommandHelpRenderer.setDescription(cmd);
            cmd.setParameterExceptionHandler((ex, arg) -> {
                Category category;
                CommandLine currcmd = ex.getCommandLine();
                if ("help".equalsIgnoreCase(currcmd.getCommandName())) {
                    cmd.usage(System.out, colorScheme);
                    return 0;
                }
                boolean isAdd = "add".equalsIgnoreCase(currcmd.getCommandName());
                if (isAdd && (category = (Category)((Object)((Object)((CommandLine.Model.ArgSpec)currcmd.getCommandSpec().requiredArgs().get(1)).getValue()))) != null && !category.isMultiLevel() && category != Category.SOLR && isAdd) {
                    MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", category.name().toLowerCase()));
                    ((CommandLine.Model.ArgSpec)currcmd.getCommandSpec().requiredArgs().get(1)).setValue(null);
                    Util.showExitMessage(ExitStatus.FAIL);
                    return 0;
                }
                MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
                MessageHandler.getInstance().showInfo(currcmd.getUsageMessage());
                Util.showExitMessage(ExitStatus.FAIL);
                return 0;
            });
            String prompt = "cfsetup>";
            prompt = CommandLine.Help.Ansi.AUTO.string("@|bold,blue, {content}|@").replace("{content}", prompt);
            InputStream inputStream = System.in;
            if (args.length > 0) {
                isNonInteractive = true;
            }
            Terminal terminal = isNonInteractive ? TerminalBuilder.builder().system(true).jna(true).dumb(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build() : TerminalBuilder.builder().system(true).jna(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();
            DefaultParser parser = new DefaultParser();
            parser.setEscapeChars(null);
            LineReader reader = LineReaderBuilderAdobe.builder().terminal(terminal).completer((Completer)new PicocliJLineCompleter(cmd.getCommandSpec())).parser((Parser)parser).build();
            command.setReader(reader);
            if (isNonInteractive) {
                System.exit(cmd.execute(args));
            } else {
                cmd.usage(System.out, colorScheme);
            }
            while (true) {
                try {
                    EntryPoint.takeInput(inputStream, prompt, cmd, reader);
                }
                catch (UserInterruptException e) {
                    logger.error(e.getPartialLine(), (Throwable)e);
                    String line = reader.readLine(Messages.getString("askToTerminate"));
                    if (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes")) {
                        MessageHandler.getInstance().showInfo(Messages.getString("BYE"));
                    }
                    prompt = EntryPoint.getPrompt();
                    continue;
                }
                System.exit(0);
            }
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
            return;
        }
    }

    public static void addSubcommands(CommandLine cmd) {
        LinkedList<Class> commands = new LinkedList<Class>(Arrays.asList(HelpCommand.class, AliasCommand.class, SelectCommand.class, DeselectCommand.class, GetCommand.class, SetCommand.class, ShowCommand.class, AddCommand.class, DeleteCommand.class, ImportCommand.class, ExportCommand.class, ClearScreen.class, VersionCommand.class, WhichDirCommand.class, ExitCommand.class));
        if (AbstractCommand.isLambdaMode()) {
            commands.remove(AliasCommand.class);
            commands.remove(SelectCommand.class);
            commands.remove(DeselectCommand.class);
        }
        for (Class cls : commands) {
            cmd.addSubcommand((Object)cls);
        }
        cmd.getSubcommands().forEach((s, commandLine) -> {
            List<String> customSynopsisList = CommandHelpRenderer.getCustomSynopsis(s);
            commandLine.getCommandSpec().usageMessage().customSynopsis(new String[]{StringUtils.join(customSynopsisList, (String)",")});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeInput(InputStream inputStream, String prompt, CommandLine cmd, LineReader reader) {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        boolean waitforInput = true;
        String line = "";
        CommandLogger commandLogger = null;
        while (waitforInput) {
            try {
                line = reader.readLine(prompt);
                if (line == null || line.isEmpty()) continue;
                commandLogger = CommandLogger.started(line);
                ParsedLine pl = reader.getParser().parse(line, 0);
                Object[] arguments = pl.words().toArray(new String[0]);
                if (ArrayUtils.isNotEmpty((Object[])arguments)) {
                    arguments[0] = ((String)arguments[0]).toLowerCase();
                }
                cmd.execute((String[])arguments);
                prompt = EntryPoint.getPrompt();
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (EndOfFileException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (Objects.nonNull(commandLogger)) {
                    commandLogger.finished();
                }
                commandLogger = null;
            }
        }
    }

    private static void readProposedSettings(String jarPath) {
        try {
            File jsonFile = new File(jarPath + File.separator + "proposedSettings.json");
            userSettingMap = (HashMap)JsonUtil.getJsonObjectMapper().readValue(jsonFile, Map.class);
        }
        catch (Exception e1) {
            MessageHandler.getInstance().showError(Messages.getString("errorReadingSettingFile"));
            System.exit(1);
        }
    }

    private static void registerFromFile(String regFilePath) {
        File regFile = new File(regFilePath);
        if (regFile.exists()) {
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(regFile, "r");
                RegisterInstanceImpl.allInstancesCFHome.putAll((Map)JsonUtil.getJsonObjectMapper().readValue((DataInput)file, Map.class));
                file.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getPrompt() {
        String selectedInstance = RegisterInstanceImpl.getInstance().getAlias();
        return CommandLine.Help.Ansi.AUTO.string("@|bold,blue, {content}|@").replace("{content}", PROMPT) + CommandLine.Help.Ansi.AUTO.string("@|bold,green, {content}|@").replace("{content}", (String)(selectedInstance == null ? "" : ":" + selectedInstance) + ">");
    }

    static {
        command = new EntryPoint();
        isNonInteractive = false;
        isSilent = false;
        logger = LoggerFactory.getLogger(EntryPoint.class);
        userSettingMap = new HashMap();
    }
}

