/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.SettingFactory;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.external.SingleSettingFactory;
import java.io.File;
import java.util.Objects;

public class SettingInstanceProvider {
    private static SettingInstanceProvider settingInstanceProvider = new SettingInstanceProvider();

    private SettingInstanceProvider() {
    }

    public static SettingInstanceProvider getInstance() {
        return settingInstanceProvider;
    }

    public GenericSetting getCategoryInstance(File executionLocation, Category category, boolean useCachedSetting) {
        if (Objects.nonNull(executionLocation) && Objects.nonNull((Object)category)) {
            GenericSetting genericSetting = this.getSettingInstanceFromCFHome(executionLocation.getAbsolutePath(), category, useCachedSetting);
            if (Objects.isNull(genericSetting)) {
                MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
                throw new CFSetupException(Messages.getString("invalidInstance"));
            }
            return genericSetting;
        }
        return null;
    }

    public GenericSetting getSettingInstanceFromCFHome(String cfhome, Category category, boolean useCachedSetting) {
        useCachedSetting = false;
        GenericSetting genericSetting = !useCachedSetting || !cfhome.equalsIgnoreCase(RegisterInstanceImpl.getInstance().getSelectedInstPath()) ? SingleSettingFactory.initiateSettingClass(category, cfhome) : SettingFactory.factories.get(cfhome).getSetting(category);
        return genericSetting;
    }
}

