/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.base;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.constants.CFVersions;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SettingsDictionary {
    private static final Map<CFVersions, Set<Category>> supportedCategoriesMap = SettingsDictionary.getJsonMap();

    public static boolean isCategoriesSupported(CFVersions versions, Category category) {
        return supportedCategoriesMap.containsKey((Object)versions) && supportedCategoriesMap.get((Object)versions).contains((Object)category);
    }

    private SettingsDictionary() {
    }

    public static boolean isSupportedVersion(Category category, String instancePath) {
        CFVersions version = RegisterInstanceImpl.getInstance().getCFVersionFromJar(instancePath);
        if (!SettingsDictionary.isCategoriesSupported(version, category)) {
            MessageHandler.getInstance().showError(Messages.getString("categoryNotSupportedForVersion", category.name(), version.name().replace("CF", "ColdFusion")));
            throw new CFSetupException(Messages.getString("categoryNotSupportedForVersion", category.name(), version.name().replace("CF", "ColdFusion")));
        }
        return true;
    }

    public static Set<Category> listSupportedCategories(CFVersions cfVersions) {
        return Collections.unmodifiableSet(supportedCategoriesMap.get((Object)cfVersions));
    }

    public static Set<Category> listSupportedCategories(String instancePath) {
        return Collections.unmodifiableSet(supportedCategoriesMap.get((Object)RegisterInstanceImpl.getInstance().getCFVersionFromJar(instancePath)));
    }

    private static Map<CFVersions, Set<Category>> getJsonMap() {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<CFVersions, Set<Category>> myMap = new HashMap<CFVersions, Set<Category>>();
        try {
            InputStream in = SettingsDictionary.class.getClassLoader().getResourceAsStream("CFDefinedSettings.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            byte[] mapData = reader.lines().collect(Collectors.joining("\n")).getBytes();
            HashMap map = (HashMap)objectMapper.readValue(mapData, HashMap.class);
            map.forEach((version, categoryList) -> {
                HashSet supportedCategories = new HashSet();
                ((List)categoryList).forEach(o -> supportedCategories.add(Category.of(o)));
                myMap.put(CFVersions.valueOf(String.valueOf(version)), supportedCategories);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return myMap;
    }
}

