/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.CommandHelpRenderer;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.base.SettingsDictionary;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.commands.ExportCommand;
import com.adobe.cfsetup.commands.service.ImportCommandService;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.json.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="import", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class ImportCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="2..5", hidden=true)
    private List<String> args;
    private List<String> categories;
    @CommandLine.Option(names={"-p", "-P"}, description={"provides passphrase to encrypt sensitive information"})
    String passphrase;
    private String jsonFilePath;
    private static final Logger logger = LoggerFactory.getLogger(ImportCommand.class);
    private Map<String, Object> keyValueMap;
    private List<String> allowedImportSettings = Arrays.asList("jee.port", "jee.contextroot");

    @Override
    public CommandInfo parseCommand() {
        this.keyValueMap = new HashMap<String, Object>();
        int startIndex = 2;
        int lastIndex = this.args.size() - 1;
        this.categories = Arrays.asList(this.args.get(0).split(","));
        this.jsonFilePath = this.args.get(1);
        String lastCliArg = this.args.get(lastIndex);
        String executionPath = lastCliArg.contains("=") || this.jsonFilePath.equals(lastCliArg) ? this.getExecutionPathForLambda(this.args) : lastCliArg;
        List<String> importSettings = this.args.size() <= 2 || executionPath == null ? this.args.subList(startIndex, lastIndex + 1) : this.args.subList(startIndex, lastIndex);
        for (String importSetting : importSettings) {
            String[] settingPair = importSetting.split("=");
            if (settingPair.length < 2) {
                MessageHandler.getInstance().showError(Messages.getString("provideArguments"));
                MessageHandler.getInstance().showError(CommandHelpRenderer.getCommandHelpMessage("import"));
                throw new CFSetupException(Messages.getString("invalidSettingKeyPair"));
            }
            String settingKey = settingPair[0];
            String settingValue = Util.trimQuotes(settingPair[1]);
            this.keyValueMap.put(settingKey, settingValue);
        }
        this.keyValueMap = Collections.unmodifiableMap(this.keyValueMap);
        Util.setImportSettingsMap(this.keyValueMap);
        return CommandInfo.builder().executionPath(executionPath).build();
    }

    @Override
    public boolean validateCommand() {
        if (!Util.isValidCategoryOrAll(this.categories)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            throw new CFSetupException(Messages.getString("invalidSettingCategory"));
        }
        if (!JsonUtil.isValidJsonFile(this.jsonFilePath)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidJson"));
            throw new CFSetupException(Messages.getString("invalidJson"));
        }
        if (this.getExecutionFile() == null) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            throw new CFSetupException(Messages.getString("invalidInstance"));
        }
        if (Util.isJEEDeployment(this.getExecutionFile().getAbsolutePath())) {
            if (this.categories.stream().anyMatch(category -> Category.PROBE.name().equalsIgnoreCase((String)category) || "all".equalsIgnoreCase((String)category))) {
                if (this.keyValueMap.isEmpty()) {
                    this.handleEmptyKeyValueMap();
                } else {
                    this.handleNonEmptyKeyValueMap();
                }
            }
        } else {
            this.handleUnsupportedImportSettings();
        }
        if (Objects.nonNull(this.passphrase)) {
            boolean isValid = Util.isValidPassprase(this.passphrase);
            if (!isValid) {
                MessageHandler.getInstance().showError(Messages.getString("invalidPassphrase"));
            }
            return isValid;
        }
        return true;
    }

    private void handleEmptyKeyValueMap() throws CFSetupException {
        String importSettingsListWithCommas = this.getImportSettingsListWithCommas();
        this.showErrorAndThrowException(Messages.getString("import.requiredImportSettings", importSettingsListWithCommas));
    }

    private void handleNonEmptyKeyValueMap() throws CFSetupException {
        String contextRoot;
        String port;
        if (!this.keyValueMap.keySet().containsAll(this.allowedImportSettings)) {
            String importSettingsListWithCommas = this.getImportSettingsListWithCommas();
            this.showErrorAndThrowException(Messages.getString("import.requiredImportSettings", importSettingsListWithCommas));
        }
        this.keyValueMap.keySet().forEach(importSetting -> {
            if (!this.allowedImportSettings.contains(importSetting.toLowerCase())) {
                String importSettingsListWithCommas = this.getImportSettingsListWithCommas();
                this.showErrorAndThrowException(Messages.getString("import.invalidImportSettings", importSetting, importSettingsListWithCommas));
            }
        });
        if (this.keyValueMap.containsKey("jee.port") && !Util.isValidPort(port = (String)this.keyValueMap.get("jee.port"))) {
            port = port.trim().length() == 0 ? "Empty string" : port;
            this.showErrorAndThrowException(Messages.getString("import.invalidPort", port));
        }
        if (this.keyValueMap.containsKey("jee.contextroot") && (contextRoot = (String)this.keyValueMap.get("jee.contextroot")) != null && contextRoot.trim().length() == 0) {
            this.showErrorAndThrowException(Messages.getString("import.invalidContextRoot"));
        }
    }

    private void handleUnsupportedImportSettings() throws CFSetupException {
        if (!this.keyValueMap.isEmpty()) {
            String unsupportedImportSettingsListWithCommas = this.keyValueMap.keySet().stream().collect(Collectors.joining(", "));
            this.showErrorAndThrowException(Messages.getString("import.unsupportedImportSettings", unsupportedImportSettingsListWithCommas));
        }
    }

    private String getImportSettingsListWithCommas() {
        return this.allowedImportSettings.stream().collect(Collectors.joining(", "));
    }

    private void showErrorAndThrowException(String errorMessage) throws CFSetupException {
        MessageHandler.getInstance().showError(errorMessage);
        MessageHandler.getInstance().showError(CommandHelpRenderer.getCommandHelpMessage("import"));
        throw new CFSetupException(errorMessage);
    }

    @Override
    public ExitStatus runCommand() {
        try {
            List<Category> categoriesEnum = this.categories.get(0).equalsIgnoreCase("all") ? new LinkedList<Category>(SettingsDictionary.listSupportedCategories(this.getExecutionFile().getAbsolutePath())) : this.categories.stream().filter(v -> {
                if (ExportCommand.exportBlackList.contains((Object)Category.of(v))) {
                    MessageHandler.getInstance().showError(Messages.getString("exportAndImportNotAllowedFor", v));
                    return false;
                }
                return true;
            }).map(Category::of).collect(Collectors.toList());
            categoriesEnum = new LinkedList<Category>(categoriesEnum);
            categoriesEnum.removeAll(ExportCommand.exportBlackList);
            Map jsonMap = JsonUtil.getJsonMapFromFile(this.jsonFilePath);
            if (jsonMap == null) {
                return ExitStatus.FAIL;
            }
            categoriesEnum.sort(Comparator.comparing(Enum::name));
            ExitStatus exitStatus = this.importSettings(categoriesEnum, jsonMap) ? ExitStatus.SUCCESS : ExitStatus.FAIL;
            return exitStatus;
        }
        catch (Exception e) {
            logger.error("Import Failed", (Throwable)e);
            MessageHandler.getInstance().showError(Messages.getString("errorImport", Optional.ofNullable(e.getLocalizedMessage()).orElse("")));
            return ExitStatus.FAIL;
        }
    }

    private boolean importSettings(List<Category> newCategories, Map jsonMap) throws IOException {
        Map<String, String> seedInfo = null;
        if (jsonMap.containsKey("seedInfo")) {
            Object object = jsonMap.get("seedInfo");
            if (object instanceof Map) {
                seedInfo = (Map<String, String>)object;
            } else {
                String passphrase = StringUtils.isEmpty((CharSequence)this.passphrase) ? Util.getPassphrase() : this.passphrase;
                String encryptedInfo = (String)object;
                seedInfo = Util.decryptMap(passphrase, encryptedInfo);
            }
            jsonMap.remove("seedInfo");
        }
        HashMap<Category, Boolean> categoryStatusMap = new HashMap<Category, Boolean>();
        String service = "";
        File f = null;
        GenericSetting genericSetting = null;
        long timestamp = System.currentTimeMillis();
        for (Category category : newCategories) {
            try {
                if (Util.isCategoryDisabled(this.getExecutionFile().getAbsolutePath(), category.name())) continue;
                genericSetting = SettingInstanceProvider.getInstance().getCategoryInstance(this.getExecutionFile(), category, false);
                f = JsonUtil.takeBackUp(genericSetting, timestamp);
                if (Objects.isNull(genericSetting)) {
                    categoryStatusMap.put(category, false);
                }
                if (Objects.isNull(jsonMap.get(category.name())) || !(jsonMap.get(category.name()) instanceof Map) || MapUtils.isEmpty((Map)((Map)jsonMap.get(category.name())))) {
                    MessageHandler.getInstance().showWarning(Messages.getString("NoDataForCategory", category.name()));
                    continue;
                }
                Map inputMap = (Map)jsonMap.get(category.name());
                boolean status = false;
                for (Map.Entry inputEntry : inputMap.entrySet()) {
                    service = (String)inputEntry.getKey();
                    Object serviceValue = inputEntry.getValue();
                    if (serviceValue instanceof Map) {
                        if (genericSetting instanceof MultilevelSetting) {
                            status = ImportCommandService.INSTANCE.importService(service, (Map)serviceValue, (MultilevelSetting)genericSetting, this.getExecutionFile(), seedInfo);
                        } else {
                            status = ((Map)serviceValue).isEmpty();
                            for (Map.Entry entry2 : ((Map)serviceValue).entrySet()) {
                                status = ImportCommandService.INSTANCE.importSetting(service, (String)entry2.getKey(), entry2.getValue(), genericSetting, this.getExecutionFile(), seedInfo);
                            }
                        }
                    } else {
                        status = ImportCommandService.INSTANCE.importSetting("", service, serviceValue, genericSetting, this.getExecutionFile(), seedInfo);
                    }
                    if (!status) {
                        MessageHandler.getInstance().showError(Messages.getString("importUnSuccessful2", service, category.name()));
                    }
                    categoryStatusMap.put(category, categoryStatusMap.get((Object)category) == null ? status : (Boolean)categoryStatusMap.get((Object)category) != false && status);
                }
                if (((Boolean)categoryStatusMap.get((Object)category)).booleanValue()) continue;
                JsonUtil.replaceBackup(genericSetting, f);
            }
            catch (Exception e) {
                JsonUtil.replaceBackup(genericSetting, f);
                logger.error(e.getMessage(), (Throwable)e);
                if (StringUtils.isNotBlank((CharSequence)e.getLocalizedMessage())) {
                    MessageHandler.getInstance().showError(e.getLocalizedMessage());
                }
                if (StringUtils.isNotBlank((CharSequence)service)) {
                    MessageHandler.getInstance().showError(Messages.getString("importUnSuccessful2", service, category.name()));
                } else {
                    MessageHandler.getInstance().showError(Messages.getString("importUnSuccessful", category.name()));
                }
                categoryStatusMap.put(category, false);
            }
        }
        String unSuccessfulCategories = StringUtils.join((Iterable)categoryStatusMap.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> ((Category)((Object)((Object)entry.getKey()))).name()).collect(Collectors.toList()), (String)", ");
        String successfulCategories = StringUtils.join((Iterable)categoryStatusMap.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> ((Category)((Object)((Object)entry.getKey()))).name()).collect(Collectors.toList()), (String)", ");
        if (StringUtils.isNotBlank((CharSequence)successfulCategories)) {
            MessageHandler.getInstance().showGreenAndBold(Messages.getString("importSuccess", successfulCategories), true);
        }
        if (StringUtils.isNotBlank((CharSequence)unSuccessfulCategories)) {
            MessageHandler.getInstance().showError(Messages.getString("importUnSuccessful", unSuccessfulCategories));
        }
        MessageHandler.getInstance().showInfo(Messages.getString("backupTaken", this.getExecutionFile().getAbsolutePath() + File.separator + "lib" + File.separator + "cfsetup_backup" + File.separator + timestamp));
        return unSuccessfulCategories.isEmpty();
    }

    public Integer call() {
        AbstractCommand.commandName = CommandName.IMPORT;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.passphrase = null;
        this.args = null;
        this.jsonFilePath = null;
        this.categories = null;
        this.keyValueMap = null;
    }
}

