/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.commands;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.CommandExecutionPipeline;
import com.adobe.cfsetup.base.ExitStatus;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.base.SettingsDictionary;
import com.adobe.cfsetup.bean.CommandInfo;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="show", descriptionHeading="%nDescription: ", synopsisHeading="Usage Pattern:%n")
public class ShowCommand
extends AbstractCommand {
    @CommandLine.Parameters(paramLabel="", arity="1..3", hidden=true)
    public List<String> show;
    private boolean showAlias = false;
    private boolean showAllSettings = false;
    private boolean showCategory = false;
    private static final Logger logger = LoggerFactory.getLogger(ShowCommand.class);

    public Integer call() {
        AbstractCommand.commandName = CommandName.SHOW;
        return CommandExecutionPipeline.PIPELINE.submitToPipeline(this);
    }

    @Override
    public CommandInfo parseCommand() {
        String executionPath = null;
        String firstArgument = this.show.get(0);
        if (firstArgument.equalsIgnoreCase("all")) {
            String string = executionPath = this.show.size() == 2 ? this.show.get(1) : this.getExecutionPathForLambda(this.show);
            if (this.show.size() > 2) {
                MessageHandler.getInstance().showError(Messages.getString("incorrectCmdShowAll"));
                throw new CFSetupException(Messages.getString("incorrectCmdShowAll"));
            }
            this.showAllSettings = true;
            return CommandInfo.builder().executionPath(executionPath).service("*").build();
        }
        if (firstArgument.equalsIgnoreCase("alias")) {
            if (this.show.size() > 1) {
                MessageHandler.getInstance().showError(Messages.getString("incorrectCmdAliasList"));
                throw new CFSetupException(Messages.getString("incorrectCmdAliasList"));
            }
            this.showAlias = true;
            return CommandInfo.builder().build();
        }
        if (firstArgument.equalsIgnoreCase("category")) {
            if (this.show.size() > 1) {
                MessageHandler.getInstance().showError(Messages.getString("incorrectCmdCategoryList"));
                throw new CFSetupException(Messages.getString("incorrectCmdCategoryList"));
            }
            this.showCategory = true;
            return CommandInfo.builder().build();
        }
        Category category = Category.of(firstArgument);
        String service = null;
        if (this.show.size() > 0) {
            executionPath = this.getExecutionPathForLambda(this.show);
        }
        if (this.show.size() > 1) {
            service = this.show.get(1);
            executionPath = this.show.get(this.show.size() - 1);
            if (executionPath.equals(service)) {
                if (!Util.isInstance(executionPath) && !Util.validCFHome(new File(executionPath))) {
                    service = executionPath;
                    executionPath = null;
                } else {
                    service = null;
                }
            }
        }
        return CommandInfo.builder().executionPath(executionPath).category(category).service(service).build();
    }

    private boolean isValidFile(String executionPath) {
        if (executionPath.endsWith(".json")) {
            return true;
        }
        File file = new File(executionPath);
        return file.exists() && file.isDirectory();
    }

    @Override
    public boolean validateCommand() {
        if (!(this.showAlias || this.showCategory || Util.validateExecutionPath(this.getExecutionFile()))) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            return false;
        }
        return true;
    }

    @Override
    public ExitStatus runCommand() {
        AbstractCommand.commandName = CommandName.SHOW;
        if (this.showAlias) {
            return this.printRegisteredInstances(this.show) ? ExitStatus.SUCCESS : ExitStatus.FAIL;
        }
        if (this.showCategory) {
            this.printCategories();
            return ExitStatus.SUCCESS;
        }
        if (this.showAllSettings) {
            return this.showAllSettingFromInstance(this.getExecutionFile().getAbsolutePath()) ? ExitStatus.SUCCESS : ExitStatus.FAIL;
        }
        if (Objects.isNull(this.getGenericSetting())) {
            MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
            return ExitStatus.FAIL;
        }
        try {
            this.getGenericSetting().show(this.getCommandInfo().getService());
            return ExitStatus.SUCCESS;
        }
        catch (NotImplementedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ExitStatus.FAIL;
        }
        catch (CFSetupException e) {
            logger.error(e.getMessage(), (Throwable)e);
            MessageHandler.getInstance().showError(e.getLocalizedMessage());
            return ExitStatus.FAIL;
        }
    }

    private boolean printCategories() {
        Category[] categories = Category.getValues();
        Arrays.sort(categories, new Category.CategoryComparator());
        for (Category category : categories) {
            MessageHandler.getInstance().showInfo(category.name());
        }
        return true;
    }

    public boolean printRegisteredInstances(List<String> show) {
        Map<String, String> regInstances = RegisterInstanceImpl.allInstancesCFHome;
        if (regInstances == null || regInstances.isEmpty()) {
            MessageHandler.getInstance().showError(Messages.getString("noInstanceRegistered"));
            return false;
        }
        if (show.size() > 1) {
            String cfHome = show.get(1);
            if (!regInstances.containsValue(cfHome)) {
                MessageHandler.getInstance().showError(Messages.getString("invalidInstance"));
                return false;
            }
            for (String key : regInstances.keySet()) {
                if (!cfHome.equals(regInstances.get(key))) continue;
                String alias = key.toString();
                alias = alias.substring(0, alias.length() - 6);
                System.out.println(alias);
                break;
            }
        } else {
            for (String key : regInstances.keySet()) {
                String alias = key.toString();
                alias = alias.substring(0, alias.length() - 6);
                String cfhome = regInstances.get(key);
                System.out.println(alias + "\t" + cfhome);
            }
        }
        return true;
    }

    private boolean showAllSettingFromInstance(String cfhome) {
        boolean success = true;
        for (Category category : SettingsDictionary.listSupportedCategories(this.getExecutionFile().getAbsolutePath())) {
            if (Util.isCategoryDisabled(cfhome, category.name()) || category == Category.SECURITY) continue;
            success = success && this.showSettingsFromInstance(category);
        }
        return success;
    }

    public boolean showSettingsFromInstance(Category category) {
        GenericSetting genericSetting = SettingInstanceProvider.getInstance().getCategoryInstance(this.getExecutionFile(), category, this.isUseCachedSetting());
        try {
            genericSetting.show(this.getCommandInfo().getService());
            return true;
        }
        catch (NotImplementedException e) {
            return false;
        }
        catch (CFSetupException e) {
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.showAlias = false;
        this.showAllSettings = false;
        this.showCategory = false;
    }
}

