/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.constants;

import com.adobe.cfsetup.base.EntryPoint;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;

public class Messages {
    public static ResourceBundle enBundle;
    public static ResourceBundle jaBundle;
    private static final List<String> silentMessageKeys;

    public static String getString(String key) {
        if (Messages.isJaLocale()) {
            return Messages.getString(jaBundle, key);
        }
        return Messages.getString(enBundle, key);
    }

    public static String getString(String key, String ... parameters) {
        if (silentMessageKeys.contains(key) && EntryPoint.isSilent) {
            return null;
        }
        String message = Messages.isJaLocale() ? Messages.getString(jaBundle, key) : Messages.getString(enBundle, key);
        StringBuilder sb = new StringBuilder(message);
        if (sb.length() > 0) {
            sb.replace(0, 1, String.valueOf(sb.charAt(0)).toUpperCase());
        }
        message = sb.toString();
        for (int i = 0; i < parameters.length; ++i) {
            message = message.replace("{" + i + "}", Optional.ofNullable(parameters[i]).orElse("null"));
        }
        return message;
    }

    public static String getString(ResourceBundle bundle, String key) {
        if (Boolean.getBoolean("LAMBDAMODE") && ((String)key).equals("invalidInstance")) {
            key = (String)key + "Serverless";
        }
        return bundle.getString((String)key);
    }

    public static boolean isJaLocale() {
        return "JA".equalsIgnoreCase(System.getProperty("user.country")) || "JP".equalsIgnoreCase(System.getProperty("user.country")) || "ja".equalsIgnoreCase(System.getProperty("user.language"));
    }

    static {
        silentMessageKeys = Arrays.asList("SettingKeyNotPresentInTargetFile");
        enBundle = ResourceBundle.getBundle("resource");
        Locale japaneseLocale = new Locale("ja");
        jaBundle = ResourceBundle.getBundle("resource", japaneseLocale);
    }
}

