/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.external;

import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.SettingsDictionary;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.AdminLdapConfigSettings;
import com.adobe.cfsetup.settings.AdminSamlConfigSettings;
import com.adobe.cfsetup.settings.CachingSettings;
import com.adobe.cfsetup.settings.ClientVariableSettings;
import com.adobe.cfsetup.settings.CloudConfigSettings;
import com.adobe.cfsetup.settings.CronSettings;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.DebugSettings;
import com.adobe.cfsetup.settings.DocumentSettings;
import com.adobe.cfsetup.settings.EventGatewayGlobalSettings;
import com.adobe.cfsetup.settings.EventGatewayInstanceSettings;
import com.adobe.cfsetup.settings.EventGatewayTypeSettings;
import com.adobe.cfsetup.settings.GraphQLClientSettings;
import com.adobe.cfsetup.settings.GraphQLServiceSettings;
import com.adobe.cfsetup.settings.JvmSettings;
import com.adobe.cfsetup.settings.LoggingSettings;
import com.adobe.cfsetup.settings.MailSettings;
import com.adobe.cfsetup.settings.MonitoringSettings;
import com.adobe.cfsetup.settings.NoSqlSettings;
import com.adobe.cfsetup.settings.PdfServiceSettings;
import com.adobe.cfsetup.settings.ProbeConfigSettings;
import com.adobe.cfsetup.settings.ProbeSettings;
import com.adobe.cfsetup.settings.RestSettings;
import com.adobe.cfsetup.settings.RpcSettings;
import com.adobe.cfsetup.settings.RuntimeSettings;
import com.adobe.cfsetup.settings.SandboxSettings;
import com.adobe.cfsetup.settings.ServerSetting;
import com.adobe.cfsetup.settings.SolrSettings;
import com.adobe.cfsetup.settings.UserSettings;
import com.adobe.cfsetup.settings.nested.CloudVendorCredentialSettings;
import com.adobe.cfsetup.settings.nested.CustomTagsSettings;
import com.adobe.cfsetup.settings.nested.MappingsSettings;
import com.adobe.cfsetup.settings.nested.SamlIdentityProviderSettings;
import com.adobe.cfsetup.settings.nested.SamlServiceProviderSettings;
import com.adobe.cfsetup.settings.simple.AdminPasswordSettings;
import com.adobe.cfsetup.settings.simple.DotnetSettings;
import com.adobe.cfsetup.settings.simple.GraphingSettings;
import com.adobe.cfsetup.settings.simple.MetricSettings;
import com.adobe.cfsetup.settings.simple.WatchSettings;
import com.adobe.cfsetup.settings.simple.WebsocketSettings;

public class SingleSettingFactory {
    public static GenericSetting initiateSettingClass(Category category, String instancePath) {
        SettingsDictionary.isSupportedVersion(category, instancePath);
        switch (category) {
            case EVENTGATEWAYINSTANCE: {
                return new EventGatewayInstanceSettings(instancePath);
            }
            case EVENTGATEWAYSETTING: {
                return new EventGatewayGlobalSettings(instancePath);
            }
            case EVENTGATEWAYTYPE: {
                return new EventGatewayTypeSettings(instancePath);
            }
            case SOLR: {
                return new SolrSettings(instancePath);
            }
            case SECURITY: {
                return new AdminPasswordSettings(instancePath);
            }
            case REST: {
                return new RestSettings(instancePath);
            }
            case JVM: {
                return new JvmSettings(instancePath);
            }
            case PROBE: {
                return new ProbeSettings(instancePath);
            }
            case SCHEDULETASK: {
                return new CronSettings(instancePath);
            }
            case WEBSERVICE: {
                return new RpcSettings(instancePath);
            }
            case SERVER: {
                return new ServerSetting(instancePath);
            }
            case PROBECONFIG: {
                return new ProbeConfigSettings(instancePath);
            }
            case NOSQL: {
                return new NoSqlSettings(instancePath);
            }
            case LOGGING: {
                return new LoggingSettings(instancePath);
            }
            case DOCUMENT: {
                return new DocumentSettings(instancePath);
            }
            case PDFSERVICE: {
                return new PdfServiceSettings(instancePath);
            }
            case CUSTOMTAG: {
                return new CustomTagsSettings(instancePath);
            }
            case DEBUG: {
                return new DebugSettings(instancePath);
            }
            case CACHING: {
                return new CachingSettings(instancePath);
            }
            case MAPPING: {
                return new MappingsSettings(instancePath);
            }
            case SPCONFIGURATION: {
                return new SamlServiceProviderSettings(instancePath);
            }
            case IDPCONFIGURATION: {
                return new SamlIdentityProviderSettings(instancePath);
            }
            case CLOUDCREDENTIAL: {
                return new CloudVendorCredentialSettings(instancePath);
            }
            case CLOUDCONFIGURATION: {
                return new CloudConfigSettings(instancePath);
            }
            case DATASOURCE: {
                return new DatasourceSettings(instancePath);
            }
            case DOTNET: {
                return new DotnetSettings(instancePath);
            }
            case CHART: {
                return new GraphingSettings(instancePath);
            }
            case MAIL: {
                return new MailSettings(instancePath);
            }
            case METRIC: {
                return new MetricSettings(instancePath);
            }
            case RUNTIME: {
                return new RuntimeSettings(instancePath);
            }
            case WATCH: {
                return new WatchSettings(instancePath);
            }
            case WEBSOCKET: {
                return new WebsocketSettings(instancePath);
            }
            case CLIENTVARIABLE: {
                return new ClientVariableSettings(instancePath);
            }
            case MONITORING: {
                return new MonitoringSettings(instancePath);
            }
            case USER: {
                return new UserSettings(instancePath);
            }
            case SANDBOX: {
                return new SandboxSettings(instancePath);
            }
            case SAMLCONFIG: {
                return new AdminSamlConfigSettings(instancePath);
            }
            case LDAPCONFIG: {
                return new AdminLdapConfigSettings(instancePath);
            }
            case GRAPHQLCLIENTCONFIG: {
                return new GraphQLClientSettings(instancePath);
            }
            case GRAPHQLSERVICECONFIG: {
                return new GraphQLServiceSettings(instancePath);
            }
        }
        throw new CFSetupException("CFSetup is not registered for " + category.name());
    }
}

