/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.RuntimeSettings;
import com.adobe.cfsetup.settings.service.RuntimeService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSettings
extends MultiConfigurationBase {
    private static final String CACHE = "cache";
    private static final String GLOBAL = "global";
    private File runtimeXmlFile;
    private Map<String, Map<String, Object>> cachingMap = new HashMap<String, Map<String, Object>>();
    private static final Logger logger = LoggerFactory.getLogger(RuntimeSettings.class);
    private RuntimeService service;

    public CachingSettings(String instancePath) {
        super(instancePath);
        this.runtimeXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.RUNTIME.getFileName());
        this.service = new RuntimeService(this.runtimeXmlFile, this.runtimeXmlFile.getAbsoluteFile().getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public void populateMap() {
        Map<String, Object> cachingSettings = this.service.getCacheSettings();
        Map<String, Object> runtimeCacheSetting = this.service.getRuntimeCacheSetting();
        this.cachingMap.put(CACHE, Optional.ofNullable(cachingSettings).orElse(new HashMap()));
        this.cachingMap.put(GLOBAL, Optional.ofNullable(runtimeCacheSetting).orElse(new HashMap()));
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return null;
        }
        String[] str = name.split("/");
        Map settingMap = this.cachingMap;
        for (int i = 0; i < str.length - 1; ++i) {
            Map map = settingMap.getOrDefault(str[i], new HashMap());
            if (i == str.length - 2) {
                return String.valueOf(map.get(str[str.length - 1]));
            }
            settingMap = map;
        }
        return null;
    }

    @Override
    public Category getCategory() {
        return Category.CACHING;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("ServiceNotRequired"));
            return false;
        }
        String[] str = name.split("/");
        Map settingMap = this.cachingMap;
        for (int i = 0; i < str.length - 1; ++i) {
            Map map = settingMap.getOrDefault(str[i], new HashMap());
            if (i == str.length - 2) {
                map.put(str[str.length - 1], value);
                continue;
            }
            settingMap = map;
        }
        return this.saveModifiedMap();
    }

    private boolean saveModifiedMap() {
        this.service.setCacheSettings(this.cachingMap.get(CACHE));
        return true;
    }

    @Override
    public File getXMLFileObject() {
        return this.runtimeXmlFile;
    }

    @Override
    public Map<String, ?> getMap() {
        HashMap showMap = new HashMap();
        String setting = "";
        this.cachingMap.forEach((name, nmap) -> {
            String los = setting + name;
            nmap.forEach((key, value) -> {
                if (value instanceof Map) {
                    RuntimeSettings.addMapToShow((Map)value, showMap, los + "/" + key);
                } else if (value instanceof String) {
                    if (StringUtils.isNotBlank((CharSequence)((String)value))) {
                        showMap.put(los + "/" + key, value);
                    }
                } else if (Objects.nonNull(value)) {
                    showMap.put(los + "/" + key, value);
                }
            });
        });
        return showMap;
    }
}

