/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.cloud.CloudServiceName;
import coldfusion.cloud.config.CloudConfigService;
import coldfusion.cloud.exception.ValidationException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(CloudConfigSettings.class);
    private static final String NAME = "alias";
    private Map<String, Map<String, Object>> cloudConfigMap;
    private final File cloudConfigXmlFile;
    private CloudConfigService cloudConfigService;
    Map<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public CloudConfigSettings(String instancePath) {
        super(instancePath);
        this.cloudConfigMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.cloudConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.getCategory().getFileName());
        this.cloudConfigService = new CloudConfigService(this.cloudConfigXmlFile);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        return this.flatMap;
    }

    public Map<String, Object> getInternalMap() {
        return Util.getInternalMap(this.flatMap, this.getCategory());
    }

    @Override
    public File getXMLFileObject() {
        return this.cloudConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.CLOUDCONFIGURATION;
    }

    @Override
    public void populateMap() {
        this.cloudConfigMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.cloudConfigService.getAllConfigData().forEach((key, value) -> this.cloudConfigMap.put(String.valueOf(key), (Map)value));
        this.flatMap = Util.createFlatMap(this.getCategory(), this.cloudConfigMap);
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name()));
            return null;
        }
        if (!this.cloudConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return null;
        }
        Object value = Util.getSettingValue(name, service, this.cloudConfigMap);
        if (Objects.nonNull(value)) {
            return String.valueOf(value);
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
        return null;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.cloudConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        if (name.equalsIgnoreCase("serviceName") || name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        try {
            Map options;
            HashMap<String, Object> clonedCloudConfig;
            Map<String, Object> cloudConfig = this.cloudConfigMap.get(service);
            if (NAME.equalsIgnoreCase(name)) {
                this.cloudConfigMap.remove(service);
                this.cloudConfigMap.put(String.valueOf(newValue), cloudConfig);
            }
            String[] order = name.split("/");
            Map<String, Object> settingMap = clonedCloudConfig = new HashMap<String, Object>(cloudConfig);
            for (int i = 0; i < order.length - 1; ++i) {
                HashMap settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                    if (settingValue instanceof Map) {
                        settingValue = new HashMap(settingValue);
                    }
                } else {
                    settingValue = new HashMap();
                }
                settingMap.put(order[i], settingValue);
                settingMap = settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put(settingKey, newValue);
            if (clonedCloudConfig.containsKey("options") && (options = (Map)clonedCloudConfig.get("options")).containsKey("retryPolicyFactory")) {
                Map retryPolicyDFactory = (Map)options.get("retryPolicyFactory");
                switch (Util.getString(retryPolicyDFactory.getOrDefault("retryPolicyType", "NONE"))) {
                    case "EXPONENTIAL": {
                        break;
                    }
                    case "LINEAR": {
                        retryPolicyDFactory.remove("resolvedMinBackoff");
                        retryPolicyDFactory.remove("resolvedMaxBackoff");
                        break;
                    }
                    default: {
                        retryPolicyDFactory.remove("maximumAttempts");
                        retryPolicyDFactory.remove("deltaBackoffIntervalInMs");
                        retryPolicyDFactory.remove("resolvedMinBackoff");
                        retryPolicyDFactory.remove("resolvedMaxBackoff");
                    }
                }
            }
            this.cloudConfigService.modifyConfigData(service, clonedCloudConfig);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean addService(Object val) {
        try {
            Map<String, Object> map = (Map<String, Object>)val;
            map = Util.expandNestedFields(map);
            String alias = (String)map.get(NAME);
            if (this.cloudConfigMap.containsKey(alias)) {
                this.cloudConfigService.modifyConfigData(alias, map);
            } else {
                this.cloudConfigService.addConfigData(map);
            }
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(Map<String, Object> keyValue, String service) {
        if (StringUtils.isBlank((CharSequence)service) && Objects.isNull(keyValue.get(NAME))) {
            return false;
        }
        if (CloudServiceName.AZURE_BLOB.name().equalsIgnoreCase(Util.getString(keyValue.get("serviceName")))) {
            Integer resolvedMinBackoff;
            Integer resolvedMaxBackoff;
            Integer maximumAttempts;
            Integer deltaBackoffIntervalInMs;
            String alias = StringUtils.isBlank((CharSequence)service) ? Util.getString(keyValue.get(NAME)) : service;
            String retryPolicyType = "options/retryPolicyFactory/retryPolicyType";
            String deltaBackoffIntervalInMsKey = "options/retryPolicyFactory/deltaBackoffIntervalInMs";
            String maximumAttemptsKey = "options/retryPolicyFactory/maximumAttempts";
            String resolvedMaxBackoffKey = "options/retryPolicyFactory/resolvedMaxBackoff";
            String resolvedMinBackoffKey = "options/retryPolicyFactory/resolvedMinBackoff";
            switch (retryPolicyType = Optional.ofNullable(Util.getString(keyValue.getOrDefault(retryPolicyType, this.getExisting(alias, retryPolicyType)))).orElse("NONE")) {
                case "EXPONENTIAL": {
                    deltaBackoffIntervalInMs = Util.getInt(keyValue.getOrDefault(deltaBackoffIntervalInMsKey, this.getExisting(service, deltaBackoffIntervalInMsKey)));
                    maximumAttempts = Util.getInt(keyValue.getOrDefault(maximumAttemptsKey, this.getExisting(service, maximumAttemptsKey)));
                    resolvedMaxBackoff = Util.getInt(keyValue.getOrDefault(resolvedMaxBackoffKey, this.getExisting(service, resolvedMaxBackoffKey)));
                    resolvedMinBackoff = Util.getInt(keyValue.getOrDefault(resolvedMinBackoffKey, this.getExisting(service, resolvedMinBackoffKey)));
                    break;
                }
                case "LINEAR": {
                    deltaBackoffIntervalInMs = Util.getInt(keyValue.getOrDefault(deltaBackoffIntervalInMsKey, this.getExisting(service, deltaBackoffIntervalInMsKey)));
                    maximumAttempts = Util.getInt(keyValue.getOrDefault(maximumAttemptsKey, this.getExisting(service, maximumAttemptsKey)));
                    resolvedMaxBackoff = Util.getInt(keyValue.get(resolvedMaxBackoffKey));
                    resolvedMinBackoff = Util.getInt(keyValue.get(resolvedMinBackoffKey));
                    break;
                }
                default: {
                    deltaBackoffIntervalInMs = Util.getInt(keyValue.get(deltaBackoffIntervalInMsKey));
                    maximumAttempts = Util.getInt(keyValue.get(maximumAttemptsKey));
                    resolvedMaxBackoff = Util.getInt(keyValue.get(resolvedMaxBackoffKey));
                    resolvedMinBackoff = Util.getInt(keyValue.get(resolvedMinBackoffKey));
                }
            }
            try {
                switch (retryPolicyType) {
                    case "EXPONENTIAL": {
                        if (CloudConfigSettings.isNonZero(resolvedMaxBackoff) && !CloudConfigSettings.isNonZero(resolvedMinBackoff)) {
                            throw new ValidationException(Messages.getString("invalidRetryBackoff"));
                        }
                        if (!CloudConfigSettings.isNonZero(resolvedMaxBackoff) && CloudConfigSettings.isNonZero(resolvedMinBackoff)) {
                            throw new ValidationException(Messages.getString("invalidRetryBackoff"));
                        }
                        if (CloudConfigSettings.isNonZero(resolvedMaxBackoff) && CloudConfigSettings.isNonZero(resolvedMinBackoff) && resolvedMaxBackoff < resolvedMinBackoff) {
                            throw new ValidationException(Messages.getString("invalidRetryBackoff"));
                        }
                    }
                    case "LINEAR": {
                        if (CloudConfigSettings.isNonZero(deltaBackoffIntervalInMs) && !CloudConfigSettings.isNonZero(maximumAttempts)) {
                            throw new ValidationException(Messages.getString("invalidDeltaBackoff"));
                        }
                        if (!CloudConfigSettings.isNonZero(deltaBackoffIntervalInMs) && CloudConfigSettings.isNonZero(maximumAttempts)) {
                            throw new ValidationException(Messages.getString("invalidDeltaBackoff"));
                        }
                        break;
                    }
                    default: {
                        if (Objects.nonNull(deltaBackoffIntervalInMs) || Objects.nonNull(maximumAttempts) || Objects.nonNull(resolvedMaxBackoff) || Objects.nonNull(resolvedMinBackoff)) {
                            throw new ValidationException("deltaBackoffIntervalInMs".concat(",").concat("maximumAttempts").concat(",").concat("resolvedMinBackoff").concat(",").concat("resolvedMaxBackoff").concat(" none of them are required."));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                MessageHandler.getInstance().showError(e.getMessage());
                return false;
            }
        }
        try {
            String serviceName = null;
            if (!StringUtils.isBlank((CharSequence)service)) {
                Map<String, Object> serviceMap = this.cloudConfigMap.get(service);
                String string = serviceName = serviceMap != null ? Util.getString(serviceMap.get("serviceName")) : null;
            }
            if (serviceName == null && !Objects.isNull(keyValue.get(NAME))) {
                serviceName = Util.getString(keyValue.get("serviceName"));
            }
            if (CloudServiceName.PUBSUB.name().equalsIgnoreCase(serviceName)) {
                Duration maxAckExtensionPeriod;
                String alias = StringUtils.isBlank((CharSequence)service) ? Util.getString(keyValue.get(NAME)) : service;
                String minDurationPerAckExtensionPeriodKey = "subscriberSettings/minDurationPerAckExtensionPeriod";
                String maxDurationPerAckExtensionPeriodKey = "subscriberSettings/maxDurationPerAckExtensionPeriod";
                String maxAckExtensionPeriodKey = "subscriberSettings/maxAckExtensionPeriod";
                String minDurationPerAckExtensionPeriodValue = Util.getString(keyValue.getOrDefault(minDurationPerAckExtensionPeriodKey, this.getExisting(alias, minDurationPerAckExtensionPeriodKey)));
                String maxDurationPerAckExtensionPeriodValue = Util.getString(keyValue.getOrDefault(maxDurationPerAckExtensionPeriodKey, this.getExisting(alias, maxDurationPerAckExtensionPeriodKey)));
                String maxAckExtensionPeriodValue = Util.getString(keyValue.getOrDefault(maxAckExtensionPeriodKey, this.getExisting(alias, maxAckExtensionPeriodKey)));
                Duration minDurationPerAckExtensionPeriod = minDurationPerAckExtensionPeriodValue != null ? Util.getDurationProperty(minDurationPerAckExtensionPeriodValue) : null;
                Duration maxDurationPerAckExtensionPeriod = maxDurationPerAckExtensionPeriodValue != null ? Util.getDurationProperty(maxDurationPerAckExtensionPeriodValue) : null;
                Duration duration = maxAckExtensionPeriod = maxAckExtensionPeriodValue != null ? Util.getDurationProperty(maxAckExtensionPeriodValue) : null;
                if (minDurationPerAckExtensionPeriod != null && maxDurationPerAckExtensionPeriod != null && minDurationPerAckExtensionPeriod.getSeconds() > maxDurationPerAckExtensionPeriod.getSeconds()) {
                    throw new ValidationException(Messages.getString("minMaxDurationPerAckExtensionPeriodError1"));
                }
                if (maxAckExtensionPeriod != null && maxDurationPerAckExtensionPeriod != null && maxAckExtensionPeriod.getSeconds() > maxDurationPerAckExtensionPeriod.getSeconds()) {
                    throw new ValidationException(Messages.getString("minMaxDurationPerAckExtensionPeriodError2"));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            MessageHandler.getInstance().showError(e.getMessage());
            return false;
        }
        return true;
    }

    private Object getExisting(String service, String key) {
        if (!this.flatMap.containsKey(service)) {
            return null;
        }
        Object serviceMap = this.flatMap.get(service);
        return serviceMap instanceof Map ? ((Map)serviceMap).get(key) : null;
    }

    private static boolean isNonZero(Integer value) {
        return Objects.nonNull(value) && value > 0;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        if (!this.cloudConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        this.cloudConfigMap.remove(service);
        try {
            this.cloudConfigService.deleteConfigData(service);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

