/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.scheduling.ScheduleTagData;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.service.CronService;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CronSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private final String cronConfigXml = Category.SCHEDULETASK.getFileName();
    private ScheduleTagData cronConfigMap = new ScheduleTagData();
    private final File cronConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.cronConfigXml);
    private final CronService cronService = new CronService(this.cronConfigXmlFile);
    private static final List<String> allowedDsDrivers = Arrays.asList("MySQL5", "Oracle", "MSSQLServer");

    public CronSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        ScheduleTagData map = new ScheduleTagData();
        this.cronConfigMap.forEach(map::put);
        if (CommandName.EXPORT.equals((Object)AbstractCommand.commandName)) {
            map.put("datasource", this.cronService.getDatasource());
        }
        return map;
    }

    @Override
    public void populateMap() {
        ScheduleTagData map = new ScheduleTagData();
        map.putAll(this.cronService.getMap());
        this.cronConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if ("enableScheduleTaskLog".equalsIgnoreCase(name)) {
            return this.cronService.getLogFlag().toString();
        }
        if ("datasource".equalsIgnoreCase(name)) {
            return this.cronService.getDatasource();
        }
        if (StringUtils.isBlank((CharSequence)(service = this.getServiceName(service)))) {
            MessageHandler.getInstance().showError(Messages.getString("GET.blankServiceName", Category.SCHEDULETASK.name()));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        TreeMap v = (TreeMap)this.cronConfigMap.get(service);
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.cronConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.SCHEDULETASK;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if ("enableScheduleTaskLog".equalsIgnoreCase(name)) {
            this.cronService.updateLogging((Boolean)value);
            return true;
        }
        if ("datasource".equalsIgnoreCase(name)) {
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && !this.validateDatasourceName((String)value)) {
                MessageHandler.getInstance().showError(Messages.getString("invalidDsNameProbe"));
                return false;
            }
            this.cronService.updateDatasource((String)value);
            return true;
        }
        if (StringUtils.isBlank((CharSequence)(service = this.getServiceName(service)))) {
            MessageHandler.getInstance().showError(Messages.getString("GET.blankServiceName", Category.SCHEDULETASK.name()));
            return false;
        }
        if (name.equalsIgnoreCase("task")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        ScheduleTagData serviceMap = (ScheduleTagData)this.cronConfigMap.get(service);
        if (serviceMap != null) {
            serviceMap.put(name, this.convertValue(name, value));
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && "eventhandler".equalsIgnoreCase(name) && StringUtils.isNotBlank((CharSequence)((String)value))) {
                serviceMap.put("eventhandlerrp", value);
            }
            if (!serviceMap.validateData()) {
                MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal"));
                throw new CFSetupException(Messages.getString("invalidAttributeVal"));
            }
        } else {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.SCHEDULETASK.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.SCHEDULETASK.name()));
        }
        this.cronConfigMap.put(service, serviceMap);
        this.updateMap();
        return true;
    }

    @Override
    public boolean addService(Object val) {
        String service = (String)((Map)val).get("task");
        ScheduleTagData map = ScheduleTagData.defaultMap();
        map.putAll((Map)val);
        String eventHandler = (String)((Map)val).get("eventhandler");
        if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && StringUtils.isNotBlank((CharSequence)eventHandler)) {
            map.put("eventhandlerrp", eventHandler);
        }
        for (Map.Entry entry : ((Map)val).entrySet()) {
            map.put(entry.getKey(), this.convertValue((String)entry.getKey(), entry.getValue()));
        }
        if (!map.validateData()) {
            MessageHandler.getInstance().showError(Messages.getString("invalidAttributeVal"));
            throw new CFSetupException(Messages.getString("invalidAttributeVal"));
        }
        if (service != null) {
            this.cronConfigMap.remove(service);
        }
        this.cronConfigMap.put(service, map);
        this.updateMap();
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (this.cronConfigMap.get(service = this.getServiceName(service)) == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.SCHEDULETASK.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.SCHEDULETASK.name()));
        }
        this.cronConfigMap.remove(service);
        this.updateMap();
        return true;
    }

    private Object convertValue(String name, Object value) {
        Object val = value;
        if (name.equals(ScheduleTagData.INTERVAL) && !ScheduleTagData.isValidInterval(String.valueOf(value)) && !NumberUtils.isDigits((String)String.valueOf(value)) && !StringUtils.isBlank((CharSequence)String.valueOf(value))) {
            val = Util.getIntervalNumberFromString((String)value);
        }
        return val;
    }

    private void updateMap() {
        ScheduleTagData map = new ScheduleTagData();
        for (Map.Entry obj : this.cronConfigMap.entrySet()) {
            Map val = (Map)obj.getValue();
            String groupName = (String)val.get("group");
            String cronPrefix = val.get("appname") == null ? "" : (String)val.get("appname");
            String mode = (String)val.get("mode");
            Object key = (String)val.get("task");
            if (StringUtils.isBlank((CharSequence)groupName)) {
                groupName = "default";
            }
            if ((StringUtils.isEmpty((CharSequence)mode) || "server".equalsIgnoreCase(mode)) && StringUtils.isBlank((CharSequence)cronPrefix)) {
                cronPrefix = "serverscheduletask";
            }
            key = ((String)key).toUpperCase().startsWith("CFPROBE___") ? "SERVERSCHEDULETASK#$%^DEFAULT#$%^" + ((String)key).toUpperCase() : cronPrefix + "#$%^" + groupName + "#$%^" + (String)key;
            map.put(((String)key).toUpperCase(), val);
        }
        this.cronService.storeModifiedMap(map);
    }

    @Override
    public String showSuffix() {
        return "(s)";
    }

    public Map getInternalMap() {
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.cronConfigMap.forEach((key, value) -> {
            String k = (String)key;
            String task = (String)((Map)value).get("task");
            if (!task.toUpperCase().startsWith("CFPROBE___")) {
                map.put(k.toLowerCase(), value);
            }
        });
        return map;
    }

    @Override
    public void show(String service) {
        if (StringUtils.isBlank((CharSequence)service) || "*".equals(service)) {
            super.show(service);
            Util.showSingleSetting(this.getCategory(), "datasource", this.cronService.getDatasource());
            return;
        }
        String caseInsensitiveService = this.getServiceName(service);
        caseInsensitiveService = caseInsensitiveService != null ? caseInsensitiveService.toLowerCase() : service;
        super.show(caseInsensitiveService);
    }

    private String getServiceName(String service) {
        int counts = StringUtils.countMatches((CharSequence)service, (CharSequence)":");
        if (counts == 0) {
            service = (String)service + ":default:server";
        } else if (counts == 1) {
            service = (String)service + ":server";
        }
        return service;
    }

    private boolean validateDatasourceName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return true;
        }
        DatasourceSettings datasourceSettings = new DatasourceSettings(this.selectedPath);
        return datasourceSettings.getMap().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(name) && allowedDsDrivers.contains((String)((Map)entry.getValue()).get("DRIVER"))).findFirst().isPresent();
    }
}

