/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.tagext.language.RegistryServiceImpl;
import coldfusion.util.IniUtils;
import com.adobe.cfsetup.DatasourceUtil;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.external.RegisterInstanceImpl;
import com.adobe.cfsetup.settings.service.DatasourceService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceSettings.class);
    private Map<String, Map<String, Object>> datasourceConfigMap;
    private final File datasourceConfigXmlFile;
    private DatasourceService datasourceService;
    Map<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public DatasourceSettings(String instancePath) {
        super(instancePath);
        this.datasourceConfigMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.datasourceConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.getCategory().getFileName());
        this.datasourceService = new DatasourceService(this.datasourceConfigXmlFile);
        this.populateMap();
    }

    @Override
    public void populateMap() {
        this.datasourceConfigMap.putAll(new HashMap(this.datasourceService.getMap()));
        this.flatMap = Util.createFlatMap(this.getCategory(), this.datasourceConfigMap);
    }

    @Override
    public boolean validate(Map<String, Object> ketValue, String service) {
        if (DatasourceUtil.DRIVERS.ORACLE.getName().equalsIgnoreCase(String.valueOf(ketValue.get(DatasourceUtil.DRIVER)))) {
            Object SID = ketValue.get("urlmap/SID");
            Object serviceName = ketValue.get("urlmap/serviceName");
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{service}) && this.datasourceConfigMap.containsKey(service)) {
                Map<String, Object> oldMap = this.datasourceConfigMap.get(service);
                if (SID == null) {
                    SID = oldMap.get("urlmap/SID");
                }
                if (serviceName == null) {
                    serviceName = ketValue.get("urlmap/serviceName");
                }
            }
            if (SID == null && serviceName == null || SID != null && serviceName != null) {
                MessageHandler.getInstance().showError(Messages.getString("ORACLE.sidOrServiceNameShouldBePresent", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "urlmap/SID"), ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "urlmap/serviceName")));
                return false;
            }
        }
        if ((DatasourceUtil.DRIVERS.MSACCESS.getName().equalsIgnoreCase(String.valueOf(ketValue.get(DatasourceUtil.DRIVER))) || DatasourceUtil.DRIVERS.ODBCSOCKET.getName().equalsIgnoreCase(String.valueOf(ketValue.get(DatasourceUtil.DRIVER)))) && !System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            MessageHandler.getInstance().showError(Messages.getString("odbcAndMsaccessNotSupported", String.valueOf(ketValue.get(DatasourceUtil.DRIVER))));
            return false;
        }
        if (DatasourceUtil.DRIVERS.MSACCESS.getName().equalsIgnoreCase(String.valueOf(ketValue.get(DatasourceUtil.DRIVER)))) {
            File databaseFile = new File((String)ketValue.get("urlmap/databaseFile"));
            if (!(AbstractCommand.commandName == CommandName.IMPORT || databaseFile.exists() && databaseFile.isFile())) {
                MessageHandler.getInstance().showError(Messages.getString("missingFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "urlmap/databaseFile"), databaseFile.getAbsolutePath()));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addService(Object val) {
        try {
            Map<String, Object> map = (Map<String, Object>)val;
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && map.containsKey("urlmap/port") && this.isTypeCastingRequired((String)map.get("DRIVER"))) {
                map.put("urlmap/port", new Double((String)map.get("urlmap/port")));
            }
            map = Util.expandNestedFields(map);
            String name = (String)map.get("NAME");
            this.datasourceConfigMap.put(name, map);
            if (!CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                DatasourceUtil.appendDefaultSettings(map, RegisterInstanceImpl.getInstance().getCFVersionFromJar(this.selectedPath));
            }
            this.datasourceService.addService(name, map);
            if ("MSAccess".equalsIgnoreCase((String)map.get("DRIVER")) || "ODBCSocket".equalsIgnoreCase((String)map.get("DRIVER"))) {
                this.setupMsaccessAndodbc(map);
            }
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.datasourceConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return false;
        }
        this.datasourceConfigMap.remove(service);
        try {
            this.datasourceService.store(this.datasourceConfigMap);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("NAME")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.datasourceConfigMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
        }
        try {
            Map dsConfig = this.datasourceConfigMap.get(service);
            if ("urlmap/port".equalsIgnoreCase(name) && this.isTypeCastingRequired((String)dsConfig.get("DRIVER"))) {
                value = new Double((String)value);
            }
            String[] order = name.split("/");
            Map settingMap = dsConfig;
            for (int i = 0; i < order.length - 1; ++i) {
                Object settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = (Map)settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put((String)settingKey, (Object)value);
            this.datasourceService.addService(service, dsConfig);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name()));
            return null;
        }
        Object value = Util.getSettingValue(name, service, this.datasourceConfigMap);
        if (Objects.nonNull(value)) {
            return String.valueOf(value);
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.datasourceConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.DATASOURCE;
    }

    @Override
    public Map<String, ?> getMap() {
        return this.flatMap;
    }

    public Map<String, Object> getInternalMap() {
        return Util.getInternalMap(this.flatMap, this.getCategory());
    }

    private boolean isTypeCastingRequired(String driver) {
        return !"Apache Derby Embedded".equalsIgnoreCase(driver);
    }

    private void setupMsaccessAndodbc(Map<String, Object> map) {
        String dsn;
        Map urlMap;
        String driver = (String)map.get("DRIVER");
        if ("MSAccess".equalsIgnoreCase(driver)) {
            this.updateRegistry(map);
        }
        String connectstring = (urlMap = (Map)map.get("urlmap")).containsKey("args") ? (String)urlMap.get("args") : "";
        String timeStampAsString = urlMap.containsKey("TimeStampAsString") ? (String)urlMap.get("TimeStampAsString") : "No";
        String logonMethod = urlMap.containsKey("UseTrustedConnection") && (Boolean)urlMap.get("UseTrustedConnection") == true ? "OSIntegrated" : "DBMSLogon(UID,PWD)";
        String odbcdsn = dsn = (String)map.get(DatasourceUtil.NAME);
        if ("ODBCSocket".equalsIgnoreCase(driver)) {
            odbcdsn = urlMap.containsKey("datasource") ? (String)urlMap.get("datasource") : "";
        }
        this.updateODBCServerDSN(dsn, odbcdsn, connectstring, timeStampAsString, logonMethod);
    }

    private void updateRegistry(Map<String, Object> map) {
        String Branch_ODBCINI = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ODBC\\ODBC.INI";
        String Branch_ODBCDS = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
        String Branch_ODBCINST = "HKEY_LOCAL_MACHINE\\SOFTWARE\\ODBC\\ODBCINST.INI";
        String RegEntry = "Microsoft Access Driver (*.mdb)";
        String EnvName = System.getProperty("os.arch");
        if ("amd64".equalsIgnoreCase(EnvName)) {
            RegEntry = "Microsoft Access Driver (*.mdb, *.accdb)";
        }
        try {
            File rfile = new File(this.selectedPath + File.separator + "registry" + File.separator + "cf.registry");
            File rconffile = new File(this.selectedPath + File.separator + "lib" + File.separator + "neo-registry.xml");
            RegistryServiceImpl rs = new RegistryServiceImpl(rfile, rconffile, this.selectedPath + File.separator + "lib");
            rs.start();
            String dsn = (String)map.get(DatasourceUtil.NAME);
            String description = map.containsKey("description") ? (String)map.get("description") : null;
            Map urlMap = (Map)map.get("urlmap");
            String databaseFile = urlMap.containsKey("databaseFile") ? (String)urlMap.get("databaseFile") : null;
            String systemDatabaseFile = urlMap.containsKey("systemDatabaseFile") ? (String)urlMap.get("systemDatabaseFile") : null;
            String uid = urlMap.containsKey("defaultUserName") ? (String)urlMap.get("defaultUserName") : null;
            String pwd = urlMap.containsKey("defaultPassword") ? (String)urlMap.get("defaultPassword") : null;
            rs.set(Branch_ODBCDS, dsn, RegEntry, "STRING");
            rs.set(Branch_ODBCINI, dsn, null, "KEY");
            String dsnKey = Branch_ODBCINI + "\\" + dsn;
            if (StringUtils.isNotBlank((CharSequence)description)) {
                rs.set(dsnKey, "Description", description, "STRING");
            }
            if (StringUtils.isNotBlank((CharSequence)databaseFile)) {
                rs.set(dsnKey, "DBQ", databaseFile, "STRING");
            }
            if (StringUtils.isNotBlank((CharSequence)systemDatabaseFile)) {
                rs.set(dsnKey, "SystemDB", systemDatabaseFile, "STRING");
            }
            if (StringUtils.isNotBlank((CharSequence)uid)) {
                rs.set(dsnKey, "UID", uid, "STRING");
            }
            if (StringUtils.isNotBlank((CharSequence)pwd)) {
                rs.set(dsnKey, "PWD", pwd, "STRING");
            }
            rs.set(dsnKey, "Engines", null, "KEY");
            String engineKey = dsnKey + "\\Engines";
            rs.set(engineKey, "Jet 2.x", null, "KEY");
            rs.set(engineKey, "Jet", null, "KEY");
            String pgTimeOut = urlMap.containsKey("pageTimeout") ? String.valueOf(Double.valueOf(String.valueOf(urlMap.get("pageTimeout"))).intValue()) : "1";
            String maxBufferSize = map.containsKey("buffer") ? String.valueOf(((Double)map.get("buffer")).intValue()) : "0";
            rs.set(engineKey + "\\Jet 2.x", "PageTimeout", pgTimeOut, "DWORD");
            rs.set(engineKey + "\\Jet", "PageTimeout", pgTimeOut, "DWORD");
            rs.set(engineKey + "\\Jet 2.x", "MaxBufferSize", maxBufferSize, "DWORD");
            rs.set(engineKey + "\\Jet", "MaxBufferSize", maxBufferSize, "DWORD");
            rs.set(dsnKey, "DriverId", "25", "DWORD");
            rs.set(dsnKey, "FIL", "MS Access", "STRING");
            rs.set(dsnKey, "DefaultDir", DatasourceSettings.getDirectoryFromPath(databaseFile), "STRING");
            String driverPath = (String)rs.get(Branch_ODBCINST + "\\" + RegEntry, "Driver", "STRING");
            rs.set(dsnKey, "Driver", driverPath, "STRING");
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(Messages.getString("errorUpdatingRegistry"));
        }
    }

    private void updateODBCServerDSN(String dsn, String odbcdsn, String connString, String timeStampAsString, String logonMethod) {
        timeStampAsString = StringUtils.isNotBlank((CharSequence)timeStampAsString) && "YES".equalsIgnoreCase(timeStampAsString) ? "Yes" : "No";
        String iniPath = this.selectedPath + File.separator + "db" + File.separator + "slserver54" + File.separator + "cfg" + File.separator + "swandm.ini";
        File file = new File(iniPath);
        if (!file.exists()) {
            MessageHandler.getInstance().showError(Messages.getString("errorSettingupDs"));
            return;
        }
        IniUtils ini = new IniUtils(iniPath, "");
        String SLServiceName = ini.getProfileString("Service_1", "ServiceName");
        if (StringUtils.isBlank((CharSequence)SLServiceName)) {
            SLServiceName = "Adobe ColdFusion ODBC Server";
        }
        String prefix = "'" + SLServiceName + "' '" + dsn + "'";
        String inpFileContent = "alc\ndsd " + prefix + "\ndsc " + prefix + "\ndsad " + prefix + " DataSourceSOCODBCConnStr\ndsaa " + prefix + " DataSourceSOCODBCConnStr dsn='" + odbcdsn + (String)(StringUtils.isNotBlank((CharSequence)connString) ? ";" + connString : "") + "'\ndsaa " + prefix + " DataSourceFetchTimeStampAsString " + timeStampAsString + "\ndsar " + prefix + " DataSourceLogonMethod " + logonMethod + "\ndsi " + prefix + "\ncc";
        String inpFilePath = this.selectedPath + File.separator + "db" + File.separator + "slserver54" + File.separator + "admin";
        String swclaPath = this.selectedPath + File.separator + "db" + File.separator + "slserver54" + File.separator + "admin" + File.separator + "swcla.exe";
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(inpFilePath + File.separator + dsn + ".inp");
            fout.write(inpFileContent.getBytes());
            this.execute(swclaPath + " -i " + inpFilePath + File.separator + dsn + ".inp");
        }
        catch (IOException | InterruptedException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorSettingupDs"));
        }
        try {
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(String cmd) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(cmd);
        if (!process.waitFor(60L, TimeUnit.SECONDS)) {
            process.destroy();
        }
    }

    public static String getDirectoryFromPath(String path) {
        int separatorPos = path.lastIndexOf("/");
        int indexOfBackSlash = path.lastIndexOf("\\");
        if (indexOfBackSlash > separatorPos) {
            separatorPos = indexOfBackSlash;
        }
        return separatorPos != -1 ? path.substring(0, separatorPos + 1) : File.separator;
    }
}

