/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.DeleteSupportedSettings;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.DocumentService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DocumentSettings
extends MultiConfigurationBase
implements DeleteSupportedSettings {
    private File documentXmlFile;
    public static final String LOCAL_OPEN_OFFICE = "local";
    public static final String REMOTE_OPEN_OFFICE = "remote";
    private Map<String, Object> documentMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private DocumentService service;
    public static final String DOCUMENT_TYPE = "type";

    public DocumentSettings(String instancePath) {
        super(instancePath);
        this.documentXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.DOCUMENT.getFileName());
        this.service = new DocumentService(this.documentXmlFile, this.documentXmlFile.getParentFile().getParent());
        this.populateMap();
    }

    @Override
    public void populateMap() {
        HashMap<String, String> localOO = new HashMap<String, String>(this.service.getLocalOpenOfficeMap());
        HashMap<String, String> remoteOO = new HashMap<String, String>(this.service.getRemoteOpenOfficeMap());
        localOO.put(DOCUMENT_TYPE, LOCAL_OPEN_OFFICE);
        remoteOO.put(DOCUMENT_TYPE, REMOTE_OPEN_OFFICE);
        this.documentMap.put(LOCAL_OPEN_OFFICE, new HashMap(localOO));
        this.documentMap.put(REMOTE_OPEN_OFFICE, new HashMap(remoteOO));
    }

    @Override
    public String getSetting(String name, String service) {
        if (!this.documentMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("DOCUMENT.invalidOfficeType"));
            return null;
        }
        Map openOfficeMap = (Map)this.documentMap.get(service);
        if (!openOfficeMap.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return openOfficeMap.get(name).toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (!this.documentMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("DOCUMENT.invalidOfficeType"));
            return false;
        }
        if ("path".equalsIgnoreCase(name) && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName) && !this.isValidOpenOffice(String.valueOf(value))) {
            MessageHandler.getInstance().showError(Messages.getString("DOCUMENT.invalidOpenOffice", String.valueOf(value)));
            return false;
        }
        Map openOfficeMap = (Map)this.documentMap.get(service);
        openOfficeMap.put(name, value);
        return this.saveModifiedMap();
    }

    private boolean saveModifiedMap() {
        return this.service.saveOpenOfficeMap(this.documentMap);
    }

    public Map<String, Object> getMap() {
        return this.documentMap;
    }

    @Override
    public File getXMLFileObject() {
        return this.documentXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.DOCUMENT;
    }

    private boolean isValidOpenOffice(String path) {
        return new File(path + File.separator + "program" + File.separator + "soffice.bin").exists();
    }

    @Override
    public boolean deleteService(String service) {
        if (!this.documentMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("DOCUMENT.invalidOfficeType"));
            return false;
        }
        Map openOfficeMap = (Map)this.documentMap.get(service);
        openOfficeMap.clear();
        return this.saveModifiedMap();
    }
}

