/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.service.EventService;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EventGatewayInstanceSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Map<String, Object>> eventgatewayInstances = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
    private final File eventConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.EVENTGATEWAYINSTANCE.getFileName());
    private final EventService eventService;

    public EventGatewayInstanceSettings(String instancePath) {
        super(instancePath);
        this.eventService = new EventService(this.eventConfigXmlFile, instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.eventgatewayInstances.forEach(map::put);
        return map;
    }

    @Override
    public File getXMLFileObject() {
        return this.eventConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.EVENTGATEWAYINSTANCE;
    }

    @Override
    public void populateMap() {
        this.eventgatewayInstances = this.getEventGatewayInstances(this.eventService.getEventGatewayInstances());
    }

    private Map<String, Map<String, Object>> getEventGatewayInstances(Map<String, Map<String, Object>> gatewayTypes) {
        TreeMap<String, Map<String, Object>> gatewayTypesMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        gatewayTypes.forEach((key, value) -> {
            HashMap inputMap = new HashMap(value);
            HashMap map = new HashMap(value);
            map.putAll(inputMap);
            if (CollectionUtils.isNotEmpty((Collection)((Vector)inputMap.get("CFCPATHS")))) {
                map.put("CFCPATHS", ((Vector)inputMap.get("CFCPATHS")).get(0));
            }
            gatewayTypesMap.put((String)key, map);
        });
        return gatewayTypesMap;
    }

    @Override
    public String getSetting(String name, String service) {
        name = name.toUpperCase();
        if (!this.eventgatewayInstances.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid eventgatewayInstances");
            return null;
        }
        Map<String, Object> gatewayType = this.eventgatewayInstances.get(service);
        if (!gatewayType.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return gatewayType.get(name).toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (name.equalsIgnoreCase("GATEWAYID")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.eventgatewayInstances.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.EVENTGATEWAYINSTANCE.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.EVENTGATEWAYINSTANCE.name()));
        }
        Map<String, Object> gatewayInstance = this.eventgatewayInstances.get(service);
        gatewayInstance.put(name, newValue);
        return this.addService(gatewayInstance);
    }

    private boolean saveModifiedMap() {
        ConfigMap configMap = new ConfigMap();
        this.eventgatewayInstances.forEach((key, value) -> {
            ConfigMap gateway = new ConfigMap();
            gateway.putAll((Map)value);
            Vector cfcPaths = new Vector();
            cfcPaths.add(value.get("CFCPATHS"));
            gateway.put("CFCPATHS", cfcPaths);
            configMap.put(key, gateway);
        });
        return this.eventService.saveGatewayInstanceMap(configMap);
    }

    @Override
    public boolean addService(Object val) {
        Map map = (Map)val;
        String[] cfcPath = new String[]{Cast._String(map.get("CFCPATHS"))};
        String gatewayId = StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("GATEWAYID"))) ? Cast._String(map.get("GATEWAYID")) : null;
        String type = StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("TYPE"))) ? Cast._String(map.get("TYPE")) : null;
        String configPath = StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("CONFIGURATIONPATH"))) ? Cast._String(map.get("CONFIGURATIONPATH")) : null;
        String mode = StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("MODE"))) ? Cast._String(map.get("MODE")) : null;
        this.eventService.registerGateway(gatewayId, type, configPath, cfcPath, mode);
        this.populateMap();
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError("Invalid eventgatewayInstance");
            return false;
        }
        if (!this.eventgatewayInstances.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid eventgatewayInstance");
            return false;
        }
        this.eventgatewayInstances.remove(service);
        return this.saveModifiedMap();
    }
}

