/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.runtime.Cast;
import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.EventService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;

public class EventGatewayTypeSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private final String eventConfigXml = Category.EVENTGATEWAYTYPE.getFileName();
    private Map<String, Map<String, Object>> eventGatewayTypes = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
    private final File eventConfigXmlFile = this.selectedPath.contains(".xml") ? new File(this.selectedPath) : new File(this.selectedPath + File.separator + "lib" + File.separator + this.eventConfigXml);
    private final EventService eventService;

    public EventGatewayTypeSettings(String instancePath) {
        super(instancePath);
        this.eventService = new EventService(this.eventConfigXmlFile, instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.eventGatewayTypes.forEach(map::put);
        return map;
    }

    @Override
    public XMLConfiguration getCfg() {
        return null;
    }

    @Override
    public File getXMLFileObject() {
        return this.eventConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.EVENTGATEWAYTYPE;
    }

    @Override
    public void populateMap() {
        this.eventGatewayTypes = this.getEventGatewayTypes(this.eventService.getGatewayTypeMap());
    }

    private Map<String, Map<String, Object>> getEventGatewayTypes(Map<String, Map<String, Object>> gatewayTypes) {
        TreeMap<String, Map<String, Object>> gatewayTypesMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        gatewayTypes.forEach((key, value) -> gatewayTypesMap.put((String)key, new HashMap(value)));
        return gatewayTypesMap;
    }

    private boolean isValidTypeandClass(String type, String classname) {
        return !(type.equalsIgnoreCase("FMS") && classname.equalsIgnoreCase("coldfusion.eventgateway.fms.FMSGateway") || type.equalsIgnoreCase("DataServicesMessaging") && classname.equalsIgnoreCase("coldfusion.eventgateway.flex.FlexMessagingGateway")) && (!type.equalsIgnoreCase("DataManagement") || !classname.equalsIgnoreCase("coldfusion.eventgateway.flex.FlexDataManagementGateway"));
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError("Please Provide eventGatewayType");
        }
        if (!this.eventGatewayTypes.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid eventGatewayType");
            return null;
        }
        Map<String, Object> gatewayType = this.eventGatewayTypes.get(service);
        if (!gatewayType.containsKey(name = name.toUpperCase())) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return gatewayType.get(name).toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (name.equalsIgnoreCase("TYPE")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.eventGatewayTypes.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid eventGatewayType");
            return false;
        }
        Map<String, Object> gatewayType = this.eventGatewayTypes.get(service);
        if (name.equalsIgnoreCase("CLASS") && !this.isValidTypeandClass(gatewayType.get("TYPE").toString(), newValue.toString())) {
            MessageHandler.getInstance().showError("The provided event gateway type and class combination is not supported");
            return false;
        }
        gatewayType.put(name, newValue);
        return this.saveModifiedMap();
    }

    private boolean saveModifiedMap() {
        ConfigMap configMap = new ConfigMap();
        this.eventGatewayTypes.forEach((key, value) -> {
            ConfigMap gateway = new ConfigMap();
            gateway.putAll((Map)value);
            configMap.put(key, gateway);
        });
        return this.eventService.saveGatewayTypeMap(configMap);
    }

    @Override
    public synchronized boolean addService(Object val) {
        boolean killOnTimeout;
        Map map = (Map)val;
        String type = StringUtils.isNotBlank((CharSequence)String.valueOf(map.get("TYPE"))) ? Cast._String(map.get("TYPE")) : null;
        String description = StringUtils.isNotBlank((CharSequence)String.valueOf(map.get("DESCRIPTION"))) ? Cast._String(map.get("DESCRIPTION")) : null;
        String cls = StringUtils.isNotBlank((CharSequence)String.valueOf(map.get("CLASS"))) ? Cast._String(map.get("CLASS")) : null;
        double startTimeOut = (Double)map.get("STARTTIMEOUT");
        boolean bl = killOnTimeout = !Objects.nonNull(map.get("KILLONTIMEOUT")) || (Boolean)map.get("KILLONTIMEOUT") != false;
        if (!this.isValidTypeandClass(type, cls)) {
            MessageHandler.getInstance().showError("The provided event gateway type and class combination is not supported");
            return false;
        }
        this.eventService.registerGatewayType(type, description, cls, Double.valueOf(startTimeOut).intValue(), killOnTimeout);
        this.populateMap();
        return true;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError("Invalid eventGatewayType");
        }
        if (!this.eventGatewayTypes.containsKey(service)) {
            MessageHandler.getInstance().showError("Invalid eventGatewayType");
            return false;
        }
        this.eventGatewayTypes.remove(service);
        return this.saveModifiedMap();
    }
}

