/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.JvmService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class JvmSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private Map<String, Object> jvmSettings;
    private final File jvmConfigFile;
    private final JvmService jvmService;

    public JvmSettings(String instancePath) {
        super(instancePath);
        String jvmConfigPath = Category.JVM.getFileName();
        this.jvmSettings = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.jvmConfigFile = new File(this.selectedPath + File.separator + "bin" + File.separator + jvmConfigPath);
        this.jvmService = new JvmService(this.jvmConfigFile);
        this.populateMap();
    }

    @Override
    public boolean addService(Object val) {
        String jvmArgs = String.valueOf(this.jvmSettings.get("jvmArgs"));
        Map map = (Map)val;
        if (map.size() > 1) {
            Set keySet = map.keySet();
            keySet.remove("jvmArgs");
            MessageHandler.getInstance().showError(Messages.getString("JVM.JvmAddNotSupportedFor", StringUtils.join(keySet, (String)", ")));
        }
        String newArg = String.valueOf(map.get("jvmArgs"));
        jvmArgs = Objects.isNull(jvmArgs) ? newArg : jvmArgs.concat(" " + newArg);
        return this.setSetting("jvmArgs", jvmArgs, null);
    }

    @Override
    public Map<String, Object> getMap() {
        return this.jvmSettings;
    }

    @Override
    public void populateMap() {
        this.jvmSettings = new HashMap<String, Object>();
        try {
            this.jvmSettings.putAll(this.jvmService.getJvmConfigMap());
        }
        catch (IOException e) {
            MessageHandler.getInstance().showError(e.getMessage());
        }
    }

    @Override
    public String getSetting(String name, String service) {
        return this.jvmSettings.containsKey(name) ? String.valueOf(this.jvmSettings.get(name)) : null;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        this.jvmSettings.put(name, value);
        switch (name) {
            case "jdkPath": {
                File javaExec = this.isWindows() ? new File(String.valueOf(value) + File.separator + "bin/java.exe") : new File(String.valueOf(value) + File.separator + "bin/java");
                if (javaExec.exists()) break;
                MessageHandler.getInstance().showInfo(Messages.getString("invalidJvmPath"));
                return false;
            }
        }
        this.jvmSettings.put(name, value);
        this.jvmService.saveModifiedMap(this.jvmSettings);
        return true;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    @Override
    public File getXMLFileObject() {
        return this.jvmConfigFile;
    }

    @Override
    public Category getCategory() {
        return Category.JVM;
    }

    @Override
    public boolean deleteService(String service) {
        String replacementString;
        String jvmArgs = String.valueOf(this.jvmSettings.get("jvmArgs")).trim();
        boolean deleted = false;
        if (jvmArgs.startsWith(service + " ")) {
            jvmArgs = jvmArgs.substring(service.length());
            deleted = true;
        }
        if (jvmArgs.endsWith(" " + service)) {
            jvmArgs = jvmArgs.substring(0, jvmArgs.length() - service.length());
            deleted = true;
        }
        if (!deleted & !jvmArgs.contains(replacementString = " " + service + " ")) {
            MessageHandler.getInstance().showError(Messages.getString("JVM.notPresentInJvmArgs", service));
            return false;
        }
        return this.setSetting("jvmArgs", jvmArgs.replace(" " + service + " ", " "), null);
    }

    public boolean deleteSandboxArgs() {
        String jvmArgs = String.valueOf(this.jvmSettings.get("jvmArgs")).trim();
        jvmArgs = this.deleteFromJvmArgs(jvmArgs, "-Djava.security.manager");
        jvmArgs = this.deleteFromJvmArgs(jvmArgs, "-Djava.security.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "coldfusion.policy");
        jvmArgs = this.deleteFromJvmArgs(jvmArgs, "-Djava.security.auth.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "neo_jaas.policy");
        return this.setSetting("jvmArgs", jvmArgs, null);
    }

    private String deleteFromJvmArgs(String jvmArgs, String removablePart) {
        if (jvmArgs.startsWith(removablePart + " ")) {
            jvmArgs = jvmArgs.substring(removablePart.length());
        }
        if (jvmArgs.endsWith(" " + removablePart)) {
            jvmArgs = jvmArgs.substring(0, jvmArgs.length() - removablePart.length());
        }
        jvmArgs.replace(" " + removablePart + " ", " ");
        return jvmArgs;
    }
}

