/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.ProbeService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class ProbeConfigSettings
extends MultiConfigurationBase {
    private Map<String, Object> probeConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File probeConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.PROBECONFIG.getFileName());
    private final ProbeService probeService = new ProbeService(this.probeConfigXmlFile);

    public ProbeConfigSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    public Map<String, Object> getMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.probeConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public void populateMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.probeService.getConfigMap());
        this.probeConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        Object object = this.probeConfigMap.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.probeConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.PROBECONFIG;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        this.probeConfigMap.put(name, value);
        this.probeService.storeModifiedProbeConfig(this.probeConfigMap);
        return true;
    }
}

