/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.bean.Jaxrs;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.json.JsonUtil;
import com.adobe.cfsetup.settings.service.RestService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class RestSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private final String jaxrsConfigXml = Category.REST.getFileName();
    private Map<String, Object> jaxrsConfigMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File jaxrsConfigXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.jaxrsConfigXml);
    private final RestService restService = new RestService(this.jaxrsConfigXmlFile);

    public RestSettings(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.jaxrsConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        Map serviceMap = this.restService.getMap();
        serviceMap.forEach((key, value) -> {
            HashMap<String, Object> restMap = new HashMap<String, Object>();
            restMap.put("mapping", value.get(0));
            restMap.put("host", value.get(1));
            restMap.put("isDefault", value.get(2));
            restMap.put("rootPath", key);
            map.put((String)key, restMap);
        });
        this.jaxrsConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)name)) {
            MessageHandler.getInstance().showError(Messages.getString("invalidSettingCategory"));
            return null;
        }
        HashMap v = (HashMap)this.jaxrsConfigMap.get(service);
        Object object = v.get(name);
        if (Objects.isNull(object)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (name.equalsIgnoreCase("rootPath")) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        Map map = (Map)this.jaxrsConfigMap.get(service);
        if (map != null) {
            map.put(name, value);
            return this.updateMap(service, true);
        }
        MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.REST.name().toLowerCase()));
        throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.REST.name().toLowerCase()));
    }

    @Override
    public boolean addService(Object obj) {
        HashMap<String, 1> map = new HashMap<String, 1>();
        final Jaxrs jaxrs = (Jaxrs)JsonUtil.getObjectFromMap((Map)obj, Jaxrs.class);
        map.put(jaxrs.getRootpath(), new HashMap<String, Object>(){
            {
                this.put("mapping", jaxrs.getMapping());
                this.put("host", jaxrs.getHost());
                this.put("isDefault", jaxrs.isDefault());
            }
        });
        this.jaxrsConfigMap.putAll(map);
        return this.updateMap(jaxrs.getRootpath(), true);
    }

    @Override
    public boolean deleteService(String service) {
        if (this.jaxrsConfigMap.get(service) == null) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.REST.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.REST.name()));
        }
        this.jaxrsConfigMap.remove(service);
        return this.updateMap(service, false);
    }

    @Override
    public File getXMLFileObject() {
        return this.jaxrsConfigXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.REST;
    }

    private boolean updateMap(String appPath, boolean checkValid) {
        if (checkValid) {
            this.restService.checkValidity(appPath, this.jaxrsConfigMap);
        }
        HashMap persistableMap = new HashMap();
        for (Map.Entry<String, Object> entry : this.jaxrsConfigMap.entrySet()) {
            Vector vec = new Vector();
            Map val = (Map)entry.getValue();
            vec.add(val.get("mapping"));
            vec.add(val.get("host"));
            vec.add(val.get("isDefault"));
            persistableMap.put(entry.getKey(), vec);
        }
        this.restService.storeModifiedMap(persistableMap);
        return true;
    }
}

