/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings;

import coldfusion.server.SslCertificateManager;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSetting
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(ServerSetting.class);
    private static final String MULTICAST_SERVICE_PORT = "multicastServicePort";
    private static final String MAX_THREADS = "maxThreads";
    private static final String RECEIVER_PORT = "receiverPort";
    private static final String SHUTDOWN_PORT = "shutdownPort";
    private static final String HTTP_CONNECTOR_PORT = "httpConnectorPort";
    private static final String AJP_CONNECTOR_PORT = "ajpConnectorPort";
    private static final String REDIRECT_PORT = "redirectPort";
    private static final String JVM_ROUTE = "jvmRoute";
    private static final String EXECUTOR = "executor";
    private static final String SSL = "ssl";
    private static final String DISTINGUISHED_NAME = "distinguishedName";
    private static final String CERTIFICATE_NAME = "certificateName";
    private static final String CERTIFICATE_LOCATION = "certificateKeystoreFile";
    private static final String CERTIFICATE_PASSWORD = "certificateKeystorePassword";
    private static final String ENABLED_HTTPS = "httpsEnabled";
    private static final String ENABLED_HTTP = "httpEnabled";
    private static final String ALGORITHM = "type";
    private static final String SSL_ENABLED = "sslEnabled";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String AJP = "ajp";
    public static final String OTHER = "other";
    private static final String RSA = "RSA";
    private Map<String, Object> serverSettingMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private final File serverXmlFile = new File(this.selectedPath + File.separator + "runtime" + File.separator + "conf" + File.separator + Category.SERVER.getFileName());
    private ServerConfigParser serverConfigParser = new ServerConfigParser(this.serverXmlFile.getAbsolutePath());
    private SslCertificateManager sslCertificateManager = new SslCertificateManager(this.serverXmlFile.getAbsolutePath());

    public ServerSetting(String instancePath) {
        super(instancePath);
        this.populateMap();
    }

    @Override
    public void populateMap() {
        Map<String, Object> httpMap = this.serverConfigParser.getProtocolConnector("HTTP/1.1");
        Map<String, Object> ajpMap = this.serverConfigParser.getProtocolConnector("AJP/1.3");
        Map<String, Object> httpsMap = this.serverConfigParser.getHttps();
        Map<String, Object> sslConfigMap = this.serverConfigParser.getSSlConfig();
        if (MapUtils.isNotEmpty(httpMap)) {
            this.serverSettingMap.put(HTTP, httpMap);
            sslConfigMap.put(ENABLED_HTTP, true);
        }
        if (MapUtils.isNotEmpty(ajpMap)) {
            this.serverSettingMap.put(AJP, ajpMap);
        }
        if (MapUtils.isNotEmpty(httpsMap)) {
            this.serverSettingMap.put(HTTPS, httpsMap);
            sslConfigMap.put(ENABLED_HTTPS, true);
        }
        if (MapUtils.isNotEmpty(sslConfigMap)) {
            this.serverSettingMap.put(SSL, sslConfigMap);
        }
        TreeMap<String, String> otherMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        otherMap.put(SHUTDOWN_PORT, this.serverConfigParser.getShutDownPort());
        otherMap.put(JVM_ROUTE, this.serverConfigParser.getJvmRoute());
        this.serverSettingMap.put(OTHER, otherMap);
    }

    @Override
    public String getSetting(String name, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name()));
            return null;
        }
        Map connectorMap = (Map)this.serverSettingMap.get(service);
        if (service.equalsIgnoreCase(SSL) && name.equalsIgnoreCase(CERTIFICATE_NAME)) {
            return Paths.get(connectorMap.get(CERTIFICATE_LOCATION).toString(), new String[0]).getFileName().toString();
        }
        if (!this.serverSettingMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return null;
        }
        if (service.equalsIgnoreCase(SSL) && name.equalsIgnoreCase(DISTINGUISHED_NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("keyDisabled", name, AbstractCommand.commandName.toString(), service.toUpperCase()));
            return null;
        }
        if (!connectorMap.containsKey(name)) {
            MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInService", name, service.toUpperCase()));
            return null;
        }
        return connectorMap.get(name).toString();
    }

    @Override
    public File getXMLFileObject() {
        return this.serverXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.SERVER;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean setSetting(String name, Object value, String service) {
        if (!StringUtils.isNotBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", Category.SERVER.name()));
            return false;
        }
        if (!this.serverSettingMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, Category.SERVER.name()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, Category.SERVER.name()));
        }
        Map map = this.serverSettingMap.getOrDefault(service, new HashMap());
        if (map == null) return this.serverConfigParser.saveXml();
        HashMap<String, Object> clonedMap = new HashMap<String, Object>(map);
        if (HTTPS.equalsIgnoreCase(service)) {
            clonedMap.put(name, value);
            this.serverConfigParser.setHttps(clonedMap);
        } else if (HTTP.equalsIgnoreCase(service)) {
            clonedMap.put(name, value);
            this.serverConfigParser.setProtocolConnector("HTTP/1.1", clonedMap);
        } else if (AJP.equalsIgnoreCase(service)) {
            clonedMap.put(name, value);
            this.serverConfigParser.setProtocolConnector("AJP/1.3", clonedMap);
        } else if (OTHER.equalsIgnoreCase(service)) {
            if (SHUTDOWN_PORT.equalsIgnoreCase(name)) {
                this.serverConfigParser.setShutdownPort(String.valueOf(value));
            }
            if (JVM_ROUTE.equalsIgnoreCase(name)) {
                this.serverConfigParser.addJvmRoute(String.valueOf(value));
            }
        } else if (SSL.equalsIgnoreCase(service)) {
            String stringValue = value.toString();
            String certificatePath = (String)map.get(CERTIFICATE_LOCATION);
            String certificatePassword = (String)map.get(CERTIFICATE_PASSWORD);
            String algorithm = (String)map.get(ALGORITHM);
            boolean enableHttps = Boolean.parseBoolean(String.valueOf(map.get(ENABLED_HTTPS)));
            boolean enableHttp = Boolean.parseBoolean(String.valueOf(map.get(ENABLED_HTTP)));
            if (name.equalsIgnoreCase(CERTIFICATE_NAME) || name.equalsIgnoreCase(DISTINGUISHED_NAME)) {
                MessageHandler.getInstance().showError(Messages.getString("keyDisabled", name, AbstractCommand.commandName.toString(), service.toUpperCase()));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)stringValue)) {
                String fields = StringUtils.join(Arrays.asList(CERTIFICATE_LOCATION, CERTIFICATE_PASSWORD, ALGORITHM), (String)", ");
                MessageHandler.getInstance().showError(Messages.getString("provideVal", fields));
                return false;
            }
            if (name.equalsIgnoreCase(CERTIFICATE_LOCATION)) {
                if (!stringValue.endsWith(".jks")) {
                    MessageHandler.getInstance().showError(Messages.getString("ssl.invalidFileType"));
                    return false;
                }
                certificatePath = stringValue;
            } else if (name.equalsIgnoreCase(CERTIFICATE_PASSWORD)) {
                if (stringValue.length() < 6) {
                    MessageHandler.getInstance().showError(Messages.getString("ssl.password"));
                    return false;
                }
                certificatePassword = stringValue;
            } else if (name.equalsIgnoreCase(ALGORITHM)) {
                algorithm = stringValue;
            } else if (name.equalsIgnoreCase(ENABLED_HTTPS)) {
                enableHttps = Boolean.parseBoolean(stringValue);
            } else if (name.equalsIgnoreCase(ENABLED_HTTP)) {
                enableHttp = Boolean.parseBoolean(stringValue);
            }
            this.sslCertificateManager.updateSslConfig(certificatePath, certificatePassword, algorithm, enableHttps, enableHttp);
            map.put(name, value);
            return true;
        }
        map.put(name, value);
        return this.serverConfigParser.saveXml();
    }

    @Override
    public Map<String, Object> getMap() {
        return this.serverSettingMap;
    }

    @Override
    public boolean addService(Object val) {
        return this.addService((Map)val, null);
    }

    @Override
    public boolean addService(Map keyValueMap, String service) {
        TreeMap<String, Object> sslMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (!StringUtils.isBlank((CharSequence)service) && service.equalsIgnoreCase(SSL)) {
            String name = (String)keyValueMap.get(DISTINGUISHED_NAME);
            String certificateName = (String)keyValueMap.get(CERTIFICATE_NAME);
            String password = (String)keyValueMap.get(CERTIFICATE_PASSWORD);
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)certificateName) || StringUtils.isBlank((CharSequence)password)) {
                String fields = StringUtils.join(Arrays.asList(DISTINGUISHED_NAME, CERTIFICATE_NAME, CERTIFICATE_PASSWORD), (String)", ");
                MessageHandler.getInstance().showError(Messages.getString("provideVal", fields));
                return false;
            }
            if (!certificateName.endsWith(".jks") || certificateName.contains(File.separator)) {
                MessageHandler.getInstance().showError(Messages.getString("ssl.invalidFile"));
                return false;
            }
            if (password.length() < 6) {
                MessageHandler.getInstance().showError(Messages.getString("ssl.password"));
                return false;
            }
            if (this.sslCertificateManager.generateKeyAndCertificate(name, certificateName, password, true)) {
                String parentDir = this.serverXmlFile.getParent();
                String selfSignedCertPath = parentDir + File.separator + certificateName;
                sslMap.put(CERTIFICATE_LOCATION, selfSignedCertPath);
                sslMap.put(CERTIFICATE_PASSWORD, password);
                sslMap.put(ALGORITHM, RSA);
                this.serverSettingMap.put(SSL, sslMap);
                return true;
            }
            MessageHandler.getInstance().showError(Messages.getString("addFail", service.toLowerCase()));
            return false;
        }
        MessageHandler.getInstance().showError(Messages.getString("operationNotSupported2", service.toUpperCase()));
        return false;
    }

    @Override
    public boolean deleteService(String service) {
        return this.deleteService(null, service);
    }

    @Override
    public boolean deleteService(Map<String, List> keyValueMap, String service) {
        MessageHandler.getInstance().showError(Messages.getString("deleteNotSupported", Category.SERVER.name()));
        return false;
    }
}

