/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.nested;

import coldfusion.cloud.VendorCredentialService;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudVendorCredentialSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(CloudVendorCredentialSettings.class);
    private Map<String, Map<String, Object>> vendorCredMap;
    private final File vendorCredXmlFile;
    private VendorCredentialService credentialService;
    private static final String NAME = "alias";

    public CloudVendorCredentialSettings(String instancePath) {
        super(instancePath);
        this.vendorCredXmlFile = new File(this.selectedPath + File.separator + "lib" + File.separator + this.getCategory().getFileName());
        this.credentialService = new VendorCredentialService(this.vendorCredXmlFile);
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.vendorCredMap.forEach((s, stringStringMap) -> map.put((String)s, stringStringMap));
        return map;
    }

    @Override
    public File getXMLFileObject() {
        return this.vendorCredXmlFile;
    }

    @Override
    public Category getCategory() {
        return Category.CLOUDCREDENTIAL;
    }

    @Override
    public void populateMap() {
        this.vendorCredMap = new TreeMap<String, Map<String, Object>>(String.CASE_INSENSITIVE_ORDER);
        this.credentialService.getAllCredentialsData().forEach((key, value) -> this.vendorCredMap.put(String.valueOf(key), (Map)value));
    }

    @Override
    public String getSetting(String name, String service) {
        Map cloudConfig;
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name()));
            return null;
        }
        if (!this.vendorCredMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name()));
            return null;
        }
        String[] order = name.split("/");
        Map settingMap = cloudConfig = this.vendorCredMap.get(service);
        for (String settingName : order) {
            Object settingValue = settingMap.get(settingName);
            if (!(settingValue instanceof Map)) {
                return String.valueOf(settingValue);
            }
            settingMap = (Map)settingValue;
        }
        MessageHandler.getInstance().showError(Messages.getString("SettingKeyNotPresentInTargetFile", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name)));
        return null;
    }

    @Override
    public boolean setSetting(String name, Object value, String service) {
        return this.updateMap(name, value, service);
    }

    public boolean updateMap(String name, Object newValue, String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.vendorCredMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name().toLowerCase()));
            throw new CFSetupException(Messages.getString("serviceDoesNotExist", service, this.getCategory().name().toLowerCase()));
        }
        if (name.equalsIgnoreCase("vendorName") || name.equalsIgnoreCase(NAME)) {
            MessageHandler.getInstance().showError(Messages.getString("cantChangeThisSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), name), this.getCategory().name().toLowerCase()));
            return false;
        }
        try {
            Map cloudConfig = this.vendorCredMap.get(service);
            if (NAME.equalsIgnoreCase(name)) {
                this.vendorCredMap.remove(service);
                this.vendorCredMap.put(String.valueOf(newValue), cloudConfig);
            }
            String[] order = name.split("/");
            Map settingMap = cloudConfig;
            for (int i = 0; i < order.length - 1; ++i) {
                Object settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = (Map)settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put((String)settingKey, (Object)newValue);
            this.credentialService.modifyCredentialsData(service, cloudConfig);
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean addService(Object val) {
        try {
            Map<String, Object> map = (Map<String, Object>)val;
            map = this.expandNestedFields(map);
            String alias = (String)map.get(NAME);
            if (this.vendorCredMap.containsKey(alias)) {
                this.credentialService.modifyCredentialsData(alias, map);
            } else {
                this.credentialService.addCredentialsData(map);
            }
            this.populateMap();
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e);
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private Map<String, Object> expandNestedFields(Map<String, Object> map) {
        HashMap<String, Object> expandedMap = new HashMap<String, Object>();
        map.forEach((name, value) -> {
            String[] order = name.split("/");
            Map settingMap = expandedMap;
            for (int i = 0; i < order.length - 1; ++i) {
                HashMap settingValue;
                if (settingMap.containsKey(order[i])) {
                    settingValue = settingMap.get(order[i]);
                } else {
                    settingValue = new HashMap();
                    settingMap.put(order[i], settingValue);
                }
                settingMap = settingValue;
            }
            String settingKey = order[order.length - 1];
            settingMap.put(settingKey, value);
        });
        return expandedMap;
    }

    @Override
    public boolean deleteService(String service) {
        if (StringUtils.isBlank((CharSequence)service)) {
            MessageHandler.getInstance().showError(Messages.getString("blankServiceName", this.getCategory().name().toLowerCase()));
            return false;
        }
        if (!this.vendorCredMap.containsKey(service)) {
            MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, this.getCategory().name().toLowerCase()));
            return false;
        }
        this.vendorCredMap.remove(service);
        try {
            this.credentialService.deleteCredentialsData(service);
        }
        catch (Exception e) {
            MessageHandler.getInstance().showError(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }
}

