/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.Struct;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class DatasourceService
extends ServiceBase {
    private File datasourceConfigFile;
    private ConfigMap settings;
    private double maxcachecount;
    private ConfigMap commonSettings;

    public DatasourceService(File datasourceConfigFile) {
        this.datasourceConfigFile = datasourceConfigFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading datasourceService, ", e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.datasourceConfigFile);
            this.settings = (ConfigMap)v.get(0);
            this.commonSettings = (ConfigMap)v.get(1);
            this.maxcachecount = (Double)this.commonSettings.get("maxcachecount");
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    public void store(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.settings);
        v.add(this.commonSettings);
        this.serialize(v, this.datasourceConfigFile);
    }

    public void addService(String name, Map map) {
        Map m = this.formDatasourceSetting(map, false);
        this.settings.put(name, m);
        this.updateSetting();
    }

    private void updateSetting() {
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        v.add(this.settings);
        v.add(this.commonSettings);
        this.serialize(v, this.datasourceConfigFile);
    }

    private Map formDatasourceSetting(Map map, boolean isStruct) {
        TreeMap m = isStruct ? new Struct() : new ConfigMap();
        map.forEach((key, val) -> {
            if (val instanceof Map) {
                m.put(key, this.formDatasourceSetting((Map)val, "CONNECTIONPROPS".equalsIgnoreCase((String)key)));
            } else {
                m.put(key, val);
            }
        });
        return m;
    }
}

