/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentService
extends ServiceBase {
    private static final String JETTY_READ_ERROR = "JETTY_READ_ERROR";
    private static final String JETYXML_PATHPART = File.separator + "jetty" + File.separator + "etc" + File.separator + "jetty.xml";
    private File config_file = null;
    private ConfigMap fontConfigMap = null;
    private ConfigMap userFontConfigMap = null;
    private ConfigMap localOpenOfficeConfig = null;
    private ConfigMap remoteOpenOfficeConfig = null;
    private ConfigMap pdfgServiceManagersConfig = null;
    private static Properties awtfontmapper = new Properties();
    private static Properties awtfontmapperbak = new Properties();
    private static Properties jpedalProperties = new Properties();
    private static Set systemFontDirs = new HashSet();
    private static Set<String> userFontDirs = new HashSet<String>();
    private boolean initialized = false;
    protected static String oldSeed = "4259E88029503E9F";
    private String serverId;
    private String officeLocation = "";
    private String hostname = "";
    private String port = "";
    private int expiryTime = 300;
    private String seed;
    private static final Logger logger = LoggerFactory.getLogger(DocumentService.class);

    public DocumentService(File config_file, String _rootdir) {
        this.config_file = config_file;
        this.setEnableWatch(true);
        this.setWatchFile(config_file);
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error("Error initializing Document Service", (Throwable)e);
        }
    }

    @Override
    public Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("neo_font.keys", "");
            this.rb.put("neo_font.types", "");
            this.rb.put("neo_font.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
            this.rb.put("neo_user_font.keys", "");
            this.rb.put("neo_user_font.types", "");
            this.rb.put("neo_user_font.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.NumberFormatter,coldfusion.server.BooleanFormatter,coldfusion.server.BooleanFormatter");
        }
        return this.rb;
    }

    @Override
    public void load() throws ServiceException {
        this.fontConfigMap = new ConfigMap();
        this.fontConfigMap.init(this, "neo_font");
        try {
            try {
                Object configObject = this.deserialize(this.config_file);
                if (configObject instanceof Vector) {
                    Vector configObject2 = (Vector)configObject;
                    this.userFontConfigMap = (ConfigMap)configObject2.get(0);
                    this.localOpenOfficeConfig = (ConfigMap)configObject2.get(1);
                    this.remoteOpenOfficeConfig = (ConfigMap)configObject2.get(2);
                    if (configObject2.size() > 3) {
                        this.pdfgServiceManagersConfig = (ConfigMap)configObject2.get(3);
                    }
                } else {
                    this.userFontConfigMap = (ConfigMap)configObject;
                }
                if (this.localOpenOfficeConfig != null) {
                    this.officeLocation = (String)this.localOpenOfficeConfig.get("path");
                    if (this.officeLocation == null) {
                        this.officeLocation = "";
                    }
                } else {
                    this.localOpenOfficeConfig = new ConfigMap();
                }
                if (this.remoteOpenOfficeConfig != null) {
                    this.hostname = (String)this.remoteOpenOfficeConfig.get("hostname");
                    this.port = (String)this.remoteOpenOfficeConfig.get("port");
                    if (this.hostname == null) {
                        this.hostname = "";
                        this.port = "";
                    }
                } else {
                    this.remoteOpenOfficeConfig = new ConfigMap();
                }
                if (this.pdfgServiceManagersConfig == null) {
                    this.pdfgServiceManagersConfig = new ConfigMap();
                }
            }
            catch (Exception ex) {
                this.userFontConfigMap = new ConfigMap();
                this.remoteOpenOfficeConfig = new ConfigMap();
                this.localOpenOfficeConfig = new ConfigMap();
            }
            this.userFontConfigMap.init(this, "neo_user_font");
            this.localOpenOfficeConfig.init(this, "openoffice_local_config");
            this.remoteOpenOfficeConfig.init(this, "openoffice_remote_config");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        super.store();
        Vector<ConfigMap> settings = new Vector<ConfigMap>();
        settings.add(0, this.userFontConfigMap);
        settings.add(1, this.localOpenOfficeConfig);
        settings.add(2, this.remoteOpenOfficeConfig);
        settings.add(3, this.pdfgServiceManagersConfig);
        this.serialize(settings, this.config_file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialization() {
        if (this.initialized) {
            return;
        }
        DocumentService documentService = this;
        synchronized (documentService) {
            if (this.initialized) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Map getConfigMap() {
        return this.fontConfigMap;
    }

    public Map getUserConfigMap() {
        return this.userFontConfigMap;
    }

    private File getFontPropertiesFile(String _rootdir, boolean bUseLocale) {
        File fontproperties;
        String lang = Locale.getDefault().getLanguage();
        String propertyfilepath = _rootdir + File.separator + "lib" + File.separator + "cffont.properties";
        String filename = propertyfilepath + "." + lang;
        if (bUseLocale) {
            fontproperties = new File(filename);
            if (!fontproperties.exists() && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                fontproperties = new File(propertyfilepath);
            }
        } else {
            fontproperties = new File(propertyfilepath);
        }
        return fontproperties;
    }

    public void setOfficeLocation(String path) {
        this.officeLocation = path;
        this.localOpenOfficeConfig.put("path", path);
    }

    public void setOpenOfficeRemoteConfig(String hostname, String port) {
        this.hostname = hostname;
        this.port = port;
        this.remoteOpenOfficeConfig.put("hostname", hostname);
        this.remoteOpenOfficeConfig.put("port", port);
    }

    @Override
    public void mapModified(ConfigMap map, Object key, Object value) {
        super.mapModified(map, key, value);
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        super.mapModified(map, key);
    }

    @Override
    public void mapModified() {
        super.mapModified();
    }

    public boolean saveOpenOfficeMap(Map<String, Object> openOfficeMap) {
        Map loo;
        if (openOfficeMap.containsKey("local")) {
            loo = (Map)openOfficeMap.get("local");
            this.localOpenOfficeConfig.clear();
            this.localOpenOfficeConfig.putAll(loo);
            this.localOpenOfficeConfig.remove("type");
        }
        if (openOfficeMap.containsKey("remote")) {
            loo = (Map)openOfficeMap.get("remote");
            this.remoteOpenOfficeConfig.clear();
            this.remoteOpenOfficeConfig.putAll(loo);
            this.remoteOpenOfficeConfig.remove("type");
        }
        try {
            this.store();
        }
        catch (Exception e) {
            logger.error("Exception while storing document", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean savePdfServiceMap(Map<String, Object> pdfServiceMap) {
        this.pdfgServiceManagersConfig.clear();
        pdfServiceMap.forEach((name, pdfService) -> this.pdfgServiceManagersConfig.put(name, new ConfigMap((Map)pdfService)));
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing pdf service(s)", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isInstanceOfDocumentService(Object obj) {
        return obj != null && obj instanceof DocumentService;
    }

    public Map getLocalOpenOfficeMap() {
        return Collections.unmodifiableMap(this.localOpenOfficeConfig);
    }

    public Map getRemoteOpenOfficeMap() {
        return Collections.unmodifiableMap(this.remoteOpenOfficeConfig);
    }

    public Map getPdfServiceMap() {
        return Collections.unmodifiableMap(this.pdfgServiceManagersConfig);
    }

    public static class ServiceManagerExistsException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String host = "";
    }

    public static class LicenseRestrictionServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class InvalidLocalServiceManagerAddressException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String hostname;

        public InvalidLocalServiceManagerAddressException(String hostname) {
            this.hostname = hostname;
        }
    }

    public static class NoSuchServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String name = "";

        public NoSuchServiceManagerException() {
        }

        public NoSuchServiceManagerException(String name) {
            this.name = name;
        }
    }
}

