/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ConfigMapListener;
import coldfusion.ServiceBase;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.nosql.NoSQLDataSourceConsumer;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.service.nosql.NoSQLFactory;
import com.adobe.cfsetup.settings.service.nosql.NoSQLServiceHandle;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoSQLService
extends ServiceBase
implements Observer,
ConfigMapListener {
    private static final Logger logger = LoggerFactory.getLogger(NoSQLService.class);
    private ConfigMap datasourcesDefs;
    private ConfigMap copy;
    private File datasourcefile;
    private Map<String, NoSQLServiceHandle> dataSources = new CaseInsensitiveMap();
    private Map<String, NoSQLFactory> dbServiceFactories = new HashMap<String, NoSQLFactory>();
    private String seed;
    private static final boolean migrate = Boolean.getBoolean("coldfusion.migrate.dsnloadonce");
    public static final String PASSWORD = "password";
    public static final String AUTH_MECHANISM = "authMechanism";
    public static final String INVALID_CREDENTIALS = "InvalidCredentials";
    public static final String USERNAME = "username";
    public static final String PORT = "port";
    public static final String USERNAME_PASSWORD = "USERNAMEPASSWORD";
    public static final String MONGODB_X509 = "MONGODB-X509";
    public static final String GSSAPI = "GSSAPI";
    public static final String PLAIN = "PLAIN";
    public static final String SCRAM_SHA_1 = "SCRAM-SHA-1";
    public static final String SCRAM_SHA_256 = "SCRAM-SHA-256";
    public static final String NONE = "none";
    ValidatorFiller filler = ValidatorFiller.INSTANCE;

    public NoSQLService(File datasourcefile, String rootDir) {
        this.datasourcefile = datasourcefile;
        this.setEnableWatch(true);
        this.setWatchFile(datasourcefile);
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error("Error initializing NoSqlService", (Throwable)e);
        }
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        PasswordUtils.getInstance().addObserver(this);
        this.store();
    }

    Vector loadDataSourceConfig() {
        return (Vector)this.deserialize(this.datasourcefile);
    }

    public Map<?, ?> getDatasources() {
        return this.datasourcesDefs;
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.datasourcesDefs = new ConfigMap(this, "nosql-datasources");
            Vector vDataSource = this.loadDataSourceConfig();
            Map _datasources = (Map)vDataSource.elementAt(0);
            for (String name : _datasources.keySet()) {
                Map c_M = (Map)_datasources.get(name);
                this.datasourcesDefs.put(name, c_M);
            }
            this.datasourcesDefs.setConfigMapListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.dataSources.keySet());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws ServiceException {
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        if (migrate) {
            ConfigMap configMap = this.datasourcesDefs;
            synchronized (configMap) {
                if (this.copy == null) {
                    this.copy = new ConfigMap(this, "nosql-datasources");
                }
                for (Object dsn : this.datasourcesDefs.keySet()) {
                    if (this.copy.containsKey(dsn)) continue;
                    Map ds = (Map)this.datasourcesDefs.get(dsn);
                    this.copy.put(dsn, ds);
                }
                vDatasources.addElement(this.copy);
            }
        }
        ConfigMap configMap = this.datasourcesDefs;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "nosql-datasources");
            for (Object dsn : this.datasourcesDefs.keySet()) {
                Map ds = (Map)this.datasourcesDefs.get(dsn);
                copy.put(dsn, ds);
            }
            vDatasources.addElement(copy);
        }
        this.serialize(vDatasources, this.datasourcefile);
    }

    @Override
    public void mapModified() {
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void mapModified(ConfigMap map, Object key) {
        if (map == this.datasourcesDefs) {
            try {
                this.removeDatasource(key.toString());
            }
            catch (Exception sqle) {
                throw new ServiceRuntimeException(sqle);
            }
        }
        try {
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    public void setDataSource(Map<?, ?> config) {
        this.setDataSource((String)config.get("name"), (String)config.get("type"), config);
    }

    public void setDataSource(String dsn, Map<?, ?> config) {
        String dbType = (String)config.get("type");
        this.setDataSource(dsn, dbType, config);
    }

    public void setDataSource(String dsn, String dbType, Map<?, ?> config) {
        this.datasourcesDefs.put(dsn, config);
    }

    public Map getDatasource(String dsn) {
        return (Map)this.datasourcesDefs.get(dsn);
    }

    public Object removeDatasource(String dsn) {
        Object removed = this.datasourcesDefs.remove(dsn);
        Closeable removedDataSource = this.dataSources.remove(dsn);
        if (removedDataSource != null) {
            try {
                removedDataSource.close();
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
        return removed;
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reEncryptPassword(String oldSeed) {
        Vector<ConfigMap> vDatasources = new Vector<ConfigMap>();
        ConfigMap configMap = this.datasourcesDefs;
        synchronized (configMap) {
            ConfigMap copy = new ConfigMap(this, "nosql-datasources");
            Iterator i = this.datasourcesDefs.keySet().iterator();
            while (i.hasNext()) {
                String dsn = null;
                try {
                    dsn = (String)i.next();
                    ConfigMap ds = (ConfigMap)this.datasourcesDefs.get(dsn);
                    try {
                        String oldPass = (String)ds.get(PASSWORD);
                        ds.put(PASSWORD, PasswordUtils.reEncryptWithNewSeed(oldPass, oldSeed, this.seed));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    ConfigMap clon = new ConfigMap(this, "nosql-datasource");
                    clon.putAll((Map)ds);
                    copy.put(dsn, clon);
                }
                catch (Exception se) {
                    logger.warn("Datasource Exception in Encryption with new Seed: " + dsn, (Throwable)se);
                }
            }
            vDatasources.addElement(copy);
        }
        this.serialize(vDatasources, this.datasourcefile);
    }

    String getSeed() {
        if (null != this.seed) {
            return this.seed;
        }
        return PasswordUtils.getInstance().getSeedValue();
    }

    public boolean isValidNoSQLDBType(String name) {
        return this.dbServiceFactories.containsKey(name);
    }

    public boolean saveDatasource(ConfigMap configMap) {
        this.datasourcesDefs.clear();
        this.datasourcesDefs.putAll((Map)configMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            logger.error("Exception while storing nosql datasource", (Throwable)e);
            return false;
        }
        return true;
    }

    private static String getStringProperty(String key, Map<?, ?> configMap) {
        try {
            return (String)configMap.get(key);
        }
        catch (ClassCastException e) {
            throw new ServiceRuntimeException("The datasource configuration contains an invalid value for " + key + ". Given value is not a valid string.");
        }
    }

    public boolean validateDataSource(Map<?, ?> config) {
        this.filler.fillObject(null, config, new NoSQLDataSourceConsumer(), true);
        String userName = NoSQLService.getStringProperty(USERNAME, config);
        String mechanism = NoSQLService.getStringProperty(AUTH_MECHANISM, config);
        String password = NoSQLService.getStringProperty(PASSWORD, config);
        if (mechanism != null && !mechanism.equalsIgnoreCase(NONE)) {
            if (!mechanism.equalsIgnoreCase(MONGODB_X509) && userName == null) {
                MessageHandler.getInstance().showError(Messages.getString("NOSQL.usernameRequired"));
                return false;
            }
            if ((mechanism.equalsIgnoreCase(GSSAPI) || mechanism.equalsIgnoreCase(MONGODB_X509)) && password != null) {
                MessageHandler.getInstance().showError(Messages.getString("NOSQL.passwordNotRequired"));
                return false;
            }
            if ((mechanism.equalsIgnoreCase(USERNAME_PASSWORD) || mechanism.equalsIgnoreCase(PLAIN) || mechanism.equalsIgnoreCase(SCRAM_SHA_1) || mechanism.equalsIgnoreCase(SCRAM_SHA_256)) && password == null) {
                MessageHandler.getInstance().showError(Messages.getString("NOSQL.passwordRequired"));
                return false;
            }
        }
        return true;
    }
}

