/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.Map;

public class ProbeService
extends ServiceBase {
    private Struct probes;
    private Struct config;
    private Map settingsCopy;
    private Struct settings = new Struct();
    private File file;

    public ProbeService(File probeConfigXmlFile) {
        this.file = probeConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading probe settings, ", e);
        }
    }

    public Map getProbesMap() {
        return Collections.unmodifiableMap((Struct)this.settings.get("probes"));
    }

    public Map getConfigMap() {
        return Collections.unmodifiableMap((Struct)this.settings.get("config"));
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settingsCopy = (Map)this.deserialize(this.file);
            this.settings.putAll(this.settingsCopy);
            this.probes = (Struct)this.settings.get("probes");
            this.config = (Struct)this.settings.get("config");
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedProbe(Map probes) {
        ((Map)this.settings.get("probes")).clear();
        ((Struct)this.settings.get("probes")).putAll(probes);
        try {
            this.store();
        }
        catch (ServiceException e) {
            throw new CFSetupException(Messages.getString("errorFileWrite", Category.PROBE.getFileName()) + e);
        }
    }

    public void storeModifiedProbeConfig(Map config) {
        ((Struct)this.settings.get("config")).clear();
        ((Struct)this.settings.get("config")).putAll(config);
        try {
            this.store();
        }
        catch (ServiceException e) {
            throw new CFSetupException(Messages.getString("errorFileWrite", Category.PROBE.getFileName()) + e);
        }
    }
}

