/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class RestService
extends ServiceBase {
    private ConfigMap settings = null;
    private String defaultApp = "";
    private File file;

    public RestService(File jaxrsConfigXmlFile) {
        this.file = jaxrsConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading Jaxrs settings, ", e);
        }
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = (Vector)this.deserialize(this.file);
            this.defaultApp = (String)v.get(0);
            this.settings = (ConfigMap)v.get(1);
            this.settings.init(this, "mappings");
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.settings, this.file);
    }

    public void storeModifiedMap(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.defaultApp);
        v.addElement(this.settings);
        this.serialize(v, this.file);
    }

    public void checkValidity(String appPath, Map<String, Object> restServices) {
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            return;
        }
        HashMap appSettings = (HashMap)restServices.get(appPath);
        String mapping = (String)appSettings.get("mapping");
        boolean defApp = (Boolean)appSettings.get("isDefault");
        String hostName = (String)appSettings.get("host");
        hostName = hostName != null ? hostName : "";
        mapping = mapping != null ? mapping : "";
        restServices.remove(appPath);
        try {
            appPath = this.getFullPath(appPath);
            if (restServices.containsKey(appPath)) {
                MessageHandler.getInstance().showError(Messages.getString("duplicateServiceKey", Category.REST.name(), ProposedSetting.getInstance().getUserDefinedValue(Category.REST, "rootPath"), appPath));
                throw new CFSetupException(Messages.getString("duplicateServiceKey", Category.REST.name(), ProposedSetting.getInstance().getUserDefinedValue(Category.REST, "rootPath"), appPath));
            }
            restServices.put(appPath, appSettings);
        }
        catch (IOException e) {
            throw new CFSetupException(e);
        }
        for (Map.Entry<String, Object> entry : restServices.entrySet()) {
            String regDir = entry.getKey();
            if (regDir.equalsIgnoreCase(appPath)) continue;
            Map val = (Map)entry.getValue();
            String existingMapping = (String)val.get("mapping");
            if (appPath.length() != regDir.length() && (RestService.isSubDirectory(regDir, appPath) || RestService.isSubDirectory(appPath, regDir))) {
                MessageHandler.getInstance().showError(Messages.getString("nestedRestError", regDir));
                throw new CFSetupException(Messages.getString("nestedRestError", regDir));
            }
            if (existingMapping.equals(mapping)) {
                MessageHandler.getInstance().showError(Messages.getString("duplicateMappingError", regDir));
                throw new CFSetupException(Messages.getString("duplicateMappingError", regDir));
            }
            if (!defApp) continue;
            boolean isDefault = Boolean.valueOf(String.valueOf(val.get("isDefault")));
            String host = (String)val.get("host");
            if (!isDefault || !host.equalsIgnoreCase(hostName)) continue;
            MessageHandler.getInstance().showError(Messages.getString("multipleDefaultAppError", StringUtils.isBlank((CharSequence)hostName) ? "default" : hostName));
            throw new CFSetupException(Messages.getString("multipleDefaultAppError", StringUtils.isBlank((CharSequence)hostName) ? "default" : hostName));
        }
    }

    private String getFullPath(String appPath) throws IOException {
        return this.getFullPath(appPath, true);
    }

    static boolean isSubDirectory(String basePath, String childPath) {
        File base = new File(basePath);
        File child = new File(childPath);
        try {
            base = base.getCanonicalFile();
            child = child.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (File parentFile = child; parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!base.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    private String getFullPath(String appPath, boolean throwException) throws IOException {
        File appFile = new File(appPath);
        if (!appFile.exists()) {
            MessageHandler.getInstance().showError(Messages.getString("missingFile", ProposedSetting.getInstance().getUserDefinedValue(Category.REST, "rootPath"), appFile.getAbsolutePath()));
            throw new CFSetupException(Messages.getString("missingFile", ProposedSetting.getInstance().getUserDefinedValue(Category.REST, "rootPath"), appFile.getAbsolutePath()));
        }
        appPath = appFile.getCanonicalPath();
        return appPath;
    }
}

