/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class RpcService
extends ServiceBase {
    private File file;
    private List<ConfigMap> configMaps = new ArrayList<ConfigMap>();
    private static List<String> fieldnames = Arrays.asList("mappings", "username", "password", "proxyserver", "proxyport", "proxyusername", "proxypassword", "timeout", "version", "authtype", "ntlmdomain", "workstation");
    private static String AUTH_TYPE = "authtype";
    String version = "2";

    public RpcService(File rpcConfigXmlFile) {
        this.file = rpcConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading Rpc settings, ", e);
        }
    }

    public Map getMap() {
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Iterator iterator = this.configMaps.get(0).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry entry = obj = iterator.next();
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            serviceMap.put("url", value);
            for (int i = 1; i < fieldnames.size(); ++i) {
                String field = fieldnames.get(i);
                if (field.equals("version")) {
                    this.version = (String)this.configMaps.get(i).get("version");
                    continue;
                }
                serviceMap.put(field, (String)this.configMaps.get(i).get(key));
            }
            serviceMap.put("name", key);
            map.put(key, serviceMap);
        }
        return map;
    }

    @Override
    public void load() throws ServiceException {
        try {
            int i;
            Vector v = (Vector)this.deserialize(this.file);
            for (i = 0; i < 8; ++i) {
                this.configMaps.add((ConfigMap)v.elementAt(i));
                this.configMaps.get(i).init(this, fieldnames.get(i));
            }
            for (i = 8; i < fieldnames.size(); ++i) {
                if (v.size() >= i + 1) {
                    this.configMaps.add((ConfigMap)v.elementAt(i));
                } else {
                    this.configMaps.add(new ConfigMap());
                }
                this.configMaps.get(i).init(this, fieldnames.get(i));
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
    }

    public void storeModifiedMap(Map map) {
        map = this.convertMap(map);
        Vector<ConfigMap> v = new Vector<ConfigMap>();
        int index = 0;
        for (String field : fieldnames) {
            v.addElement(this.updateMap(this.configMaps.get(index++), (Map)map.get(field)));
        }
        this.serialize(v, this.file);
    }

    public void updateVersion(String version) {
        ((Map)this.configMaps.get(8)).put("version", version);
        this.serialize(this.configMaps, this.file);
    }

    public String getVersion() {
        return (String)this.configMaps.get(8).get("version");
    }

    private ConfigMap updateMap(ConfigMap configMap, Map map) {
        configMap.clear();
        configMap.putAll(map);
        return configMap;
    }

    private Map convertMap(Map map) {
        HashMap convertedMap = new HashMap();
        for (String string : fieldnames) {
            if ("version".equals(string)) {
                HashMap vMap = new HashMap();
                vMap.putAll(this.configMaps.get(8));
                convertedMap.put(string, vMap);
                continue;
            }
            convertedMap.put(string, new HashMap());
        }
        for (Object object : map.entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            String name = (String)entry.getKey();
            Map serviceMap = (Map)entry.getValue();
            ((Map)convertedMap.get("mappings")).put(name, serviceMap.get("url"));
            for (String field : fieldnames) {
                String val;
                if ("version".equals(field) || "mappings".equals(field)) continue;
                String defaultV = "";
                String string = val = serviceMap.get(field) == null ? defaultV : serviceMap.get(field);
                if (AUTH_TYPE.equalsIgnoreCase(field)) {
                    val = val.toLowerCase();
                }
                ((Map)convertedMap.get(field)).put(name, val);
            }
        }
        return convertedMap;
    }
}

