/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.mobile.MobileServlet;
import coldfusion.runtime.ExpressionException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.util.RB;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeService
extends ServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeService.class);
    public static final int DEFAULT_CFTHREAD_POOL = 10;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 1024;
    public static final String COMPILE_EXT_FOR_INCLUDE = "compileextforinclude";
    public static final String BLOCKED_EXT_FOR_FILEUPLOAD = "blockedExtForFileUpload";
    public static final int Max_Cookie_Age = 946080000;
    public static final int DEFAULT_MAX_TOTAL = 200;
    public static final int DEFAULT_MAX_PER_ROUTE = 20;
    public static final long serialVersionUID = 1L;
    public static final int DEF_PORT = 80;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final int DEFAULT_POOL_TIMEOUT = -1;
    public static final int DEFAULT_IDLE_TIMEOUT = 30000;
    private static final String USER_AGENT = "User-Agent";
    private static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    private static final String OTHER_SETTINGS = "otherSettings";
    private File file;
    private String neoRoot;
    protected Boolean whitespace;
    protected ConfigMap locking;
    protected ConfigMap cfx_tags;
    protected ConfigMap custom_tags;
    protected ConfigMap corba;
    protected ConfigMap variables;
    protected ConfigMap errors;
    protected ConfigMap applications = new ConfigMap();
    protected ConfigMap mappings;
    protected ConfigMap request_settings;
    protected ConfigMap template_settings;
    protected ConfigMap charset_settings;
    protected ConfigMap form_settings;
    protected ConfigMap misc_settings;
    protected ConfigMap report_settings;
    protected ConfigMap requestThrottleSettings;
    protected ConfigMap apiManagerSettings;
    protected ConfigMap httpPoolingSettings;
    protected static String defaultMailCharset = "UTF-8";
    protected static String defaultCharset = "UTF-8";
    protected ConfigMap CF5Compatibility;
    protected String CFFormScriptSrc;
    protected Boolean loadRSLLibraries = Boolean.TRUE;
    protected String CFFormCodeBaseUrl = "http://java.sun.com/products/plugin/1.3/jinstall-13-win32.cab#Version=1,3,0,0";
    protected int numSimultaneousReports = 1;
    protected String scriptProtect = "";
    protected static boolean defaultLongIntegerFormat = false;
    private String comMapperDir;
    private String registryDir;
    public static final int APPLICATION_CFC_DEFAULT = 1;
    public static final int APPLICATION_CFC_TILL_WWWROOT = 2;
    public static final int APPLICATION_CFC_IN_WWWROOT = 3;
    protected static final String CACHE_REAL_PATH = "cache.webserver.paths";
    private int applicationCFCSearchCondition = 1;
    private String googleMapKey = null;
    private String serverMobileContext = null;
    private String mobileKey = null;
    private boolean isServerMobileEnabled = false;
    private long appTimeout;
    private long appMaxTimeout;
    private long sessionTimeout;
    private long sessionMaxTimeout;
    private String sessionStorage;
    private String sessionStorageHost;
    private String redisCacheStorageHost;
    private int sessionStoragePort = 6379;
    private int sessionStorageTimeout = 2000;
    private int redisCacheStoragePort;
    private boolean redisCacheStorageIsSSL;
    private boolean sslSessionStorage;
    private boolean sessionStorageCluster;
    private static final String IN_MEMORY_STORAGE = "memory";
    private static final String REDIS_STORAGE = "redis";
    private Boolean isAppEnabled;
    private Boolean isSessionEnabled;
    private Boolean useJ2eeSession;
    private float postSizeLimit = 500.0f;
    private int postParametersLimit = 100;
    private boolean isSecureJSON;
    private boolean preserveCaseForSerialize;
    private String secureJSONPrefix;
    private String serverCFC;
    private boolean enableInMemoryFileSystem;
    private int inMemoryFileSystemLimit;
    private int inMemoryFileSystemAppLimit;
    private boolean httpOnlySessionCookie;
    private boolean secureSessionCookie;
    private int sessionCookieTimeout;
    private String sessionCookieDomain;
    private boolean internalCookiesDisableUpdate;
    private String sessionCookieSamesite;
    private boolean isPureJavaKit = false;
    private long requestTimeoutLimit;
    private boolean timeoutRequestsEnabled = true;
    private boolean logSlowRequestsEnabled = false;
    private long slowRequestTimeLimit;
    private boolean trustedCacheEnabled = false;
    private boolean inRequestTemplateCacheEnabled = true;
    private boolean componentCacheEnabled = true;
    private boolean internalCacheForQueryEnabled = false;
    private int cfthread_pool = 10;
    private boolean cfcTypeCheckEnabled = true;
    private int imageExpiryTime = 300;
    private boolean isPerAppSettingsEnabled = true;
    private boolean disableServiceFactory = false;
    private boolean allowExtraAttributesInAttrColl = true;
    private boolean enableServerCFC = false;
    private boolean disableUnnamedAppScopeDump = false;
    private boolean allowAppVarInContext = false;
    private String compileExtForInclude = "";
    private String blockedExtForFileUpload = "AS,ASP,ASPX,BIN,CFC,CFM,CFML,CFR,CFSWF,DMG,EXE,HBXML,JSP,JSPX,JWS,MXML,PHP,SWC,SWS,CLASS,JAR,ASMX,ASHX";
    private String ORMSearchIndexDirectory;
    private static final int DEFAULT_REQUEST_LIMIT = 8;
    private static final int DEFAULT_CFC_LIMIT = 5;
    private static final int DEFAULT_WEBSERVICE_LIMIT = 5;
    private static final int DEFAULT_REPORT_LIMIT = 8;
    private static final int DEFAULT_QUEUE_TIMEOUT = 60;
    private static final int DEFAUTL_POST_PARAM_LIMIT = 100;
    private static final boolean DEFAULT_ISPERAPPSETTINGSENABLED = true;
    private static final boolean DEFAULT_DISABLE_SERVICE_FACTORY = false;
    private static final boolean DEFAULT_ALLOW_EXTRA_ATTRS_ATTRCOLL = true;
    private static final boolean DEFAULT_ENABLE_SERVER_CFC = false;
    private static final boolean DEFAULT_DISABLE_DUMP_UNNAMED_APPSCOPE = false;
    private static final boolean DEFAULT_ALLOW_APPVAR_INSERVCONTEXT = false;
    public static final String DEFAULT_COMPILE_EXT_INCLUDE = "";
    private static final boolean DEFAULT_ALLOW_REST_DISCOVERY = false;
    private static final String START_API_MANAGER = "startAPIManager";
    private static final String ALLOW_REST_DISCOVERY = "allowRestDiscovery";
    private static final boolean DEFAULT_ENABLE_NULL_SUPPORT = false;
    private static final boolean DEFAULT_USE_JAVA_AS_REGEX_ENGINE = false;
    private static final String ENABLE_NULL_SUPPORT = "enableNullSupport";
    private static final String USE_JAVA_AS_REGEX_ENGINE = "useJavaAsRegexEngine";
    private static final int DEFAULT_CORE_POOL_SIZE = 0;
    private static final int DEFAULT_MAX_POOL_SIZE = 0;
    private static final long DEFAULT_KEEP_ALIVE_TIME = 6000L;
    private boolean isCommandLineCompile = false;
    private String workingDir;
    private boolean isFileLockEnabled = true;
    private String tmpCacheDir;
    private Boolean startAPIManager = null;
    private boolean allowRestDiscovery = false;
    private boolean enableNullSupport = false;
    private boolean useJavaAsRegexEngine = false;
    private int corePoolSize = 0;
    private int maxPoolSize = 0;
    private long keepAliveTime = 6000L;
    private static final boolean isFiddleEnabled = Boolean.parseBoolean(System.getProperty("coldfusion.fiddle.enable", "false"));
    public static final String OLDSEEDVAL = "0yJ!@1&r%gG^?az=|J!@1r7@";
    private String seed;
    private String webroot;
    private static final String[] cfcTags = new String[]{"collection", "dbinfo", "feed", "ftp", "http", "imap", "index", "ldap", "mail", "pdf", "pop", "query", "Search", "storedproc"};
    private static final String ALLOWED_EXT_FOR_HANDLERS = "cfm,cfml,htm,html";
    private static final String ALLOWED_EXT_FOR_TIMEOUT_HANDLERS = "htm,html";
    public static final String MAX_TOTAL_HTTP_CONNECTIONS = "maxTotal";
    public static final String MAX_HTTP_CONNECTIONSPER_ROUTE = "maxPerRoute";
    public static final String HTTP_POOL_SOCKET_IDLE_TIMEOUT = "maxIdleTimeout";
    public static final String HTTP_POOL_SOCKET_TIMEOUT = "timeout";
    public static final String USE_HTTP_POOLING = "usepooling";
    public static final boolean DEFAULT_HTTP_POOLING = Boolean.valueOf(System.getProperty("coldfusion.http.usepooling", "false"));
    public static final String CORE_POOL_SIZE = "corePoolSize";
    public static final String MAX_POOL_SIZE = "maxPoolSize";
    public static final String KEEP_ALIVE_TIME = "keepAliveTime";
    public static final String DEFAULT_BLOCKED_EXT_FOR_FILEUPLOAD = "AS,ASP,ASPX,BIN,CFC,CFM,CFML,CFR,CFSWF,DMG,EXE,HBXML,JSP,JSPX,JWS,MXML,PHP,SWC,SWS,CLASS,JAR,ASMX,ASHX";

    public RuntimeService(File file, String neoRoot) {
        this.file = file;
        this.neoRoot = neoRoot;
        this.webroot = file.getParentFile().getParent() + File.separator + "wwwroot";
        this.setEnableWatch(true);
        this.setWatchFile(file);
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error(StringUtils.isBlank((CharSequence)e.getMessage()) ? "Error while loading neo-runtime.xml" : e.getMessage(), (Throwable)e);
            throw new CFSetupException(StringUtils.isBlank((CharSequence)e.getMessage()) ? "Error while loading neo-runtime.xml" : e.getMessage());
        }
    }

    public Map getErrors() {
        return this.errors;
    }

    public String getSiteWideErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("site_wide").toString();
        }
        return null;
    }

    public void setSiteWideErrorHandler(String handler) {
        if (handler != null) {
            RuntimeService.validateFileExtension(handler, ALLOWED_EXT_FOR_HANDLERS);
            this.errors.put("site_wide", handler);
        }
    }

    public String getTimeoutErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("queue_timeout").toString();
        }
        return null;
    }

    public boolean isAllowRestDiscovery() {
        return (Boolean)this.apiManagerSettings.get(ALLOW_REST_DISCOVERY);
    }

    public void setAllowRestDiscovery(boolean allow) {
        this.allowRestDiscovery = allow;
        this.apiManagerSettings.put(ALLOW_REST_DISCOVERY, (Object)allow);
    }

    public void setTimeoutErrorHandler(String handler) {
        if (handler != null) {
            RuntimeService.validateFileExtension(handler, ALLOWED_EXT_FOR_TIMEOUT_HANDLERS);
            this.errors.put("queue_timeout", handler);
        }
    }

    public String getMissingTemplateErrorHandler() {
        if (this.errors != null) {
            return this.errors.get("missing_template").toString();
        }
        return null;
    }

    public void setMissingTemplateErrorHandler(String handler) {
        if (handler != null) {
            RuntimeService.validateFileExtension(handler, ALLOWED_EXT_FOR_HANDLERS);
            this.errors.put("missing_template", handler);
        }
    }

    public Map getMappings() {
        return this.mappings;
    }

    public Map getCustomtags() {
        return this.custom_tags;
    }

    public Map getVariables() {
        return this.variables;
    }

    public String getScriptProtect() {
        return this.scriptProtect;
    }

    public boolean isFileLockEnabled() {
        return this.isFileLockEnabled;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
    }

    @Override
    public void load() throws ServiceException {
        try {
            Vector v = this.loadSettings();
            this.whitespace = (Boolean)v.elementAt(0);
            this.locking = (ConfigMap)v.elementAt(1);
            this.cfx_tags = (ConfigMap)v.elementAt(2);
            this.custom_tags = (ConfigMap)v.elementAt(3);
            this.corba = (ConfigMap)v.elementAt(4);
            this.variables = (ConfigMap)v.elementAt(5);
            this.errors = (ConfigMap)v.elementAt(6);
            this.initMissingSetting(this.errors, "queue_timeout", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.errors, "missing_template", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.errors, "site_wide", DEFAULT_COMPILE_EXT_INCLUDE);
            this.mappings = (ConfigMap)v.elementAt(7);
            this.request_settings = (ConfigMap)v.elementAt(8);
            this.initMissingSetting(this.request_settings, "requestLimit", new Integer(8));
            this.initMissingSetting(this.request_settings, "webserviceLimit", new Integer(5));
            this.initMissingSetting(this.request_settings, "CFCLimit", new Integer(5));
            this.initMissingSetting(this.request_settings, "queueTimeout", new Integer(60));
            this.initMissingSetting(this.request_settings, "cacheWebServerPath", Boolean.FALSE);
            this.initMissingSetting(this.request_settings, "postParametersLimit", new Integer(100));
            System.setProperty(CACHE_REAL_PATH, this.request_settings.get("cacheWebServerPath").toString());
            this.template_settings = (ConfigMap)v.elementAt(9);
            this.initMissingSetting(this.template_settings, "componentCacheEnabled", new Boolean(true));
            this.charset_settings = v.size() > 10 ? (ConfigMap)v.elementAt(10) : new ConfigMap();
            this.initMissingSetting(this.charset_settings, "defaultCharset", defaultCharset);
            this.initMissingSetting(this.charset_settings, "defaultMailCharset", defaultMailCharset);
            this.CF5Compatibility = v.size() > 11 ? (ConfigMap)v.elementAt(11) : new ConfigMap();
            this.initMissingSetting(this.CF5Compatibility, "longIntegerFormat", defaultLongIntegerFormat);
            this.form_settings = v.size() > 12 ? (ConfigMap)v.elementAt(12) : new ConfigMap();
            this.initMissingSetting(this.form_settings, "CFFormScriptSrc", this.CFFormScriptSrc);
            this.initMissingSetting(this.form_settings, "loadRSLLibraries", this.loadRSLLibraries);
            this.initMissingSetting(this.form_settings, "CFFormCodeBaseUrl", this.CFFormCodeBaseUrl);
            this.scriptProtect = v.size() > 13 ? (String)v.elementAt(13) : DEFAULT_COMPILE_EXT_INCLUDE;
            this.misc_settings = v.size() > 14 ? (ConfigMap)v.elementAt(14) : new ConfigMap();
            this.initMissingSetting(this.misc_settings, "fileLockEnabled", this.isFileLockEnabled);
            this.initMissingSetting(this.misc_settings, "cfthreadpool", new Integer(10));
            this.initMissingSetting(this.misc_settings, "isPerAppSettingsEnabled", true);
            this.initMissingSetting(this.misc_settings, "disableServiceFactory", false);
            this.initMissingSetting(this.misc_settings, "cfcTypeCheckEnabled", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "imageExpiryTime", new Integer(300));
            this.initMissingSetting(this.misc_settings, "preserveCaseForSerialize", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "secureJSON", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "secureJSONPrefix", "//");
            this.initMissingSetting(this.misc_settings, "secureJSON", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "enableInMemoryFileSystem", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemLimit", new Integer(100));
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemAppLimit", new Integer(20));
            this.initMissingSetting(this.misc_settings, "inMemoryFileSystemAppLimit", new Integer(20));
            this.initMissingSetting(this.misc_settings, "allowExtraAttributesInAttrColl", true);
            this.initMissingSetting(this.misc_settings, "maxOutputBufferSize", new Integer(1024));
            this.initMissingSetting(this.misc_settings, "enableServerCFC", false);
            this.initMissingSetting(this.misc_settings, "serverCFC", "Server");
            this.initMissingSetting(this.misc_settings, "googleMapKey", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "mobileKey", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "ORMSearchIndexDirectory", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "applicationCFCSearchLimit", "1");
            this.initMissingSetting(this.misc_settings, "httpOnlySessionCookie", Boolean.TRUE);
            this.initMissingSetting(this.misc_settings, "secureSessionCookie", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "sessionCookieTimeout", 946080000);
            this.initMissingSetting(this.misc_settings, "sessionCookieDomain", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "internalCookiesDisableUpdate", Boolean.FALSE);
            this.initMissingSetting(this.misc_settings, "sessionCookieSamesite", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "dumpunnamedappscope", new Boolean(false));
            this.initMissingSetting(this.misc_settings, "allowappvarincontext", new Boolean(false));
            this.initMissingSetting(this.misc_settings, COMPILE_EXT_FOR_INCLUDE, DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "sessionStorage", IN_MEMORY_STORAGE);
            this.initMissingSetting(this.misc_settings, "sessionStorageHost", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "sessionStoragePort", 6379);
            this.initMissingSetting(this.misc_settings, "sessionStoragePassword", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.misc_settings, "sessionStorageTimeout", 2000);
            this.initMissingSetting(this.template_settings, "redisCacheStorageHost", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.template_settings, "redisCacheStoragePort", 0);
            this.initMissingSetting(this.template_settings, "redisCacheStoragePassword", DEFAULT_COMPILE_EXT_INCLUDE);
            this.initMissingSetting(this.template_settings, "redisCacheStorageIsSSL", false);
            this.initMissingSetting(this.template_settings, "sessionStorageCluster", false);
            this.initMissingSetting(this.misc_settings, ENABLE_NULL_SUPPORT, false);
            this.enableNullSupport = (Boolean)this.misc_settings.get(ENABLE_NULL_SUPPORT);
            this.initMissingSetting(this.misc_settings, USE_JAVA_AS_REGEX_ENGINE, false);
            this.useJavaAsRegexEngine = (Boolean)this.misc_settings.get(USE_JAVA_AS_REGEX_ENGINE);
            this.initMissingSetting(this.misc_settings, CORE_POOL_SIZE, 0);
            this.initMissingSetting(this.misc_settings, MAX_POOL_SIZE, 0);
            this.initMissingSetting(this.misc_settings, KEEP_ALIVE_TIME, 6000L);
            this.report_settings = v.size() > 15 ? (ConfigMap)v.elementAt(15) : new ConfigMap();
            this.initMissingSetting(this.report_settings, "numSimultaneousReports", new Integer(8));
            this.requestThrottleSettings = v.size() > 16 ? (ConfigMap)v.elementAt(16) : new ConfigMap();
            if (v.size() > 17) {
                this.apiManagerSettings = (ConfigMap)v.elementAt(17);
                if (this.apiManagerSettings.containsKey(START_API_MANAGER)) {
                    this.startAPIManager = (Boolean)this.apiManagerSettings.get(START_API_MANAGER);
                }
                if (this.apiManagerSettings.containsKey(ALLOW_REST_DISCOVERY)) {
                    this.allowRestDiscovery = (Boolean)this.apiManagerSettings.get(ALLOW_REST_DISCOVERY);
                }
            } else {
                this.apiManagerSettings = new ConfigMap();
            }
            this.httpPoolingSettings = v.size() > 18 ? (ConfigMap)v.elementAt(18) : new ConfigMap();
            this.initMissingSetting(this.httpPoolingSettings, USE_HTTP_POOLING, DEFAULT_HTTP_POOLING);
            this.initMissingSetting(this.httpPoolingSettings, MAX_TOTAL_HTTP_CONNECTIONS, 200);
            this.initMissingSetting(this.httpPoolingSettings, MAX_HTTP_CONNECTIONSPER_ROUTE, 20);
            this.initMissingSetting(this.httpPoolingSettings, HTTP_POOL_SOCKET_TIMEOUT, -1);
            this.initMissingSetting(this.httpPoolingSettings, HTTP_POOL_SOCKET_IDLE_TIMEOUT, 30000);
            this.initMissingSetting(this.misc_settings, BLOCKED_EXT_FOR_FILEUPLOAD, DEFAULT_BLOCKED_EXT_FOR_FILEUPLOAD);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
        this.locking.init(this, "locking");
        this.cfx_tags.init(this, "cfx_tags");
        this.initMap(this.cfx_tags, "cfx");
        this.custom_tags.init(this, "custom_tags");
        this.corba.init(this, "corba");
        if (this.corba.containsKey("orbs")) {
            ((ConfigMap)this.corba.get("orbs")).init(this, "orbs");
        }
        this.variables.init(this, "variables");
        ((ConfigMap)this.variables.get("application")).init(this, "application");
        ((ConfigMap)this.variables.get("session")).init(this, "session");
        this.mappings.init(this, "mappings");
        this.request_settings.init(this, "request_settings");
        this.errors.init(this, "errors");
        if (!RuntimeService.isValidFileExtension(this.getMissingTemplateErrorHandler(), ALLOWED_EXT_FOR_HANDLERS)) {
            logger.error(RB.getString(this, "RuntimeServiceImpl.invalid_missing_template_file_extension"));
            this.setMissingTemplateErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        if (!RuntimeService.isValidFileExtension(this.getSiteWideErrorHandler(), ALLOWED_EXT_FOR_HANDLERS)) {
            logger.error(RB.getString(this, "RuntimeServiceImpl.invalid_sitewide_error_file_extension"));
            this.setSiteWideErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        if (!RuntimeService.isValidFileExtension(this.getTimeoutErrorHandler(), ALLOWED_EXT_FOR_TIMEOUT_HANDLERS)) {
            logger.error(RB.getString(this, "RuntimeServiceImpl.invalid_queue_timeout_file_extension"));
            this.setTimeoutErrorHandler(DEFAULT_COMPILE_EXT_INCLUDE);
        }
        this.applications.init(this, "applications");
        this.initMap(this.applications, "application");
        this.misc_settings.init(this, "misc");
        this.locking.setConfigMapListener(this);
        this.cfx_tags.setConfigMapListener(this);
        this.custom_tags.setConfigMapListener(this);
        this.corba.setConfigMapListener(this);
        ((ConfigMap)this.variables.get("session")).setConfigMapListener(this);
        ((ConfigMap)this.variables.get("application")).setConfigMapListener(this);
        this.mappings.setConfigMapListener(this);
        this.errors.setConfigMapListener(this);
        this.applications.setConfigMapListener(this);
        this.request_settings.setConfigMapListener(this);
        this.template_settings.setConfigMapListener(this);
        this.charset_settings.setConfigMapListener(this);
        this.form_settings.setConfigMapListener(this);
        this.CF5Compatibility.setConfigMapListener(this);
        this.misc_settings.setConfigMapListener(this);
        this.report_settings.setConfigMapListener(this);
        this.requestThrottleSettings.setConfigMapListener(this);
        this.apiManagerSettings.setConfigMapListener(this);
        this.httpPoolingSettings.setConfigMapListener(this);
        System.setProperty("jasper.reports.compile.xml.validation", "false");
    }

    Vector loadSettings() {
        return (Vector)this.deserialize(this.file);
    }

    @Override
    public void store() throws ServiceException {
        Vector<Object> v = new Vector<Object>();
        v.addElement(this.whitespace);
        v.addElement(this.locking);
        v.addElement(this.cfx_tags);
        v.addElement(this.custom_tags);
        v.addElement(this.corba);
        v.addElement(this.variables);
        v.addElement(this.errors);
        v.addElement(this.mappings);
        v.addElement(this.request_settings);
        v.addElement(this.template_settings);
        v.addElement(this.charset_settings);
        v.addElement(this.CF5Compatibility);
        v.addElement(this.form_settings);
        v.addElement(this.scriptProtect);
        v.addElement(this.misc_settings);
        v.addElement(this.report_settings);
        v.addElement(this.requestThrottleSettings);
        v.addElement(this.apiManagerSettings);
        this.serialize(v, this.file);
        this.notifyServiceListeners();
    }

    public Map<String, Object> getMap() {
        return MapUtils.unmodifiableMap(this.getRuntimeSetting());
    }

    public Map<String, Map<String, Object>> getRuntimeSetting() {
        HashMap<String, Map<String, Object>> runtimeMap = new HashMap<String, Map<String, Object>>();
        runtimeMap.put("locking", this.locking);
        runtimeMap.put("variables", this.variables);
        runtimeMap.put("errors", this.errors);
        runtimeMap.put("request_settings", this.request_settings);
        runtimeMap.put("template_settings", this.template_settings);
        runtimeMap.put("charset_settings", this.charset_settings);
        runtimeMap.put("CF5Compatibility", this.CF5Compatibility);
        runtimeMap.put("form_settings", this.form_settings);
        runtimeMap.put("misc_settings", this.misc_settings);
        runtimeMap.put("report_settings", this.report_settings);
        runtimeMap.put("requestThrottleSettings", this.requestThrottleSettings);
        runtimeMap.put("apiManagerSettings", this.apiManagerSettings);
        ConfigMap corbaMap = new ConfigMap();
        if (this.corba.containsKey("logging")) {
            corbaMap.put("logging", this.corba.get("logging"));
        }
        runtimeMap.put("corba_settings", corbaMap);
        HashMap<String, Boolean> otherSettings = new HashMap<String, Boolean>();
        runtimeMap.put(OTHER_SETTINGS, otherSettings);
        otherSettings.put("scriptProtect", StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.scriptProtect}));
        otherSettings.put("whitespace", this.whitespace);
        if (!Util.isJEEDeployment(this.file.getParentFile().getParent())) {
            otherSettings.put("isMobileCorsEnabled", MobileServlet.isCORSEnabled(this.webroot));
        }
        return runtimeMap;
    }

    private void initMissingSetting(Map map, String setting, Object def) {
        if (map.containsKey(setting)) {
            return;
        }
        map.put(setting, def);
    }

    public boolean saveModifiedMappingMap(Map<String, Object> runtimeMappingsMap) {
        this.mappings.clear();
        this.mappings.putAll(runtimeMappingsMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorFileWrite", Category.MAPPING.getFileName()));
            logger.error(Messages.getString("errorFileWrite", Category.MAPPING.getFileName()), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean saveModifiedCustomtagsMap(Map<String, Object> customTagsMap) {
        this.custom_tags.clear();
        this.custom_tags.putAll(customTagsMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorFileWrite", Category.CUSTOMTAG.getFileName()));
            logger.error(Messages.getString("errorFileWrite", Category.CUSTOMTAG.getFileName()), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean saveModifiedRuntimeMap(Map<String, Map<String, Object>> map) {
        this.getRuntimeSetting().forEach((name, value) -> {
            if (name.equalsIgnoreCase(OTHER_SETTINGS)) {
                this.saveOthers((Map)map.get(name));
            } else {
                value.putAll((Map)map.get(name));
            }
        });
        try {
            this.store();
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorFileWrite", Category.CUSTOMTAG.getFileName()));
            logger.error(Messages.getString("errorFileWrite", Category.RUNTIME.getFileName()), (Throwable)e);
            return false;
        }
        return true;
    }

    private void saveOthers(Map<String, Object> otherSettings) {
        otherSettings.forEach((settingKey, value) -> {
            switch (settingKey) {
                case "scriptProtect": {
                    if (((Boolean)value).booleanValue()) {
                        this.scriptProtect = "FORM,URL,COOKIE,CGI";
                        break;
                    }
                    this.scriptProtect = DEFAULT_COMPILE_EXT_INCLUDE;
                    break;
                }
                case "whitespace": {
                    this.whitespace = (Boolean)value;
                    break;
                }
                case "isMobileCorsEnabled": {
                    if (Util.isJEEDeployment(this.file.getParentFile().getParent())) break;
                    MobileServlet.enableCORS(this.webroot, (Boolean)value);
                }
            }
        });
    }

    public Map<String, Object> getRuntimeCacheSetting() {
        Object cacheEnabled;
        this.redisCacheStorageHost = (String)this.template_settings.get("redisCacheStorageHost");
        if (this.template_settings.get("redisCacheStoragePort") != null) {
            this.redisCacheStoragePort = ((Number)this.template_settings.get("redisCacheStoragePort")).intValue();
        }
        this.trustedCacheEnabled = (Boolean)this.template_settings.get("trustedCacheEnabled");
        if (this.template_settings.get("redisCacheStorageIsSSL") != null) {
            this.redisCacheStorageIsSSL = (Boolean)this.template_settings.get("redisCacheStorageIsSSL");
        }
        if (this.template_settings.get("sslSessionStorage") != null) {
            this.sslSessionStorage = (Boolean)this.template_settings.get("sslSessionStorage");
        }
        if ((cacheEnabled = this.template_settings.get("inRequestTemplateCacheEnabled")) != null) {
            this.inRequestTemplateCacheEnabled = (Boolean)cacheEnabled;
        }
        this.componentCacheEnabled = (Boolean)this.template_settings.get("componentCacheEnabled");
        this.internalCacheForQueryEnabled = (Boolean)this.template_settings.get("enableInternalQueryCache");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("redisCacheStorageHost", this.redisCacheStorageHost);
        map.put("redisCacheStoragePort", this.redisCacheStoragePort);
        map.put("redisCacheStorageIsSSL", this.redisCacheStorageIsSSL);
        map.put("sslSessionStorage", this.sslSessionStorage);
        map.put("trustedCacheEnabled", this.trustedCacheEnabled);
        map.put("inRequestTemplateCacheEnabled", this.inRequestTemplateCacheEnabled);
        map.put("componentCacheEnabled", this.componentCacheEnabled);
        map.put("enableInternalQueryCache", this.internalCacheForQueryEnabled);
        return map;
    }

    public Map<String, Object> getCacheSettings() {
        String[] types = new String[]{"memcached", REDIS_STORAGE, "jcs"};
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String type : types) {
            String cacheFile = this.neoRoot + File.separator + "lib" + File.separator + type + "cache.properties";
            if (type.equalsIgnoreCase("jcs")) {
                cacheFile = this.neoRoot + File.separator + "lib" + File.separator + "cache.ccf";
            }
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(cacheFile));
                if ("jcs".equalsIgnoreCase(type)) {
                    HashMap<String, String> jcsMap = new HashMap<String, String>();
                    if (prop.getProperty("jcs.default.elementattributes.IdleTime") != null) {
                        jcsMap.put("timeToIdleSeconds", prop.getProperty("jcs.default.elementattributes.IdleTime"));
                    }
                    if (prop.getProperty("jcs.default.elementattributes.MaxLife") != null) {
                        jcsMap.put("timeToLiveSeconds", prop.getProperty("jcs.default.elementattributes.MaxLife"));
                    }
                    if (prop.getProperty("jcs.default.cacheattributes.MaxObjects") != null) {
                        jcsMap.put("maxElementsInMemory", prop.getProperty("jcs.default.cacheattributes.MaxObjects"));
                    }
                    if (prop.getProperty("jcs.default.elementattributes.IsEternal") != null) {
                        jcsMap.put("eternal", prop.getProperty("jcs.default.elementattributes.IsEternal"));
                    }
                    map.put(type, jcsMap);
                    continue;
                }
                map.put(type, new HashMap<Object, Object>(prop));
            }
            catch (Exception e) {
                logger.error("Error reading server level properties for cache engine : " + type, (Throwable)e);
            }
        }
        return map;
    }

    public void setCacheSettings(Map<String, Object> map) {
        String[] types;
        for (String type : types = new String[]{"memcached", REDIS_STORAGE, "jcs"}) {
            String cacheFile = this.neoRoot + File.separator + "lib" + File.separator + type + "cache.properties";
            if (type.equalsIgnoreCase("jcs")) {
                cacheFile = this.neoRoot + File.separator + "lib" + File.separator + "/cache.ccf";
            }
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(cacheFile));
                if ("jcs".equalsIgnoreCase(type)) {
                    Map jcsMap = (Map)map.get(type);
                    if (jcsMap.containsKey("timeToIdleSeconds")) {
                        prop.setProperty("jcs.default.elementattributes.IdleTime", (String)jcsMap.get("timeToIdleSeconds"));
                    }
                    if (jcsMap.containsKey("timeToLiveSeconds")) {
                        prop.setProperty("jcs.default.elementattributes.MaxLife", (String)jcsMap.get("timeToLiveSeconds"));
                    }
                    if (jcsMap.containsKey("maxElementsInMemory")) {
                        prop.setProperty("jcs.default.cacheattributes.MaxObjects", (String)jcsMap.get("maxElementsInMemory"));
                    }
                    if (jcsMap.containsKey("eternal")) {
                        prop.setProperty("jcs.default.elementattributes.IsEternal", (String)jcsMap.get("eternal"));
                    }
                    map.put(type, jcsMap);
                } else {
                    prop.putAll((Map<?, ?>)((Map)map.get(type)));
                }
                Properties tmp = new Properties(){

                    @Override
                    public synchronized Enumeration<Object> keys() {
                        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
                    }
                };
                tmp.putAll((Map<?, ?>)prop);
                FileOutputStream fos = new FileOutputStream(cacheFile);
                tmp.store(fos, null);
            }
            catch (Exception e) {
                logger.error("Error saving caching server level properties for cache engine : " + type, (Throwable)e);
                throw new CFSetupException(e.getMessage(), e);
            }
        }
    }

    public final boolean isTrustedCache() {
        return this.trustedCacheEnabled;
    }

    public void setTrustedCache(boolean b) {
        this.template_settings.put("trustedCacheEnabled", (Object)b);
        this.trustedCacheEnabled = b;
    }

    private static void validateFileExtension(String fileName, String allowedExt) {
        if (!RuntimeService.isValidFileExtension(fileName, allowedExt)) {
            throw new InvalidFileExtensionException(fileName, allowedExt);
        }
    }

    private static boolean isValidFileExtension(String fileName, String allowedExt) {
        if (fileName != null && fileName.trim().length() > 0) {
            int index = fileName.lastIndexOf(".");
            if (index > -1) {
                String extension = fileName.substring(index + 1, fileName.length());
                for (String ext : allowedExt.split(",")) {
                    if (!ext.equalsIgnoreCase(extension)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static class InvalidFileExtensionException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String ext = null;
        public String fileName = null;

        InvalidFileExtensionException(String fileName, String ext) {
            this.fileName = fileName;
            this.ext = ext;
        }
    }
}

