/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SecureProfileService
extends ServiceBase {
    private ConfigMap secureProfileSettings;
    private Vector driverSettings;
    private File secureProfileFile;
    private File driverFile;

    public SecureProfileService(String libPath) {
        this.secureProfileFile = new File(libPath + File.separator + "neo-secureprofile.xml");
        this.driverFile = new File(libPath + File.separator + "neo-drivers.xml");
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading  settings, ", e);
        }
    }

    public Map getMap() {
        HashMap map = new HashMap();
        map.putAll(this.secureProfileSettings);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.secureProfileSettings = (ConfigMap)this.deserialize(this.secureProfileFile);
            this.driverSettings = (Vector)this.deserialize(this.driverFile);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() {
        this.serialize(this.secureProfileSettings, this.secureProfileFile);
    }

    public void storeModifiedMap(Map map) {
        this.secureProfileSettings.clear();
        this.secureProfileSettings.putAll(map);
        this.serialize(this.secureProfileSettings, this.secureProfileFile);
    }

    public Object getDriverSetting(String key) {
        return ((ConfigMap)this.driverSettings.get(1)).get(key);
    }

    public Map getDriverConfigurationMap() {
        return (ConfigMap)this.driverSettings.get(1);
    }

    public void setDriverConfigurationMap(Map map) {
        this.driverSettings.set(1, map);
        this.serialize(this.driverSettings, this.driverFile);
    }
}

