/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import coldfusion.security.SecurityUtils;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.util.FastHashtable;
import coldfusion.util.FileUtils;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.EntryPoint;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.SettingInstanceProvider;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.AdminLdapConfigSettings;
import com.adobe.cfsetup.settings.DatasourceSettings;
import com.adobe.cfsetup.settings.JvmSettings;
import com.adobe.cfsetup.settings.simple.AdminPasswordSettings;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityService
extends ServiceBase {
    private ConfigMap settings = null;
    private File file;
    private String selectedPath;
    private Properties seedProperties;
    private String seed;
    private static final Logger logger = LoggerFactory.getLogger(SecurityService.class);
    public static Set<String> allTags = new HashSet<String>(Arrays.asList("cfcontent", "cfdirectory", "cffile", "cfobject", "cfregistry", "cfexecute", "cfftp", "cfmail", "cflog", "cfcollection", "cfcookie", "cfhttp", "cfhttpparam", "cfindex", "cfldap", "cfinvoke", "cfschedule", "cfsearch", "cftransaction", "cfpop", "cfquery", "cfinsert", "cfupdate", "cfstoredproc", "cfgridupdate", "cfdocument", "cfreport", "cfthread", "cfimage", "cffeed", "cfexchangeconnection", "cfexchangecalendar", "cfexchangemail", "cfexchangecontact", "cfexchangetask", "cfpdf", "cfprint", "cfdbinfo", "cfobjectcache", "cfsharepoint", "cfspreadsheet", "cfcache", "cfimap", "cffileupload", "cfexchangeconversation", "cfexchangefolder", "cfwebsocket", "cfhtmltopdf"));
    public static Set<String> allFunctions = new HashSet<String>(Arrays.asList("createobject", "createobject(com)", "createobject(corba)", "createobject(java)", "createobject(.net)", "createobject(webservice)", "directoryexists", "expandpath", "fileopen", "fileexists", "filecopy", "filemove", "filedelete", "fileread", "fileupload", "fileuploadall", "filewrite", "filesetattribute", "filesetaccessmode", "filesetlastmodified", "getfileinfo", "directorycreate", "directorycopy", "directorylist", "directorydelete", "directoryrename", "getdirectoryfrompath", "getfilefrompath", "getgatewayhelper", "getprinterinfo", "getprofilestring", "gettempdirectory", "gettempfile", "getbasetemplatepath", "loadcfobject", "savecfobject", "sendgatewaymessage", "setprofilestring", "createdynamicproxy", "cachegetallids", "cachegetsession", "cacheremoveall", "cacheregionnew", "cacheregionremove", "cachesetproperties", "removecachedquery", "getcpuusage", "getsystemfreememory", "getsystemtotalmemory", "gettotalspace", "getfreespace", "getpagecontext", "islocalhost", "objectsave", "objectload", "getcloudservice", "getmongoservice", "getpropertyfile", "getpropertystring", "setpropertystring"));
    public static Set<String> allRuntimePerms = new HashSet<String>(Arrays.asList("accessClassInPackage.*", "accessDeclaredMembers", "createSecurityManager", "defineClassInPackage.*", "enableContextClassLoaderOverride", "getClassLoader", "getenv.*", "getProtectionDomain", "getStackTrace", "modifyThread", "preferences", "queuePrintJob", "readFileDescriptor", "setContextClassLoader", "setDefaultUncaughtExceptionHandler", "shutdownHooks", "stopThread", "writeFileDescriptor"));
    private static List<String> securityConfigSettings = Arrays.asList("admin.userid.required", "admin.security.enabled", "allowconcurrentadminlogin", "rds.enabled", "secureprofile.enabled", "rds.security.enabled", "rds.security.usesinglerdspassword", "externalAuth");

    public SecurityService(File securityFile, String selectedPath) {
        this.selectedPath = selectedPath;
        this.file = securityFile;
        this.seed = this.getSeed();
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading security setting, ", e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.file);
            this.settings.init(this, "configuration");
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    public Map getUsersMap() {
        HashMap authorizedUsers = new HashMap();
        if (this.settings.get("AuthorizedUsers") != null) {
            authorizedUsers = (HashMap)this.settings.get("AuthorizedUsers");
        }
        HashMap map = new HashMap();
        Iterator iterator = authorizedUsers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String k = (String)entry.getKey();
            HashMap v = (HashMap)entry.getValue();
            HashMap valueMap = new HashMap();
            map.put(k, valueMap);
            this.fillMap(valueMap, Category.USER);
            v.entrySet().forEach(e -> {
                String key = (String)((Map.Entry)e).getKey();
                Object value = ((Map.Entry)e).getValue();
                if ("roles".equalsIgnoreCase(key) || "exposedServices".equalsIgnoreCase(key)) {
                    valueMap.put(key, new HashSet((List)value));
                } else if (!"sandboxes".equalsIgnoreCase(key)) {
                    valueMap.put(key, value);
                } else {
                    Vector sandboxes = (Vector)value;
                    sandboxes.forEach(s -> {
                        Struct x = (Struct)s;
                        String clazz = (String)x.get("CLASS");
                        Object permission = (String)x.get("TARGET");
                        if ("java.io.FilePermission".equals(clazz)) {
                            Object action = (String)x.get("ACTION");
                            String[] actions = ((String)action).split(",");
                            action = "";
                            for (String a : actions) {
                                if ("read".equalsIgnoreCase(a)) {
                                    action = (String)action + "r";
                                }
                                if ("execute".equalsIgnoreCase(a)) {
                                    action = (String)action + "x";
                                }
                                if ("write".equalsIgnoreCase(a)) {
                                    action = (String)action + "w";
                                }
                                if (!"delete".equalsIgnoreCase(a)) continue;
                                action = (String)action + "d";
                            }
                            permission = (String)(StringUtils.isBlank((String)action) ? "" : (String)action + ":") + (String)permission;
                            ((Set)valueMap.get("sandboxes")).add(permission);
                        }
                        if ("coldfusion.sql.DataSourcePermission".equals(clazz)) {
                            ((Set)valueMap.get("datasources")).add(permission);
                        }
                    });
                }
            });
        }
        return Collections.unmodifiableMap(map);
    }

    public Map getIpMap() {
        HashMap<String, HashSet<String>> ipMap = new HashMap<String, HashSet<String>>();
        HashSet<String> allowedAdminIps = this.settings.get("allowedAdminIPList") == null || StringUtils.isBlank((String)((String)this.settings.get("allowedAdminIPList"))) ? new HashSet<String>() : new HashSet<String>(Arrays.asList(((String)this.settings.get("allowedAdminIPList")).split(",")));
        ipMap.put("allowedAdminIPList", allowedAdminIps);
        return ipMap;
    }

    public boolean updateIp(Map map) {
        Set allowedAdminIp = (Set)map.get("allowedAdminIPList");
        this.settings.put("allowedAdminIPList", StringUtils.join((Collection)allowedAdminIp, (String)","));
        this.serialize(this.settings, this.file);
        return true;
    }

    public Map getSandboxMap() {
        HashMap sandboxMap = new HashMap();
        String disabledfunctions = "";
        String disabledTags = "";
        if (this.settings.get("contexts") == null) {
            return sandboxMap;
        }
        ConfigMap contexts = (ConfigMap)this.settings.get("contexts");
        ConfigMap sandboxes = (ConfigMap)contexts.get("/");
        Iterator iterator = sandboxes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String name = (String)entry.getKey();
            List list = (List)entry.getValue();
            HashMap permissionMap = new HashMap();
            this.fillMap(permissionMap, Category.SANDBOX);
            for (Struct st : list) {
                String clazz = (String)st.get("CLASS");
                String action = (String)st.get("ACTION");
                String target = (String)st.get("TARGET");
                if (clazz.equalsIgnoreCase("coldfusion.runtime.FunctionPermission")) {
                    disabledfunctions = target.substring(1);
                    continue;
                }
                if (clazz.equalsIgnoreCase("coldfusion.tagext.GenericTagPermission")) {
                    disabledTags = target.substring(1);
                    continue;
                }
                if (permissionMap.get(clazz) == null) {
                    permissionMap.put(clazz, new HashSet());
                }
                ((Set)permissionMap.get(clazz)).add(StringUtils.isEmpty((String)action) ? target : action + ("java.io.FilePermission".equalsIgnoreCase(clazz) ? ":" : ";") + target);
            }
            if (!StringUtils.isEmpty((String)disabledfunctions)) {
                disabledfunctions = disabledfunctions.substring(1);
            }
            if (!StringUtils.isEmpty((String)disabledTags)) {
                disabledTags = disabledTags.substring(1);
            }
            HashSet disabledFnList = StringUtils.isEmpty((String)disabledfunctions) ? new HashSet() : new HashSet<String>(Arrays.asList(disabledfunctions.split(",")));
            HashSet disabledTagList = StringUtils.isEmpty((String)disabledTags) ? new HashSet() : new HashSet<String>(Arrays.asList(disabledTags.split(",")));
            permissionMap.put("coldfusion.runtime.FunctionPermission", disabledFnList);
            permissionMap.put("coldfusion.tagext.GenericTagPermission", disabledTagList);
            HashSet<String> enabledFns = new HashSet<String>(allFunctions);
            HashSet<String> enabledTags = new HashSet<String>(allTags);
            enabledFns.removeAll(disabledFnList);
            enabledTags.removeAll(disabledTagList);
            if (disabledFnList.contains("*")) {
                enabledFns = new HashSet();
            }
            if (disabledTagList.contains("*")) {
                enabledTags = new HashSet();
            }
            permissionMap.put("enabledFunctions", enabledFns);
            permissionMap.put("enabledTags", enabledTags);
            HashSet<String> disabledRuntimePermissions = new HashSet<String>(allRuntimePerms);
            disabledRuntimePermissions.removeAll((Collection)permissionMap.get("java.lang.RuntimePermission"));
            if (((Set)permissionMap.get("java.lang.RuntimePermission")).contains("*")) {
                disabledRuntimePermissions = new HashSet();
            }
            permissionMap.put("disabledRuntimePermissions", disabledRuntimePermissions);
            HashSet enabledDatasources = CollectionUtils.isEmpty((Collection)((Collection)permissionMap.get("coldfusion.sql.DataSourcePermission"))) ? new HashSet() : new HashSet<String>(Arrays.asList(StringUtils.join((Collection)((Collection)permissionMap.get("coldfusion.sql.DataSourcePermission")), (String)",").split(",")));
            permissionMap.put("coldfusion.sql.DataSourcePermission", enabledDatasources);
            Set<String> allDatasources = new DatasourceSettings(this.selectedPath).getMap().keySet();
            HashSet<String> disabledDatasources = new HashSet<String>(allDatasources);
            if (enabledDatasources.contains("*")) {
                disabledDatasources = new HashSet();
            } else {
                disabledDatasources.removeAll(enabledDatasources);
            }
            permissionMap.put("disabledDatasources", disabledDatasources);
            sandboxMap.put(name, permissionMap);
        }
        return sandboxMap;
    }

    public boolean updateSamlConfig(Map samlConfig) {
        HashMap adminSamlConfig = new HashMap();
        if (samlConfig != null) {
            adminSamlConfig.putAll(samlConfig);
        }
        if (adminSamlConfig.isEmpty() && this.settings.containsKey("SamlConfig")) {
            this.settings.remove("SamlConfig");
        } else if (!adminSamlConfig.isEmpty()) {
            this.settings.put("SamlConfig", adminSamlConfig);
        }
        this.serialize(this.settings, this.file);
        return true;
    }

    public Map getAdminSamlConfigMap() {
        HashMap samlConfig = new HashMap();
        if (this.settings.containsKey("SamlConfig") && this.settings.get("SamlConfig") != null) {
            samlConfig = (HashMap)this.settings.get("SamlConfig");
        }
        return samlConfig;
    }

    private String getSeed() {
        try {
            Map SeedProps = PasswordUtils.loadSeedForMigration(this.selectedPath + File.separator + "lib" + File.separator + "seed.properties");
            return (String)SeedProps.get("seed");
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    public boolean updateLdapConfig(Map ldapConfig) {
        HashMap<String, String> adminLdapConfig = new HashMap<String, String>();
        if (ldapConfig != null) {
            adminLdapConfig.putAll(ldapConfig);
        }
        if (adminLdapConfig.containsKey("credentials")) {
            Map credential = this.processLdapConfigCredentials((String)ldapConfig.get("credentials"));
            adminLdapConfig.put("userbindDN", (String)credential.get("userbindDN"));
            adminLdapConfig.put("password", (String)credential.get("password"));
            adminLdapConfig.remove("credentials");
        }
        if (adminLdapConfig.isEmpty() && this.settings.containsKey("ldapConfiguration")) {
            this.settings.remove("ldapConfiguration");
        } else if (!adminLdapConfig.isEmpty()) {
            this.settings.put("ldapConfiguration", adminLdapConfig);
        }
        this.serialize(this.settings, this.file);
        return true;
    }

    public boolean isLdapConfigPresent() {
        return this.settings.get("ldapConfiguration") != null;
    }

    public Map getAdminLdapConfigMap() {
        HashMap ldapConfig = new HashMap();
        Object credential = "";
        if (this.settings.get("ldapConfiguration") != null) {
            ldapConfig = (HashMap)this.settings.get("ldapConfiguration");
        }
        if (ldapConfig.containsKey("userbindDN")) {
            credential = (String)ldapConfig.get("userbindDN") + ";" + (String)ldapConfig.get("password");
            ldapConfig.put("credentials", credential);
            ldapConfig.remove("userbindDN");
            ldapConfig.remove("password");
        }
        return ldapConfig;
    }

    public Map processLdapConfigCredentials(String credentials) {
        HashMap<String, String> processedCred = new HashMap<String, String>();
        String[] credential = credentials.split(";");
        if (credential.length < 2) {
            MessageHandler.getInstance().showError(Messages.getString("LDAPCONFIG.credentialFormat"));
            return null;
        }
        processedCred.put("userbindDN", credential[0].trim());
        processedCred.put("password", credential[1].trim());
        return processedCred;
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Map getSecurityConfigMap() {
        HashMap<String, Boolean> securityConfigMap = new HashMap<String, Boolean>();
        for (String s : securityConfigSettings) {
            Object val;
            Object object = val = this.settings.containsKey(s) ? this.settings.get(s) : Boolean.valueOf(false);
            if (val instanceof String && !s.equalsIgnoreCase("externalAuth")) {
                val = Boolean.valueOf((String)val);
            }
            if (s.equalsIgnoreCase("externalAuth") && val instanceof Boolean) {
                val = "NONE";
            }
            securityConfigMap.put(s, (Boolean)val);
        }
        return Collections.unmodifiableMap(securityConfigMap);
    }

    public boolean updateSecurityConfigData(Map<String, Object> map) {
        for (String s : securityConfigSettings) {
            if (!map.containsKey(s)) continue;
            Object val = map.get(s);
            if (s.equalsIgnoreCase("rds.security.enabled") || s.equalsIgnoreCase("rds.enabled")) {
                val = String.valueOf(val);
            }
            this.settings.put(s, val);
        }
        Set allowedAdminIp = (Set)map.get("allowedAdminIPList");
        this.settings.put("allowedAdminIPList", StringUtils.join((Collection)allowedAdminIp, (String)","));
        this.serialize(this.settings, this.file);
        return true;
    }

    public boolean updateSandboxEnabledStatus(boolean value) {
        ConfigMap contexts = this.settings != null ? (ConfigMap)this.settings.get("contexts") : new ConfigMap();
        ConfigMap sandboxes = contexts != null ? (ConfigMap)contexts.get("/") : new ConfigMap();
        Object cfide = "";
        Object webinf = "";
        if (Util.isJEEDeployment(this.selectedPath)) {
            cfide = new File(new File(this.selectedPath).getParent()).getParent() + File.separator + "CFIDE" + File.separator;
            webinf = new File(this.selectedPath).getParent() + File.separator;
        } else {
            cfide = this.selectedPath + File.separator + "wwwroot" + File.separator + "CFIDE" + File.separator;
            webinf = this.selectedPath + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator;
        }
        if (sandboxes.get(cfide) == null) {
            sandboxes.put(cfide, SecurityService.generateSandboxAdminMap());
        }
        if (sandboxes.get(webinf) == null) {
            sandboxes.put(webinf, SecurityService.generateSandboxAdminMap());
        }
        contexts.put("/", sandboxes);
        this.settings.put("contexts", contexts);
        boolean oldSandboxStatus = (Boolean)this.settings.get("sbs.security.enabled");
        if (oldSandboxStatus != value && !Util.isJEEDeployment(this.selectedPath)) {
            JvmSettings jvmSettings = new JvmSettings(this.selectedPath);
            if (value) {
                HashMap<String, CallSite> map = new HashMap<String, CallSite>();
                map.put("jvmArgs", (CallSite)((Object)("-Djava.security.manager -Djava.security.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "coldfusion.policy -Djava.security.auth.policy=" + this.selectedPath + File.separator + "lib" + File.separator + "neo_jaas.policy")));
                jvmSettings.addService(map);
            } else {
                jvmSettings.deleteSandboxArgs();
            }
        }
        this.settings.put("sbs.security.enabled", (Object)value);
        this.serialize(this.settings, this.file);
        return true;
    }

    public String getSandboxEnabledStatus() {
        return String.valueOf(this.settings.get("sbs.security.enabled"));
    }

    public boolean updateSandboxData(Map map, String selectedPath, boolean isAdminReservedPath) {
        ConfigMap contexts = (ConfigMap)this.settings.get("contexts");
        ConfigMap sandboxes = (ConfigMap)contexts.get("/");
        ConfigMap rootMap = new ConfigMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String name = (String)entry.getKey();
            HashMap sandboxMap = (HashMap)entry.getValue();
            this.fillMap(sandboxMap, Category.SANDBOX);
            Vector sandboxList = this.mapToVector(sandboxMap);
            rootMap.put(name, sandboxList);
        }
        contexts.put("/", rootMap);
        this.settings.put("contexts", contexts);
        this.serialize(this.settings, this.file);
        return true;
    }

    private Vector mapToVector(Object value) {
        Vector<Struct> sandboxList = new Vector<Struct>();
        Map map = (Map)value;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Set set;
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if ("enabledFunctions".equalsIgnoreCase(key) || "enabledTags".equalsIgnoreCase(key) || "disabledDatasources".equalsIgnoreCase(key) || "disabledRuntimePermissions".equalsIgnoreCase(key)) continue;
            if ("coldfusion.runtime.FunctionPermission".equalsIgnoreCase(key) || "coldfusion.tagext.GenericTagPermission".equalsIgnoreCase(key)) {
                Object target = CollectionUtils.isEmpty((Collection)((Set)val)) ? "*" : "*-" + StringUtils.join((Collection)((Set)val), (String)",").toLowerCase();
                sandboxList.add(this.getSandboxStruct((String)target, "", key));
                continue;
            }
            if ("coldfusion.sql.DataSourcePermission".equalsIgnoreCase(key)) {
                for (Object v : (Set)val) {
                    if (!StringUtils.isNotBlank((String)v)) continue;
                    sandboxList.add(this.getSandboxStruct((String)v, "", key));
                }
                continue;
            }
            if ("java.io.FilePermission".equalsIgnoreCase(key)) {
                Object v;
                set = (Set)val;
                v = set.iterator();
                while (v.hasNext()) {
                    String v2 = (String)v.next();
                    sandboxList.add(this.getFileSandboxStruct(v2));
                }
                continue;
            }
            if (val instanceof String) {
                String[] ar = ((String)val).split(";");
                String target = ar.length == 1 ? ar[0] : ar[1];
                String action = ar.length == 1 ? "" : ar[0];
                sandboxList.add(this.getSandboxStruct(target, action, key));
                continue;
            }
            if (!(val instanceof Set)) continue;
            set = (Set)val;
            for (String v2 : set) {
                String[] ar = v2.split(";");
                String target = ar.length == 1 ? ar[0] : ar[1];
                String action = ar.length == 1 ? "" : ar[0];
                sandboxList.add(this.getSandboxStruct(target, action, key));
            }
        }
        return sandboxList;
    }

    public boolean updateUserData(Map map) {
        FastHashtable authorizedUsers = new FastHashtable();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            HashMap<String, Array> userValueMap = new HashMap<String, Array>();
            String name = (String)entry.getKey();
            HashMap userMap = (HashMap)entry.getValue();
            this.fillMap(userMap, Category.USER);
            if (!userMap.containsKey("description")) {
                userMap.put("description", "");
            }
            for (Map.Entry userEntry : userMap.entrySet()) {
                Set list;
                Array array;
                Struct sandboxStruct;
                Array array2;
                Set list2;
                String key = (String)userEntry.getKey();
                Object val = userEntry.getValue();
                if ("sandboxes".equalsIgnoreCase(key)) {
                    list2 = (Set)val;
                    array2 = userValueMap.get("sandboxes") == null ? new Array() : (Array)userValueMap.get("sandboxes");
                    for (String v : list2) {
                        sandboxStruct = this.getFileSandboxStruct(v);
                        array2.add(sandboxStruct);
                    }
                    userValueMap.put("sandboxes", array2);
                    continue;
                }
                if ("datasources".equalsIgnoreCase(key)) {
                    list2 = (Set)val;
                    Array array3 = array2 = userValueMap.get("sandboxes") == null ? new Array() : (Array)userValueMap.get("sandboxes");
                    if (list2.contains("*")) {
                        list2.clear();
                        list2.add("*");
                    }
                    for (String v : list2) {
                        sandboxStruct = this.getSandboxStruct(v, "", "coldfusion.sql.DataSourcePermission");
                        array2.add(sandboxStruct);
                    }
                    userValueMap.put("sandboxes", array2);
                    continue;
                }
                if ("exposedServices".toLowerCase().equalsIgnoreCase(key)) {
                    array = new Array();
                    list = (Set)val;
                    for (String v : list) {
                        array.add(v);
                    }
                    userValueMap.put("exposedServices", array);
                    continue;
                }
                if ("roles".equalsIgnoreCase(key)) {
                    array = new Array();
                    list = (Set)val;
                    if (list.contains("coldfusion.administrator")) {
                        list.add("coldfusion.adminapi");
                    }
                    for (String v : list) {
                        array.add(v);
                    }
                    userValueMap.put("roles", array);
                    continue;
                }
                userValueMap.put(key, (Array)val);
            }
            authorizedUsers.put(name, userValueMap);
        }
        this.settings.put("AuthorizedUsers", authorizedUsers);
        this.serialize(this.settings, this.file);
        return true;
    }

    public Set<String> loadResource(String currentCFHome, String propFilePath) {
        String cfusionJar = currentCFHome + File.separator + "lib" + File.separator + "cfusion.jar";
        if (!new File(cfusionJar).exists()) {
            cfusionJar = currentCFHome + File.separator + ".." + File.separator + "lib" + File.separator + "cfusion.jar";
        }
        try {
            URLClassLoader child = new URLClassLoader(new URL[]{new File(cfusionJar).toURI().toURL()}, this.getClass().getClassLoader());
            InputStream builtInRolesStream = child.getResourceAsStream(propFilePath);
            Properties cfRolesProps = new Properties();
            cfRolesProps.load(builtInRolesStream);
            return Collections.list(cfRolesProps.keys()).stream().map(v -> (String)v).collect(Collectors.toSet());
        }
        catch (IOException e) {
            logger.error("Failed to load built-in properties", (Throwable)e);
            return new HashSet<String>();
        }
    }

    private Struct getFileSandboxStruct(String v) {
        String p = v.substring(0, v.indexOf(":") == -1 ? 0 : v.indexOf(":"));
        String file = v.substring(v.indexOf(":") + 1);
        Struct sandboxStruct = new Struct();
        sandboxStruct.put("TARGET", file.equals("*") ? "<<ALL FILES>>" : file);
        sandboxStruct.put("ACTION", Util.getFilePermissionsValue(p));
        sandboxStruct.put("CLASS", "java.io.FilePermission");
        return sandboxStruct;
    }

    public void setSeed(String seedVal, String oldSeedValue, final String algo, final String selectedPath) throws Exception {
        if (seedVal != null) {
            String digest = SecurityUtils.hash(seedVal, "SHA-256", "", "");
            seedVal = digest.substring(0, 16);
        }
        if (seedVal.equals(oldSeedValue)) {
            return;
        }
        final String finalSeedVal = seedVal;
        final String finalOldSeedValue = oldSeedValue;
        this.seedProperties = new Properties();
        this.seed = finalSeedVal;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityService.this.seedProperties.setProperty("seed", finalSeedVal);
                SecurityService.this.seedProperties.setProperty("algorithm", algo);
                SecurityService.this.storeSeedProperties(selectedPath);
                SecurityService.this.updateEncryptedSettingsWithNewSeed(finalOldSeedValue, finalSeedVal, selectedPath);
                return null;
            }
        });
    }

    private final void storeSeedProperties(String selectedPath) {
        FileOutputStream foutput = null;
        String SEEDFILEPATH = selectedPath + File.separatorChar + "lib" + File.separatorChar + "seed.properties";
        File seedPropertiesFile = new File(SEEDFILEPATH);
        boolean isHidden = seedPropertiesFile.isHidden();
        try {
            if (isHidden) {
                FileUtils.setFileAttributes(seedPropertiesFile, "NORMAL");
            }
            seedPropertiesFile.setExecutable(false, false);
            seedPropertiesFile.setReadable(true, true);
            seedPropertiesFile.setWritable(true, true);
            foutput = new FileOutputStream(seedPropertiesFile);
            this.seedProperties.store(foutput, null);
        }
        catch (Exception ex) {
            throw new CFSetupException(ex);
        }
        finally {
            if (foutput != null) {
                try {
                    foutput.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            FileUtils.setUnixModes(SEEDFILEPATH, 600);
            if (isHidden) {
                FileUtils.setFileAttributes(seedPropertiesFile, "HIDDEN");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEncryptedSettingsWithNewSeed(String oldSeed, String seed, String selectedPath) {
        EntryPoint.isSilent = true;
        Set<Category> settingsWithEnccryptedFields = SettingValidation.getInstance().getCategoriesWithEncryptedFields();
        MessageHandler.getInstance().showInfo(Messages.getString("encryptingWithNewSeed"));
        try {
            for (Category category : settingsWithEnccryptedFields) {
                GenericSetting genericSetting = SettingInstanceProvider.getInstance().getSettingInstanceFromCFHome(selectedPath, category, false);
                Set encryptedFields = Optional.ofNullable(SettingValidation.getInstance().getEncryptedFields(genericSetting.getCategory())).orElse(new HashSet());
                for (String settingKey : encryptedFields) {
                    String currValue = "";
                    if (genericSetting instanceof MultilevelSetting && genericSetting.getCategory() != Category.SOLR) {
                        Map<String, ?> map = genericSetting.getMap();
                        for (String service : map.keySet()) {
                            currValue = genericSetting.getSetting(settingKey, service);
                            if (!StringUtils.isNotBlank((String)currValue) || "null".equalsIgnoreCase(currValue)) continue;
                            genericSetting.setSetting(settingKey, PasswordUtils.reEncryptWithNewSeed(currValue, oldSeed, seed), service);
                        }
                        continue;
                    }
                    currValue = genericSetting.getSetting(settingKey, null);
                    if (!StringUtils.isNotBlank((String)currValue) || "null".equalsIgnoreCase(currValue)) continue;
                    genericSetting.setSetting(settingKey, PasswordUtils.reEncryptWithNewSeed(currValue, oldSeed, seed), null);
                }
            }
            AdminPasswordSettings passwordsSettings = (AdminPasswordSettings)SettingInstanceProvider.getInstance().getSettingInstanceFromCFHome(selectedPath, Category.SECURITY, false);
            passwordsSettings.setSetting("rdspassword", PasswordUtils.decryptPassword(passwordsSettings.getRdspassword(), oldSeed), seed);
            AdminLdapConfigSettings ldapSettings = (AdminLdapConfigSettings)SettingInstanceProvider.getInstance().getSettingInstanceFromCFHome(selectedPath, Category.LDAPCONFIG, false);
            Map credentials = ldapSettings.getCredentials();
            if (credentials != null) {
                String userbindDN = (String)credentials.get("userbindDN");
                String newPassword = PasswordUtils.decryptPassword((String)credentials.get("password"), oldSeed);
                ldapSettings.setSetting("credentials", userbindDN + ";" + newPassword, "");
            }
        }
        catch (Exception exception) {
        }
        finally {
            EntryPoint.isSilent = false;
        }
    }

    private Struct getSandboxStruct(String target, String action, String clazz) {
        Struct sandboxStruct = new Struct();
        sandboxStruct.put("TARGET", target);
        sandboxStruct.put("ACTION", action);
        sandboxStruct.put("CLASS", clazz);
        return sandboxStruct;
    }

    public void fillMap(Map map, Category category) {
        Map<String, ValidationDetails> validationMap = SettingValidation.getInstance().getcategoryValidationMap(category);
        for (Map.Entry<String, ValidationDetails> entry : validationMap.entrySet()) {
            String key = entry.getKey();
            ValidationDetails vd = entry.getValue();
            if (vd.isRestricted() || !vd.isList() || map.containsKey(key)) continue;
            map.put(key, new HashSet());
        }
    }

    private static Vector generateSandboxAdminMap() {
        Vector<Struct> vec = new Vector<Struct>();
        vec.add(new Struct());
        ((Struct)vec.get(0)).put("ACTION", "");
        ((Struct)vec.get(0)).put("CLASS", "java.io.SerializablePermission");
        ((Struct)vec.get(0)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(1)).put("ACTION", "read,write");
        ((Struct)vec.get(1)).put("CLASS", "java.util.PropertyPermission");
        ((Struct)vec.get(1)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(2)).put("ACTION", "");
        ((Struct)vec.get(2)).put("CLASS", "java.net.NetPermission");
        ((Struct)vec.get(2)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(3)).put("ACTION", "");
        ((Struct)vec.get(3)).put("CLASS", "java.sql.SQLPermission");
        ((Struct)vec.get(3)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(4)).put("ACTION", "");
        ((Struct)vec.get(4)).put("CLASS", "java.security.SecurityPermission");
        ((Struct)vec.get(4)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(5)).put("ACTION", "connect,resolve");
        ((Struct)vec.get(5)).put("CLASS", "java.net.SocketPermission");
        ((Struct)vec.get(5)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(6)).put("ACTION", "");
        ((Struct)vec.get(6)).put("CLASS", "java.lang.RuntimePermission");
        ((Struct)vec.get(6)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(7)).put("ACTION", "");
        ((Struct)vec.get(7)).put("CLASS", "coldfusion.sql.DataSourcePermission");
        ((Struct)vec.get(7)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(8)).put("ACTION", "read,write,execute,delete");
        ((Struct)vec.get(8)).put("CLASS", "java.io.FilePermission");
        ((Struct)vec.get(8)).put("TARGET", "<<ALL FILES>>");
        vec.add(new Struct());
        ((Struct)vec.get(9)).put("ACTION", "read,write,execute,delete");
        ((Struct)vec.get(9)).put("CLASS", "coldfusion.vfs.VFilePermission");
        ((Struct)vec.get(9)).put("TARGET", "ram:///-");
        vec.add(new Struct());
        ((Struct)vec.get(10)).put("ACTION", "read,write,execute,delete");
        ((Struct)vec.get(10)).put("CLASS", "coldfusion.vfs.VFilePermission");
        ((Struct)vec.get(10)).put("TARGET", "ram:///");
        vec.add(new Struct());
        ((Struct)vec.get(11)).put("ACTION", "");
        ((Struct)vec.get(11)).put("CLASS", "coldfusion.runtime.FunctionPermission");
        ((Struct)vec.get(11)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(12)).put("ACTION", "");
        ((Struct)vec.get(12)).put("CLASS", "org.osgi.framework.AdminPermission");
        ((Struct)vec.get(12)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(13)).put("ACTION", "get,register");
        ((Struct)vec.get(13)).put("CLASS", "org.osgi.framework.ServicePermission");
        ((Struct)vec.get(13)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(14)).put("ACTION", "");
        ((Struct)vec.get(14)).put("CLASS", "java.lang.reflect.ReflectPermission");
        ((Struct)vec.get(14)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(15)).put("ACTION", "");
        ((Struct)vec.get(15)).put("CLASS", "coldfusion.tagext.GenericTagPermission");
        ((Struct)vec.get(15)).put("TARGET", "*");
        vec.add(new Struct());
        ((Struct)vec.get(16)).put("ACTION", "");
        ((Struct)vec.get(16)).put("CLASS", "coldfusion.tagext.lang.ModulePermission");
        ((Struct)vec.get(16)).put("TARGET", "*");
        return vec;
    }

    private Struct getRuntimePermissionStruct(String target, String action) {
        if (target == null) {
            target = "*";
        }
        if (action == null) {
            action = "";
        }
        Struct struct = new Struct();
        struct.put("CLASS", "java.lang.RuntimePermission");
        struct.put("TARGET", target);
        struct.put("ACTION", action);
        return struct;
    }

    public static boolean isRestrictedPath(String path) {
        return "ram:///-".equalsIgnoreCase(path) || "ram:///-".equalsIgnoreCase(path) || "ALL FILES".equalsIgnoreCase(path);
    }
}

