/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceRuntimeException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrService
extends ServiceBase
implements Observer {
    private ConfigMap settings = null;
    private Vector<Map> languages = null;
    private String seed;
    private File file;
    private static final Logger logger = LoggerFactory.getLogger(SolrService.class);

    public SolrService(File solrConfigXmlFile) {
        this.file = solrConfigXmlFile;
        try {
            this.load();
        }
        catch (ServiceException e) {
            throw new CFSetupException("Error while loading SolrSetting, ", e);
        }
    }

    public Map getMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.file);
            this.settings.init(this, "configuration");
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    public void removeLanguage(String languageName) {
        this.languages = new Vector<Map>(this.languages);
        Map toBeRemoved = null;
        for (int i = 0; i < this.languages.size(); ++i) {
            if (!languageName.equals((String)this.languages.get(i).get("name"))) continue;
            toBeRemoved = this.languages.get(i);
            break;
        }
        this.languages.remove(toBeRemoved);
        this.settings.put("languages", this.languages);
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.file);
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public boolean storeModifiedMap(Map map) {
        this.settings.clear();
        this.settings.putAll(map);
        try {
            this.store();
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorFileWrite", Category.SOLR.getFileName()));
            logger.error(Messages.getString("errorFileWrite", Category.SOLR.getFileName()), (Throwable)e);
            return false;
        }
        return true;
    }

    public void checkSolrHomePath(String solrhost, String solrHome) {
        if ("localhost".equals(solrhost) || "127.0.0.1".equals(solrhost)) {
            File configpath;
            int correctfiles = 0;
            File file = new File(solrHome);
            if (file.exists() && file.isDirectory() && (configpath = new File(file + "/template/conf")).exists() && configpath.isDirectory()) {
                for (String innerfile : configpath.list()) {
                    if (!innerfile.equalsIgnoreCase("schema.xml") && !innerfile.equalsIgnoreCase("solrconfig.xml")) continue;
                    ++correctfiles;
                }
            }
            if (correctfiles != 2) {
                MessageHandler.getInstance().showError(Messages.getString("invalidJettyPath", ProposedSetting.getInstance().getUserDefinedValue(Category.SOLR, "solrhome")));
                throw new ServiceRuntimeException(Messages.getString("missingFile", ProposedSetting.getInstance().getUserDefinedValue(Category.SOLR, "solrhome")));
            }
        }
    }
}

