/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.service;

import coldfusion.ServiceBase;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ServiceException;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import java.io.File;
import java.util.Map;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketService
extends ServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketService.class);
    private static final Object[] noArgs = new Object[0];
    private File configFile;
    private final int DEFAULT_PORT = 8575;
    private static final int DEFAULT_FLASH_PORT = 1243;
    private final int DEFAULT_MULTICAST_PORT = 45566;
    private final int DEFAULT_SSL_PORT = 8543;
    private final int DEFAULT_MAX_FRAME_SIZE = 1024;
    private final int DEFAULT_SOCKET_TIME_OUT = 300;
    private final String FLASH_POLICY_PORT = "flashPolicyPort";
    private final String CLUSTERED = "clustered";
    private final String START_LISTENER_NORMAL_PORT = "startListenerOnNormalPort";
    private final String SSL_ENABLED = "sslEnabled";
    private final String SSL_PORT = "sslport";
    private final String KEY_STORE_LOCATION = "keystoreLocation";
    private final String KEY_STORE_PASSWORD = "keystorePassword";
    protected ConfigMap websocket_settings;
    private int port;
    private int multicastPort;
    private int flashPort;
    private int socketTimeOut;
    private int maxFrameSize;
    private boolean flashFallBackEnabled = true;
    private boolean loggingEnabled = false;
    private boolean isEnabled = true;
    private boolean clustered = false;
    private boolean normalPortListenerEnabled = true;
    private boolean isEnterpriseEdition = true;
    private boolean sslEnabled = false;
    private int sslPort = 8443;
    private String keyStoreLocation = null;
    private String keyStorePassword = null;
    private String encryptedKeyStorePassword = null;
    private String seed;
    private final String START_LISTENER_PROXY_CONNECT_PORT = "enableWebsocketOverProxyPort";
    private boolean isProxyEnabled;
    private static final String ENABLE_RMI = "coldfusion.rmi.enable";
    private static boolean openRMIPort = true;

    public WebSocketService(File configFile) {
        this.configFile = configFile;
        this.setEnableWatch(true);
        this.setWatchFile(configFile);
        try {
            this.load();
        }
        catch (ServiceException e) {
            logger.error("Error initializing WebSocket Service", (Throwable)e);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.websocket_settings, this.configFile);
    }

    @Override
    public void load() throws ServiceException {
        try {
            String multicastPortvalue;
            this.websocket_settings = (ConfigMap)this.deserialize(this.configFile);
            this.websocket_settings.init(this, "configuration");
            this.websocket_settings.setConfigMapListener(this);
            Boolean normalportEnalbed = (Boolean)this.websocket_settings.get("startListenerOnNormalPort");
            if (normalportEnalbed != null) {
                this.normalPortListenerEnabled = normalportEnalbed;
            } else {
                this.websocket_settings.put("NORMAL_PORT", new Boolean(true));
            }
            String portvalue = (String)this.websocket_settings.get("port");
            if (portvalue != null) {
                this.port = Integer.parseInt(portvalue);
            } else {
                this.websocket_settings.put("port", "8575");
            }
            String flashPortvalue = (String)this.websocket_settings.get("flashPolicyPort");
            if (flashPortvalue != null) {
                this.flashPort = Integer.parseInt(flashPortvalue);
            } else {
                this.websocket_settings.put("flashPolicyPort", "1243");
            }
            Number timeout = (Number)this.websocket_settings.get("socketTimeout");
            if (timeout != null) {
                this.socketTimeOut = timeout.intValue();
            } else {
                this.websocket_settings.put("socketTimeout", new Integer(300));
            }
            Number frameSize = (Number)this.websocket_settings.get("maxFrameSize");
            if (frameSize != null) {
                this.maxFrameSize = frameSize.intValue();
            } else {
                this.websocket_settings.put("maxFrameSize", new Integer(1024));
            }
            Boolean flashFallback = (Boolean)this.websocket_settings.get("flashFallBack");
            if (flashFallback != null) {
                this.flashFallBackEnabled = flashFallback;
            } else {
                this.websocket_settings.put("flashFallBack", new Boolean(true));
            }
            Boolean websocketStart = (Boolean)this.websocket_settings.get("startWebSocketService");
            if (websocketStart != null) {
                this.isEnabled = websocketStart;
            } else {
                this.websocket_settings.put("startWebSocketService", new Boolean(true));
            }
            String logLevel = (String)this.websocket_settings.get("logging");
            if (logLevel != null && logLevel.equalsIgnoreCase("debug")) {
                this.loggingEnabled = true;
            }
            if ((multicastPortvalue = (String)this.websocket_settings.get("multicastPort")) != null) {
                this.multicastPort = Integer.parseInt(multicastPortvalue);
            } else {
                this.websocket_settings.put("multicastPort", "45566");
            }
            Boolean clusteredVal = (Boolean)this.websocket_settings.get("clustered");
            if (clusteredVal != null) {
                this.clustered = clusteredVal;
            } else {
                this.websocket_settings.put("clustered", new Boolean(false));
            }
            Boolean sslEnableStr = (Boolean)this.websocket_settings.get("sslEnabled");
            if (sslEnableStr != null) {
                this.sslEnabled = sslEnableStr;
            } else {
                this.websocket_settings.put("sslEnabled", new Boolean(false));
            }
            String sslPortvalue = (String)this.websocket_settings.get("sslport");
            if (sslPortvalue != null) {
                this.sslPort = Integer.parseInt(sslPortvalue);
            } else {
                this.websocket_settings.put("sslport", "8543");
            }
            String keyStoreLocStr = (String)this.websocket_settings.get("keystoreLocation");
            if (keyStoreLocStr != null) {
                this.keyStoreLocation = keyStoreLocStr;
            } else {
                this.websocket_settings.put("keystoreLocation", "");
            }
            String keyStorePasswordStr = (String)this.websocket_settings.get("keystorePassword");
            if (keyStorePasswordStr != null) {
                this.encryptedKeyStorePassword = keyStorePasswordStr;
                this.keyStorePassword = this.decryptPassword(keyStorePasswordStr);
            } else {
                this.websocket_settings.put("keystorePassword", "");
            }
            Boolean wsProxyEnabled = (Boolean)this.websocket_settings.get("enableWebsocketOverProxyPort");
            this.isProxyEnabled = wsProxyEnabled != null ? wsProxyEnabled : true;
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    public boolean isNormalPortListenerEnabled() {
        return this.normalPortListenerEnabled;
    }

    public void setNormalPortListenerEnabled(boolean normalPortListenerEnabled) {
        this.normalPortListenerEnabled = normalPortListenerEnabled;
        if (normalPortListenerEnabled) {
            this.websocket_settings.put("startListenerOnNormalPort", new Boolean(true));
        } else {
            this.websocket_settings.put("startListenerOnNormalPort", new Boolean(false));
        }
    }

    public boolean isEnterpriseClusterEnabled() {
        return this.clustered && this.isEnterpriseEdition;
    }

    public void setWebSocketServiceEnabled(boolean enableWebSocket) {
        if (enableWebSocket) {
            this.websocket_settings.put("startWebSocketService", new Boolean(true));
        } else {
            this.websocket_settings.put("startWebSocketService", new Boolean(false));
        }
        this.isEnabled = enableWebSocket;
    }

    public int getPort() {
        return this.port;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public int getFlashPolicyPort() {
        return this.flashPort;
    }

    public int getSocketTimeOut() {
        return this.socketTimeOut;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setFlashPolicyPort(int flashPort) {
        this.flashPort = flashPort;
        this.websocket_settings.put("flashPolicyPort", "" + flashPort);
    }

    public void setPort(int port) {
        this.port = port;
        this.websocket_settings.put("port", "" + port);
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
        this.websocket_settings.put("multicastPort", "" + multicastPort);
    }

    public boolean isFlashFallBackEnabled() {
        return this.flashFallBackEnabled;
    }

    public void setFlashFallBackEnabled(boolean flashFallBack) {
        if (flashFallBack) {
            this.websocket_settings.put("flashFallBack", new Boolean(true));
        } else {
            this.websocket_settings.put("flashFallBack", new Boolean(false));
        }
        this.flashFallBackEnabled = flashFallBack;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
        this.websocket_settings.put("socketTimeout", new Integer(socketTimeOut));
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        this.websocket_settings.put("maxFrameSize", new Integer(maxFrameSize));
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.websocket_settings.put("sslEnabled", new Boolean(sslEnabled));
        this.sslEnabled = sslEnabled;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public void setSSLPort(int sslPort) {
        this.websocket_settings.put("sslport", "" + sslPort);
        this.sslPort = sslPort;
    }

    public String getKeyStorePath() {
        return this.keyStoreLocation;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.websocket_settings.put("keystoreLocation", keyStorePath);
        this.keyStoreLocation = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public boolean isProxyEnabled() {
        return this.isProxyEnabled;
    }

    public void setProxyEnabled(boolean proxyEnabled) {
        this.isProxyEnabled = proxyEnabled;
        this.websocket_settings.put("enableWebsocketOverProxyPort", (Object)proxyEnabled);
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(String loggingEnabled) {
        this.websocket_settings.put("logging", loggingEnabled);
        if (loggingEnabled != null && loggingEnabled.equalsIgnoreCase("debug")) {
            this.loggingEnabled = true;
        }
    }

    public void setKeyStorePassword(String password) {
        this.keyStorePassword = password;
        String encryptedPassword = this.encryptPassword(password);
        this.setEncryptedKeyStorePassword(encryptedPassword);
    }

    public void setEncryptedKeyStorePassword(String password) {
        this.websocket_settings.put("keystorePassword", password);
    }

    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    private void reEncryptPassword(String oldSeed) {
        if (oldSeed.equalsIgnoreCase(this.seed)) {
            return;
        }
        String oldKeyStorePassword = this.encryptedKeyStorePassword;
        if (oldKeyStorePassword != null && oldKeyStorePassword.length() > 0) {
            try {
                this.encryptedKeyStorePassword = PasswordUtils.reEncryptWithNewSeed(oldKeyStorePassword, oldSeed, this.seed);
                this.setEncryptedKeyStorePassword(this.encryptedKeyStorePassword);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String encryptPassword(String password) {
        return PasswordUtils.encryptPassword(password, this.seed);
    }

    private String decryptPassword(String password) {
        return PasswordUtils.decryptPassword(password, this.seed);
    }

    public void reEncryptPasswordForMigration(String password, String oldSeed, String oldAlgoValue, int majorVersion, int minorVersion) {
        if (password != null) {
            try {
                this.encryptedKeyStorePassword = password = PasswordUtils.reEncryptWithNewSeed(password, oldSeed, this.seed, oldAlgoValue, majorVersion, minorVersion);
                this.setEncryptedKeyStorePassword(password);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean storeModifiedMap(Map<String, Object> websocketMap) {
        this.websocket_settings.clear();
        this.websocket_settings.putAll(websocketMap);
        try {
            this.store();
        }
        catch (ServiceException e) {
            MessageHandler.getInstance().showError(Messages.getString("errorFileWrite", Category.WEBSERVICE.getFileName()));
            logger.error("Exception while storing websocket", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isInstanceOfwebSocketService(Object obj) {
        return obj != null && obj instanceof WebSocketService;
    }

    public ConfigMap getWebsocketSettings() {
        return this.websocket_settings;
    }

    static {
        String openRMIPortString = System.getProperty(ENABLE_RMI);
        if (openRMIPortString != null) {
            openRMIPort = Boolean.getBoolean(ENABLE_RMI);
        }
    }

    public static class ChannelInitializationException
    extends ApplicationException {
        public String mChannelName;
        public String mlistenerCFC;

        public ChannelInitializationException(Throwable th, String channelName, String listenerCFC) {
            super(th);
            this.mChannelName = channelName;
            this.mlistenerCFC = listenerCFC;
        }
    }
}

