/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import coldfusion.security.SecurityUtils;
import coldfusion.server.ConfigMap;
import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.PasswordUtils;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.MultiConfigurationBase;
import com.adobe.cfsetup.base.MultilevelSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.settings.ClientVariableSettings;
import com.adobe.cfsetup.settings.DebugSettings;
import com.adobe.cfsetup.settings.RuntimeSettings;
import com.adobe.cfsetup.settings.service.SecureProfileService;
import com.adobe.cfsetup.settings.service.SecurityService;
import com.adobe.cfsetup.settings.simple.MetricSettings;
import com.adobe.cfsetup.settings.simple.WebsocketSettings;
import com.adobe.cfsetup.validation.SettingValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPasswordSettings
extends MultiConfigurationBase
implements MultilevelSetting {
    private static final Logger logger = LoggerFactory.getLogger(AdminPasswordSettings.class);
    private static final String ADMIN = "adminpassword";
    private static final String ENCRYPTED = "encrypted";
    private static final String PASSWORD = "password";
    public static final String RDSPASSWORD = "rdspassword";
    public static final String ALGORITHM = "algorithm";
    private String adminPasswordFilePath;
    private static final String ADMIN_PASSWORD_PROPERTIES = "password.properties";
    private static final String ADMIN_USERID_ROOT_SALT = "admin.userid.root.salt";
    private Properties properties;
    private final SecurityService securityService;
    private File securityFile = new File(this.selectedPath + File.separator + "lib" + File.separator + Category.SECURITY.getFileName());
    private String seed;
    private final int SEED_LENGTH_MIN = 8;
    private Map<String, Object> securityConfigMap;

    public AdminPasswordSettings(String instancePath) {
        super(instancePath);
        this.adminPasswordFilePath = this.selectedPath + File.separator + "lib" + File.separator + ADMIN_PASSWORD_PROPERTIES;
        this.properties = new Properties();
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(this.adminPasswordFilePath)));){
            this.properties.load(reader);
        }
        catch (IOException e) {
            logger.error("unable to read properties file from :" + this.adminPasswordFilePath);
        }
        this.securityService = new SecurityService(this.securityFile, this.selectedPath);
        this.seed = this.getSeed();
        this.populateMap();
    }

    @Override
    public Map<String, Object> getMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.securityConfigMap.forEach(map::put);
        return map;
    }

    @Override
    public void populateMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        map.putAll(this.securityService.getSecurityConfigMap());
        boolean adminSecurityEnabled = (Boolean)map.get("admin.security.enabled");
        boolean adminUserIdRequired = (Boolean)map.get("admin.userid.required");
        map.put("adminAuthType", this.getType(adminSecurityEnabled, adminUserIdRequired));
        map.remove("admin.security.enabled");
        map.remove("admin.userid.required");
        boolean rdsSecurityEnabled = (Boolean)map.get("rds.security.enabled");
        boolean rdsUserIdRequired = (Boolean)map.get("rds.security.usesinglerdspassword");
        map.put("rdsAuthType", this.getType(rdsSecurityEnabled, !rdsUserIdRequired));
        map.remove("rds.security.enabled");
        map.remove("rds.security.usesinglerdspassword");
        map.putAll(this.securityService.getIpMap());
        this.securityConfigMap = map;
    }

    @Override
    public String getSetting(String name, String service) {
        if (this.securityConfigMap.containsKey(name)) {
            Object object = this.securityConfigMap.get(name);
            if (object instanceof Set) {
                return StringUtils.join(new TreeSet((Set)object), (String)",");
            }
            return String.valueOf(object);
        }
        throw new CFSetupException(Messages.getString("operationNotSupported2", ProposedSetting.getInstance().getUserDefinedValue(Category.SECURITY, name)));
    }

    public String getSetting(String name, String service, String alias) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean setSetting(String name, Object value, String service) {
        block36: {
            block37: {
                settingValue = String.valueOf(value);
                if ("seed".equalsIgnoreCase(name)) {
                    if (settingValue.length() < 8) {
                        MessageHandler.getInstance().showError(Messages.getString("seedLengthInvalid", new String[]{ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "seed"), String.valueOf(8)}));
                        return false;
                    }
                    try {
                        SeedProps = PasswordUtils.loadSeedForMigration(this.selectedPath + File.separator + "lib" + File.separator + "seed.properties");
                        this.securityService.setSeed(settingValue, (String)SeedProps.get("seed"), (String)SeedProps.get("algorithm"), this.selectedPath);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if ("adminpassword".equalsIgnoreCase(name) || "rdspassword".equalsIgnoreCase(name)) {
                    block35: {
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)settingValue)) {
                            AdminPasswordSettings.logger.error("password can't be empty");
                            MessageHandler.getInstance().showError(Messages.getString("blankPassword"));
                            return false;
                        }
                        if (settingValue.contains("\\")) {
                            settingValue = settingValue.replace("\\", "\\\\");
                        }
                        writer = new BufferedWriter(new FileWriter(new File(this.adminPasswordFilePath)));
                        v0 = name = "adminpassword".equalsIgnoreCase(name) != false ? "password" : "rdspassword";
                        if (Boolean.valueOf(this.properties.getProperty("encrypted")).booleanValue()) {
                            settingValue = this.encrypt(settingValue, name);
                        }
                        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)settingValue)) break block35;
                        var6_10 = false;
                        writer.close();
                        return var6_10;
                    }
                    try {
                        this.properties.setProperty(name, settingValue);
                        this.properties.store(writer, "");
                        break block36;
                        {
                            catch (Throwable var6_11) {
                                throw var6_11;
                            }
                        }
                        finally {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        AdminPasswordSettings.logger.error("Error in file write" + e);
                        return false;
                    }
                }
                map = this.getMap();
                if (value instanceof List) {
                    value = new HashSet<E>((List)value);
                }
                if (name.equalsIgnoreCase("adminAuthType")) {
                    v = (String)value;
                    this.updateMapForAdminAuthType(v, map);
                    map.put("adminAuthType", v);
                } else if (name.equalsIgnoreCase("rdsAuthType")) {
                    v = (String)value;
                    this.updateMapForRdsAuthType(v, map);
                } else {
                    map.put(name, value);
                }
                if ("secureprofile.enabled".equalsIgnoreCase(name)) {
                    secureProfileService = new SecureProfileService(this.selectedPath + File.separator + "lib");
                    secureProfileMap = secureProfileService.getMap();
                    prevValue = (Boolean)this.securityConfigMap.get("secureprofile.enabled");
                    if (prevValue != (newValue = ((Boolean)value).booleanValue())) {
                        this.updateValuesForSecureProfile((ConfigMap)secureProfileMap.get("neometric"), new MetricSettings(this.selectedPath), newValue);
                        this.updateValuesForSecureProfile((ConfigMap)secureProfileMap.get("neowebsocket"), new WebsocketSettings(this.selectedPath), newValue);
                        this.updateValuesForSecureProfile((ConfigMap)secureProfileMap.get("neodebug"), new DebugSettings(this.selectedPath), newValue);
                        this.updateValuesForSecureProfile((ConfigMap)secureProfileMap.get("neoruntime"), new RuntimeSettings(this.selectedPath), newValue);
                        this.updateValuesForSecureProfile((ConfigMap)secureProfileMap.get("neoclientstore"), new ClientVariableSettings(this.selectedPath), newValue);
                        this.updateValuesOfDriver((ConfigMap)secureProfileMap.get("neodriver"), secureProfileService, newValue);
                        this.updateValuesOfSecurity((ConfigMap)secureProfileMap.get("neosecurity"), map, newValue);
                    }
                    secureProfileService.storeModifiedMap(secureProfileMap);
                }
                if (!"externalAuth".equalsIgnoreCase(name)) break block37;
                var7_14 = adminAuthType = (String)this.securityConfigMap.get("adminAuthType");
                var8_15 = -1;
                switch (var7_14.hashCode()) {
                    case 1580633188: {
                        if (!var7_14.equals("MULTIUSER")) break;
                        var8_15 = 0;
                        break;
                    }
                    case 1399715859: {
                        if (!var7_14.equals("SINGLEUSER")) break;
                        var8_15 = 1;
                        break;
                    }
                    case 2402104: {
                        if (!var7_14.equals("NONE")) break;
                        var8_15 = 2;
                    }
                }
                switch (var8_15) {
                    case 0: {
                        if (!"SAML".equalsIgnoreCase(settingValue)) ** GOTO lbl95
                        samlConfig = this.securityService.getAdminSamlConfigMap();
                        if (samlConfig == null || samlConfig.isEmpty()) {
                            MessageHandler.getInstance().showError(Messages.getString("requiredCategoryValues", new String[]{"samlConfig"}));
                            return false;
                        }
                        ** GOTO lbl98
lbl95:
                        // 1 sources

                        if ("LDAP".equalsIgnoreCase(settingValue) && !this.securityService.isLdapConfigPresent()) {
                            MessageHandler.getInstance().showError(Messages.getString("requiredCategoryValues", new String[]{"ldapConfig"}));
                            return false;
                        }
                    }
lbl98:
                    // 4 sources

                    case 1: 
                    case 2: {
                        if (!"SAML".equalsIgnoreCase(settingValue) && !"LDAP".equalsIgnoreCase(settingValue)) break;
                        MessageHandler.getInstance().showError(Messages.getString("invalidAuthType"));
                        return false;
                    }
                }
            }
            this.securityService.updateSecurityConfigData(map);
            map.remove("admin.userid.required");
            map.remove("admin.security.enabled");
            map.remove("rds.security.usesinglerdspassword");
            map.remove("rds.security.enabled");
            this.securityConfigMap = map;
            return true;
        }
        return true;
    }

    public String getRdspassword() {
        return this.properties.getProperty(RDSPASSWORD);
    }

    @Override
    public File getXMLFileObject() {
        return this.securityFile;
    }

    @Override
    public Category getCategory() {
        return Category.SECURITY;
    }

    private String encrypt(String value, String name) {
        if (PASSWORD.equals(name)) {
            Map map = this.securityService.getMap();
            String rootSalt = (String)map.get(ADMIN_USERID_ROOT_SALT);
            try {
                value = SecurityUtils.hash(SecurityUtils.hash(value, "SHA-1", "", ""), "SHA-256", "", rootSalt);
            }
            catch (IOException e) {
                MessageHandler.getInstance().showError(Messages.getString("errorEncryption"));
                throw new CFSetupException(Messages.getString("errorEncryption"));
            }
        } else if (RDSPASSWORD.equals(name)) {
            value = PasswordUtils.encryptPassword(value, this.getSeed());
        }
        return value;
    }

    @Override
    public boolean deleteService(String serviceName) {
        String service = ProposedSetting.getInstance().getActualSetting(Category.SECURITY, serviceName);
        if (!service.equalsIgnoreCase("allowedAdminIPList")) {
            throw new CFSetupException(Messages.getString("operationNotSupported1"));
        }
        Map<String, Object> map = this.getMap();
        if (service.equalsIgnoreCase("allowedAdminIPList")) {
            service = "allowedAdminIPList";
        }
        if (CollectionUtils.isEmpty((Collection)((Set)map.get(service)))) {
            MessageHandler.getInstance().showError(Messages.getString("IP.empty", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), service)));
            return false;
        }
        map.put(service, new HashSet());
        this.securityService.updateIp(map);
        this.securityConfigMap = map;
        return true;
    }

    @Override
    public boolean deleteService(Map<String, List> val, String service) {
        Map<String, List> keyValueMap = val;
        if (MapUtils.isEmpty(keyValueMap)) {
            return this.deleteService(service);
        }
        if (keyValueMap.keySet().stream().filter(k -> !k.equalsIgnoreCase("allowedAdminIPList")).findFirst().isPresent()) {
            throw new CFSetupException(Messages.getString("operationNotSupported1"));
        }
        Map<String, Object> map = this.getMap();
        if (keyValueMap.containsKey("allowedAdminIPList")) {
            HashSet<String> list = new HashSet<String>(keyValueMap.get("allowedAdminIPList"));
            if (this.handleIfNotPresent(list, (Set)map.get("allowedAdminIPList"), "allowedAdminIPList")) {
                return false;
            }
            ((Set)map.get("allowedAdminIPList")).removeAll(list);
        }
        this.securityService.updateIp(map);
        this.securityConfigMap = map;
        return true;
    }

    @Override
    public boolean addService(Object val) {
        Map keyValueMap = (Map)val;
        if (keyValueMap.keySet().stream().filter(k -> !k.equalsIgnoreCase("allowedAdminIPList")).findFirst().isPresent()) {
            throw new CFSetupException(Messages.getString("operationNotSupported1"));
        }
        Map<String, Object> map = this.getMap();
        if (keyValueMap.containsKey("allowedAdminIPList")) {
            HashSet<String> list = new HashSet<String>((List)keyValueMap.get("allowedAdminIPList"));
            if (this.handleIfAlreadyPresent(list, (Set)map.get("allowedAdminIPList"), "allowedAdminIPList")) {
                return false;
            }
            ((Set)map.get("allowedAdminIPList")).addAll(list);
        }
        this.securityService.updateIp(map);
        this.securityConfigMap = map;
        return true;
    }

    @Override
    public boolean validate(Map<String, Object> keyValueMap, String service) {
        ArrayList<String> invalidIps = new ArrayList<String>();
        ArrayList ips = new ArrayList();
        if (keyValueMap.containsKey("allowedAdminIPList")) {
            ips.addAll((List)keyValueMap.get("allowedAdminIPList"));
        }
        for (String ip : ips) {
            if (this.getExpandedIPNValidate(ip)) continue;
            invalidIps.add(ip);
        }
        if (invalidIps.size() > 0) {
            MessageHandler.getInstance().showError(Messages.getString("invalidIp"));
            MessageHandler.getInstance().showInfo(StringUtils.join(invalidIps, (String)", "));
        }
        return invalidIps.size() == 0;
    }

    private boolean getExpandedIPNValidate(String ip) {
        boolean validIP = true;
        boolean isIPv6 = false;
        String[] IParr = null;
        try {
            if (ip.indexOf(42) != -1 || ip.indexOf(45) != -1) {
                if (ip.indexOf(58) != -1) {
                    isIPv6 = true;
                }
                if (isIPv6) {
                    if (!Pattern.matches("[0-9:\\-\\*]*", ip)) {
                        validIP = false;
                    } else {
                        IParr = ip.split(":");
                        if (IParr.length != 8) {
                            validIP = false;
                        }
                    }
                } else if (!Pattern.matches("[0-9\\.\\-\\*]*", ip)) {
                    validIP = false;
                } else {
                    IParr = ip.split("\\.");
                    if (IParr.length != 4) {
                        validIP = false;
                    }
                }
                if (validIP && !this.scanIndividualIPTokenValidity(IParr)) {
                    validIP = false;
                }
            } else {
                InetAddress addr = InetAddress.getByName(ip);
                ip = addr.getHostAddress();
            }
        }
        catch (Exception e) {
            validIP = false;
        }
        return validIP;
    }

    private boolean scanIndividualIPTokenValidity(String[] iparr) {
        for (int i = 0; i < iparr.length; ++i) {
            String token = iparr[i];
            if (Pattern.matches("[0-9\\-]*|[\\*]", token)) {
                int indexOfDash = token.indexOf(45);
                if (indexOfDash == -1 || indexOfDash != 0 && indexOfDash != token.length() - 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String getType(boolean enabled, boolean userIdRequired) {
        if (!enabled) {
            return "NONE";
        }
        if (enabled && !userIdRequired) {
            return "SINGLEUSER";
        }
        return "MULTIUSER";
    }

    private void updateValuesForSecureProfile(Map neoMap, GenericSetting genericSetting, boolean newValue) {
        Iterator iterator = neoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object secureDefaultValue;
            Object defaultValue;
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            String k = (String)entry.getKey();
            if (genericSetting.getCategory() == Category.RUNTIME) {
                k = this.getRuntimeSettingKeyName(k);
            }
            ConfigMap valueStruct = (ConfigMap)entry.getValue();
            ValidationDetails vd = SettingValidation.getInstance().getValidationDetail(genericSetting.getCategory(), k);
            Object object = genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("otherSettings/scriptProtect") ? Boolean.valueOf(!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)valueStruct.get("default")))) : (defaultValue = Util.getValueByType(vd.getType(), valueStruct.get("default")));
            Object object2 = genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("otherSettings/scriptProtect") ? Boolean.valueOf(!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)valueStruct.get("securedefault")))) : (secureDefaultValue = Util.getValueByType(vd.getType(), valueStruct.get("securedefault")));
            if (!newValue) {
                genericSetting.setSetting(k, defaultValue, null);
                continue;
            }
            if (genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("misc_settings/sessionCookieTimeout")) {
                String timeoutString = genericSetting.getSetting(k, null);
                Integer timeout = Double.valueOf(timeoutString).intValue();
                timeout = timeout - timeout % 60;
                valueStruct.put("default", String.valueOf(timeout));
            } else if (genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("otherSettings/scriptProtect")) {
                valueStruct.put("default", Boolean.valueOf(genericSetting.getSetting(k, null)) != false ? "FORM,URL,COOKIE,CGI" : "");
            } else {
                valueStruct.put("default", genericSetting.getSetting(k, null));
            }
            if (genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("errors/queue_timeout")) {
                Object secureErrorPage = (String)secureDefaultValue;
                secureErrorPage = ((String)secureErrorPage).split("\\.")[0] + ".htm";
                genericSetting.setSetting(k, secureErrorPage, null);
                continue;
            }
            if (genericSetting.getCategory() == Category.RUNTIME && k.equalsIgnoreCase("misc_settings/sessionCookieTimeout")) {
                genericSetting.setSetting(k, (Double)secureDefaultValue * 60.0, null);
                continue;
            }
            genericSetting.setSetting(k, secureDefaultValue, null);
        }
    }

    private void updateValuesOfDriver(Map neoMap, SecureProfileService secureProfileService, boolean newValue) {
        Map map = secureProfileService.getDriverConfigurationMap();
        Iterator iterator = neoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            String k = (String)entry.getKey();
            ConfigMap valueStruct = (ConfigMap)entry.getValue();
            if (!newValue) {
                map.put(k, Util.getValueByType("boolean", valueStruct.get("default")));
                continue;
            }
            valueStruct.put("default", String.valueOf(secureProfileService.getDriverSetting(k)));
            map.put(k, Util.getValueByType("boolean", valueStruct.get("securedefault")));
        }
        secureProfileService.setDriverConfigurationMap(map);
    }

    private void updateValuesOfSecurity(Map neoMap, Map securityMap, boolean newValue) {
        this.updateMapForAdminAuthType((String)securityMap.get("adminAuthType"), securityMap);
        this.updateMapForRdsAuthType((String)securityMap.get("rdsAuthType"), securityMap);
        Iterator iterator = neoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            HashSet<String> value;
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            String k = (String)entry.getKey();
            ConfigMap valueStruct = (ConfigMap)entry.getValue();
            if (!newValue) {
                String defaultValue = (String)valueStruct.get("default");
                value = defaultValue;
                if (k.equalsIgnoreCase("sbs.security.enabled")) {
                    this.securityService.updateSandboxEnabledStatus(Boolean.valueOf(defaultValue));
                    continue;
                }
                if (k.equalsIgnoreCase("allowedAdminIPList")) {
                    value = new HashSet();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defaultValue)) {
                        value = new HashSet<String>(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)defaultValue, (String)",")));
                    }
                } else if (!k.equalsIgnoreCase("rds.security.enabled") && !k.equalsIgnoreCase("rds.enabled")) {
                    value = Util.getValueByType("boolean", defaultValue);
                }
                securityMap.put(k, value);
                continue;
            }
            if (k.equalsIgnoreCase("allowedAdminIPList")) {
                valueStruct.put("default", org.apache.commons.lang3.StringUtils.join((Iterable)((Set)securityMap.get(k)), (String)","));
            } else if ("sbs.security.enabled".equalsIgnoreCase(k)) {
                valueStruct.put("default", this.securityService.getSandboxEnabledStatus());
            } else {
                valueStruct.put("default", String.valueOf(securityMap.get(k)));
            }
            String secureDefaultValue = (String)valueStruct.get("securedefault");
            value = secureDefaultValue;
            if (k.equalsIgnoreCase("sbs.security.enabled")) {
                this.securityService.updateSandboxEnabledStatus(Boolean.valueOf(secureDefaultValue));
                continue;
            }
            if (k.equalsIgnoreCase("allowedAdminIPList")) {
                value = new HashSet();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)secureDefaultValue)) {
                    value = new HashSet<String>(Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)secureDefaultValue, (String)",")));
                }
            } else if (!k.equalsIgnoreCase("rds.security.enabled") && !k.equalsIgnoreCase("rds.enabled")) {
                value = Util.getValueByType("boolean", secureDefaultValue);
            }
            securityMap.put(k, value);
        }
    }

    private String getRuntimeSettingKeyName(String k) {
        if (k.equalsIgnoreCase("compileextforinclude")) {
            k = "misc_settings/compileextforinclude";
        }
        if (k.equalsIgnoreCase("postSizeLimit")) {
            k = "request_settings/postSizeLimit";
        }
        if (k.equalsIgnoreCase("queue_timeout")) {
            k = "errors/queue_timeout";
        }
        if (k.equalsIgnoreCase("internalCookiesDisableUpdate")) {
            k = "misc_settings/internalCookiesDisableUpdate";
        }
        if (k.equalsIgnoreCase("site_wide")) {
            k = "errors/site_wide";
        }
        if (k.equalsIgnoreCase("missing_template")) {
            k = "errors/missing_template";
        }
        if (k.equalsIgnoreCase("sessionCookieTimeout")) {
            k = "misc_settings/sessionCookieTimeout";
        }
        if (k.equalsIgnoreCase("disableServiceFactory")) {
            k = "misc_settings/disableServiceFactory";
        }
        if (k.equalsIgnoreCase("scriptprotect")) {
            k = "otherSettings/scriptProtect";
        }
        return k;
    }

    private void updateMapForRdsAuthType(String v, Map map) {
        switch (v) {
            case "MULTIUSER": {
                map.put("rds.security.enabled", "true");
                map.put("rds.security.usesinglerdspassword", false);
                break;
            }
            case "SINGLEUSER": {
                map.put("rds.security.enabled", "true");
                map.put("rds.security.usesinglerdspassword", true);
                break;
            }
            case "NONE": {
                map.put("rds.security.enabled", "false");
                map.put("rds.security.usesinglerdspassword", false);
            }
        }
    }

    private void updateMapForAdminAuthType(String v, Map map) {
        switch (v) {
            case "MULTIUSER": {
                map.put("admin.security.enabled", true);
                map.put("admin.userid.required", true);
                break;
            }
            case "SINGLEUSER": {
                map.put("admin.security.enabled", true);
                map.put("admin.userid.required", false);
                break;
            }
            case "NONE": {
                map.put("admin.security.enabled", false);
                map.put("admin.userid.required", false);
            }
        }
    }

    private boolean handleIfAlreadyPresent(Set<String> currentList, Set<String> existingList, String setting) {
        if (AbstractCommand.commandName == CommandName.IMPORT) {
            return false;
        }
        ArrayList<String> alreadyPresentList = new ArrayList<String>();
        for (String ip : currentList) {
            if (!existingList.contains(ip)) continue;
            alreadyPresentList.add(ip);
        }
        if (alreadyPresentList.size() > 0) {
            MessageHandler.getInstance().showError(Messages.getString("IP.alreadyPresent", org.apache.commons.lang3.StringUtils.join(alreadyPresentList, (String)", "), ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), setting)));
            return true;
        }
        return false;
    }

    private boolean handleIfNotPresent(Set<String> currentList, Set<String> existingList, String setting) {
        ArrayList<String> notPresentList = new ArrayList<String>();
        for (String ip : currentList) {
            if (existingList.contains(ip)) continue;
            notPresentList.add(ip);
        }
        if (notPresentList.size() > 0) {
            MessageHandler.getInstance().showError(Messages.getString("IP.notPresent", org.apache.commons.lang3.StringUtils.join(notPresentList, (String)", "), ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), setting)));
            return true;
        }
        return false;
    }
}

