/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.base.ConfigurationBase;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.settings.simple.SingleLayerSettings;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.XMLConfiguration;

public class DotnetSettings
extends ConfigurationBase {
    private String dotnetXml = Category.DOTNET.getFileName();
    private File dotnetXmlFile;
    private XMLConfiguration dotnetCfg;
    public final String nodeBase;
    public final String totalStructs;
    private Map<String, Object> dotnetMap = new HashMap<String, Object>();
    private SingleLayerSettings slSetting;

    public DotnetSettings(String instancePath) {
        super(instancePath);
        this.nodeBase = "data.struct(";
        this.totalStructs = "data.struct[@type]";
        this.dotnetXmlFile = selectedPath.contains(".xml") ? new File(selectedPath) : new File(selectedPath + File.separator + "lib" + File.separator + this.dotnetXml);
        this.dotnetCfg = DotnetSettings.getParsedConfigObject(this.dotnetXmlFile);
        this.slSetting = new SingleLayerSettings(this);
        this.populateMap();
    }

    @Override
    public List<String> getAllXmlAttributes() {
        return this.slSetting.getAllXmlAttributes();
    }

    @Override
    public List<String> getValuesforKeys(List<String> keysList) {
        return this.slSetting.getValuesforKeys(keysList);
    }

    @Override
    public String getSetting(String name) {
        return this.slSetting.getSetting(name);
    }

    @Override
    public boolean setSetting(String name, String value) {
        return this.slSetting.setSetting(name, value);
    }

    @Override
    public void populateMap() {
        this.slSetting.populateMap(this.nodeBase, this.totalStructs);
    }

    public Map<String, Object> getMap() {
        return this.dotnetMap;
    }

    @Override
    public XMLConfiguration getCfg() {
        return this.dotnetCfg;
    }

    @Override
    public File getXMLFileObject() {
        return this.dotnetXmlFile;
    }

    @Override
    public String getXMLFileName() {
        return this.dotnetXml;
    }

    @Override
    public Category getCategory() {
        return Category.DOTNET;
    }

    @Override
    public void show(String service) {
        this.slSetting.show();
    }
}

