/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.base.ConfigurationBase;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.settings.simple.SingleLayerSettings;
import com.adobe.cfsetup.settings.simple.pojo.StringXML;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.XMLConfiguration;

public class GraphingSettings
extends ConfigurationBase {
    private String graphingXml = Category.CHART.getFileName();
    private File graphingXmlFile;
    private XMLConfiguration graphingCfg;
    public final String nodeBase;
    public final String totalStructs;
    private Map<String, Object> graphingMap = new HashMap<String, Object>();
    private SingleLayerSettings slSetting;

    public GraphingSettings(String instancePath) {
        super(instancePath);
        this.nodeBase = "data.array.struct(";
        this.totalStructs = "data.array[@length]";
        this.graphingXmlFile = selectedPath.contains(".xml") ? new File(selectedPath) : new File(selectedPath + File.separator + "lib" + File.separator + this.graphingXml);
        this.graphingCfg = GraphingSettings.getParsedConfigObject(this.graphingXmlFile);
        this.slSetting = new SingleLayerSettings(this);
        this.populateMap();
    }

    @Override
    public List<String> getAllXmlAttributes() {
        return this.slSetting.getAllXmlAttributes();
    }

    @Override
    public List<String> getValuesforKeys(List<String> keysList) {
        return this.slSetting.getValuesforKeys(keysList);
    }

    @Override
    public String getSetting(String name) {
        return this.slSetting.getSetting(name);
    }

    @Override
    public boolean setSetting(String name, String value) {
        boolean success = false;
        if ("CACHEPATH".equalsIgnoreCase(name)) {
            if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                return true;
            }
            MessageHandler.getInstance().showError(Messages.getString("cantEditSetting", ProposedSetting.getInstance().getUserDefinedValue(this.getCategory(), "CACHEPATH")));
            return false;
        }
        boolean cachepath = name.equalsIgnoreCase("CACHEPATH");
        if (cachepath) {
            this.slSetting.setSupressNoSuchKey(true);
        }
        if (!(success = this.slSetting.setSetting(name, value)) && cachepath) {
            StringXML xml = new StringXML(name, value);
            success = this.slSetting.addService("data.array.struct(0).dummy", xml);
        }
        if (cachepath) {
            this.slSetting.setSupressNoSuchKey(false);
        }
        return success;
    }

    @Override
    public void populateMap() {
        this.slSetting.populateMap(this.nodeBase, this.totalStructs);
    }

    public Map<String, Object> getMap() {
        return this.graphingMap;
    }

    @Override
    public XMLConfiguration getCfg() {
        return this.graphingCfg;
    }

    @Override
    public File getXMLFileObject() {
        return this.graphingXmlFile;
    }

    @Override
    public String getXMLFileName() {
        return this.graphingXml;
    }

    @Override
    public Category getCategory() {
        return Category.CHART;
    }

    @Override
    public void show(String service) {
        this.slSetting.show();
    }
}

