/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.settings.simple;

import com.adobe.cfsetup.base.ConfigurationBase;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.settings.simple.SingleLayerSettings;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.XMLConfiguration;

public class MetricSettings
extends ConfigurationBase {
    private String metricXml = Category.METRIC.getFileName();
    private File metricXmlFile;
    private XMLConfiguration metricCfg;
    public final String nodeBase;
    public final String totalStructs;
    private Map<String, Object> metricMap = new HashMap<String, Object>();
    private SingleLayerSettings slSetting;

    public MetricSettings(String instancePath) {
        super(instancePath);
        this.nodeBase = "data.struct(";
        this.totalStructs = "data.struct[@type]";
        this.metricXmlFile = selectedPath.contains(".xml") ? new File(selectedPath) : new File(selectedPath + File.separator + "lib" + File.separator + this.metricXml);
        this.metricCfg = MetricSettings.getParsedConfigObject(this.metricXmlFile);
        this.slSetting = new SingleLayerSettings(this);
        this.populateMap();
    }

    @Override
    public List<String> getAllXmlAttributes() {
        return this.slSetting.getAllXmlAttributes();
    }

    @Override
    public List<String> getValuesforKeys(List<String> keysList) {
        return this.slSetting.getValuesforKeys(keysList);
    }

    @Override
    public String getSetting(String name) {
        return this.slSetting.getSetting(name);
    }

    @Override
    public boolean setSetting(String name, String value) {
        return this.slSetting.setSetting(name, value);
    }

    @Override
    public void populateMap() {
        this.slSetting.populateMap(this.nodeBase, this.totalStructs);
    }

    public Map<String, Object> getMap() {
        return this.metricMap;
    }

    @Override
    public XMLConfiguration getCfg() {
        return this.metricCfg;
    }

    @Override
    public File getXMLFileObject() {
        return this.metricXmlFile;
    }

    @Override
    public String getXMLFileName() {
        return this.metricXml;
    }

    @Override
    public Category getCategory() {
        return Category.METRIC;
    }

    @Override
    public void show(String service) {
        this.slSetting.show();
    }
}

