/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FilePathValidation
extends ValidationDetails {
    @Override
    public boolean validate(Object value) {
        boolean isValid = true;
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            return isValid;
        }
        try {
            if (Objects.isNull(value) || String.valueOf(value).trim().length() == 0) {
                isValid = false;
            } else {
                File f = new File(String.valueOf(value));
                if (!f.exists() || !f.isFile()) {
                    isValid = false;
                }
            }
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        if (!isValid) {
            this.errorMessage = Messages.getString("expectedFile");
        }
        return isValid;
    }
}

