/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FilePermissionValidation
extends ValidationDetails {
    @Override
    public boolean validate(Object value) {
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            return true;
        }
        boolean isValid = true;
        try {
            if (Objects.isNull(value) || StringUtils.isEmpty((CharSequence)String.valueOf(value))) {
                isValid = false;
            }
            String str = String.valueOf(value);
            String[] ar = str.split(":");
            String permissions = ar[0];
            isValid = this.checkPermission(permissions);
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            return false;
        }
        if (!isValid) {
            this.errorMessage = Messages.getString("filePermissionError");
        }
        return isValid;
    }

    private boolean checkPermission(String permissions) {
        boolean isValid = true;
        char[] charAr = new char[]{'r', 'w', 'x', 'd'};
        for (int i = 0; i < permissions.length(); ++i) {
            char ch = permissions.charAt(i);
            if ('A' <= ch && ch <= 'Z') {
                ch = (char)(ch - 65 + 97);
            }
            boolean found = false;
            for (int j = 0; j < 4; ++j) {
                if (ch != charAr[j]) continue;
                found = true;
            }
            if (found) continue;
            isValid = false;
            break;
        }
        return isValid;
    }
}

