/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cfsetup.validation;

import com.adobe.cfsetup.MessageHandler;
import com.adobe.cfsetup.Util;
import com.adobe.cfsetup.base.GenericSetting;
import com.adobe.cfsetup.base.ProposedSetting;
import com.adobe.cfsetup.commands.AbstractCommand;
import com.adobe.cfsetup.commands.CommandName;
import com.adobe.cfsetup.constants.Category;
import com.adobe.cfsetup.constants.Messages;
import com.adobe.cfsetup.exception.CFSetupException;
import com.adobe.cfsetup.validation.EmptyValidationDetail;
import com.adobe.cfsetup.validation.FilePermissionValidation;
import com.adobe.cfsetup.validation.MapValidation;
import com.adobe.cfsetup.validation.RegexValidation;
import com.adobe.cfsetup.validation.ValidationDetails;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingValidation {
    private static final Logger logger = LoggerFactory.getLogger(SettingValidation.class);
    private final Map<Category, Map<String, ValidationDetails>> validationMap;
    private static SettingValidation instance = new SettingValidation();

    public static SettingValidation getInstance() {
        return instance;
    }

    private SettingValidation() {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("settingsValidation.json");
        try {
            HashMap validationMap = new HashMap();
            HashMap map = (HashMap)new ObjectMapper().readValue(in, HashMap.class);
            map.forEach((settingPath, validation) -> {
                String[] settingSplit = settingPath.split("\\.");
                if (!Util.isSettingValid(settingSplit[0])) {
                    logger.error(Messages.getString("invalidSettingCategory") + ": " + settingSplit[0]);
                    return;
                }
                Category category = Category.of(settingSplit[0]);
                String actualSetting = ProposedSetting.getInstance().getActualSetting(settingSplit, category, (String)settingPath);
                HashMap<String, ValidationDetails> categoryValidations = (HashMap<String, ValidationDetails>)validationMap.get((Object)category);
                if (Objects.isNull(categoryValidations)) {
                    categoryValidations = new HashMap<String, ValidationDetails>();
                    validationMap.put(category, categoryValidations);
                }
                ValidationDetails validationDetails = (ValidationDetails)new ObjectMapper().convertValue(validation, ValidationDetails.class);
                categoryValidations.put(actualSetting, validationDetails);
            });
            this.validationMap = Collections.unmodifiableMap(validationMap);
        }
        catch (Exception e) {
            throw new CFSetupException("unable to load setting validation", e);
        }
    }

    public Optional<Object> validateAndUpdateValue(Category category, String actualSetting, String value) {
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        Set<String> reqSet = this.getMandatorySettings(category);
        boolean isValid = true;
        value = value.trim();
        if (reqSet.contains(actualSetting) && StringUtils.isBlank((CharSequence)value)) {
            if (category == Category.USER && "password".equalsIgnoreCase(actualSetting)) {
                MessageHandler.getInstance().showError(Messages.getString("passwordRequired"));
            }
            return Optional.empty();
        }
        if (MapUtils.isNotEmpty(validationDetailsMap) && validationDetailsMap.containsKey(actualSetting)) {
            ValidationDetails validationDetails = validationDetailsMap.get(actualSetting);
            if (validationDetails.isRestricted() && !CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
                MessageHandler.getInstance().showError(Messages.getString("restrictedKey", ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting), category.name()));
                return Optional.empty();
            }
            if (category == Category.DATASOURCE && "urlmap/port".equalsIgnoreCase(actualSetting)) {
                isValid = StringUtils.isEmpty((CharSequence)value) || NumberUtils.isNumber((String)value);
                return isValid ? Optional.of(value) : Optional.empty();
            }
            if (category == Category.CLIENTVARIABLE && "name".equalsIgnoreCase(actualSetting)) {
                return StringUtils.isNotBlank((CharSequence)value) ? Optional.of(value) : Optional.empty();
            }
            isValid = this.validate(value, validationDetailsMap.get(actualSetting));
            if (isValid && validationDetails instanceof MapValidation) {
                Map<Object, Object> validationCriteria = ((MapValidation)validationDetails).getCaseInsensitiveValidationCriteria();
                Object valueObj = this.getValueFromMap(validationCriteria, value);
                return Optional.ofNullable(Util.getValueByType(validationDetails.getType(), valueObj));
            }
            if (isValid && validationDetails instanceof FilePermissionValidation) {
                return Optional.of(category == Category.USER ? value : Util.getFilePermissionsValue(value.substring(0, value.indexOf(":"))) + value.substring(value.indexOf(":")));
            }
            String userDefinedKey = ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting);
            if (!isValid) {
                if (validationDetails instanceof MapValidation) {
                    if (category == Category.DATASOURCE && "DRIVER".equalsIgnoreCase(actualSetting)) {
                        Map<Object, Object> validationCriteria = ((MapValidation)validationDetails).getValidationCriteria();
                        Util.printAllowedValues(ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting), validationCriteria.keySet());
                    } else {
                        if (category == Category.CLIENTVARIABLE && "default".equalsIgnoreCase(actualSetting) && StringUtils.isNotEmpty((CharSequence)value)) {
                            return Optional.of(value);
                        }
                        ((MapValidation)validationDetails).printError(ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting));
                    }
                } else if ((validationDetails instanceof RegexValidation || StringUtils.isNotBlank((CharSequence)validationDetails.getErrorMessage())) && (category != Category.USER || category == Category.USER && !"password".equalsIgnoreCase(actualSetting))) {
                    MessageHandler.getInstance().showError(userDefinedKey + ": " + validationDetails.getErrorMessage());
                }
            }
            return isValid ? this.getValueByType(validationDetails.getType(), value) : Optional.empty();
        }
        return reqSet.contains(actualSetting) && StringUtils.isBlank((CharSequence)value) ? Optional.empty() : Optional.of(value);
    }

    private Object getValueFromMap(Map<Object, Object> validationCriteria, String value) {
        Object valueObj = null;
        if (CommandName.IMPORT.equals((Object)AbstractCommand.commandName)) {
            boolean isPresent = false;
            for (Map.Entry<Object, Object> entry : validationCriteria.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof List) {
                    isPresent |= ((ArrayList)v).stream().anyMatch(x -> x.equalsIgnoreCase(value));
                    continue;
                }
                if (v instanceof String) {
                    isPresent |= ((String)v).equalsIgnoreCase(value);
                    continue;
                }
                isPresent |= v.equals(value);
            }
            if (isPresent) {
                valueObj = value;
            }
        } else {
            valueObj = validationCriteria.get(value.toUpperCase());
            if (valueObj instanceof List) {
                valueObj = ((ArrayList)valueObj).get(0);
            }
        }
        return valueObj;
    }

    private Optional<Object> getValueByType(String type, String value) {
        try {
            return Optional.of(Util.getValueByType(type, value));
        }
        catch (Exception e) {
            logger.error(Messages.getString("invalidValueOfType", type) + " : " + value, (Throwable)e);
            return Optional.empty();
        }
    }

    private Set<String> checkMandatoryFields(Category category, Map<String, Object> keyValueMap) {
        Set<String> reqSet = this.getMandatorySettings(category);
        return reqSet.stream().filter(v -> this.isFieldPresentFilter(keyValueMap, (String)v)).map(v -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)v)).collect(Collectors.toSet());
    }

    private boolean isFieldPresentFilter(Map<String, Object> keyValueMap, String v) {
        Object object = keyValueMap.get(v);
        return Objects.isNull(object) || StringUtils.isBlank((CharSequence)String.valueOf(object));
    }

    private Map<String, Object> applyDefault(Category category, Map<String, Object> keyValueMap) {
        HashMap<String, Object> newKeyValueMap = new HashMap<String, Object>(keyValueMap);
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        HashSet mustNotSettings = new HashSet();
        if (validationDetailsMap != null) {
            validationDetailsMap.forEach((settingKey, validationDetail) -> {
                if (keyValueMap.containsKey(settingKey) && MapUtils.isNotEmpty(validationDetail.getDependency())) {
                    String value = String.valueOf(keyValueMap.get(settingKey)).toUpperCase();
                    if (validationDetail.getDependency().containsKey(value)) {
                        ValidationDetails.DependencyInfo dependencyInfo = validationDetail.getDependency().get(value);
                        mustNotSettings.addAll(this.getMustNot(dependencyInfo, category));
                    }
                }
            });
            validationDetailsMap.entrySet().stream().filter(entry -> Objects.nonNull(((ValidationDetails)entry.getValue()).getDefaultValue())).forEach(entry -> {
                if (!newKeyValueMap.containsKey(entry.getKey()) && !mustNotSettings.contains(entry.getKey())) {
                    newKeyValueMap.put((String)entry.getKey(), ((ValidationDetails)entry.getValue()).getDefaultValue());
                }
            });
        }
        return newKeyValueMap;
    }

    private Set<String> getMandatorySettings(Category category) {
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        Set<String> reqSet = new HashSet<String>();
        if (validationDetailsMap != null) {
            reqSet = validationDetailsMap.entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).isRequired()).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        return reqSet;
    }

    private boolean validate(String value, ValidationDetails validationDetails) {
        try {
            return validationDetails.validate(value);
        }
        catch (Exception e) {
            logger.error("validation error", (Throwable)e);
            return false;
        }
    }

    public String transformToUserValue(Category category, String actualSetting, String value) {
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        String res = value;
        String trimmedValue = value = value.trim();
        if (MapUtils.isNotEmpty(validationDetailsMap) && validationDetailsMap.containsKey(actualSetting)) {
            ValidationDetails validationDetails = validationDetailsMap.get(actualSetting);
            if (validationDetails instanceof MapValidation) {
                res = ((Map)Optional.ofNullable(((MapValidation)validationDetails).getValidationCriteria()).orElse(new HashMap())).entrySet().stream().filter(entry -> {
                    if (entry.getValue() instanceof List) {
                        return ((ArrayList)entry.getValue()).contains(trimmedValue);
                    }
                    return trimmedValue.equalsIgnoreCase(String.valueOf(entry.getValue()));
                }).map(entry -> String.valueOf(entry.getKey())).findFirst().orElse(value);
            } else if (StringUtils.isNotBlank((CharSequence)validationDetails.getDisplayType())) {
                res = String.valueOf(Util.getValueByType(validationDetails.getDisplayType(), value));
            }
        }
        return Util.removeTrailingZeroesAfterDecimal(res);
    }

    public void dependencyValidation(Category category, Map<String, Object> keyValueMap, Map<String, Object> currentMap) {
        Map<String, ValidationDetails> categoryValidationMap = this.validationMap.get((Object)category);
        if (MapUtils.isEmpty(categoryValidationMap)) {
            return;
        }
        Map<String, ValidationDetails> dependencyValidationMap = categoryValidationMap.entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).getDependency() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<String, ValidationDetails> mapEntry : dependencyValidationMap.entrySet()) {
            String actualSetting = mapEntry.getKey();
            ValidationDetails validationDetails = mapEntry.getValue();
            for (Map.Entry<String, ValidationDetails.DependencyInfo> entry2 : validationDetails.getDependency().entrySet()) {
                String val = entry2.getKey();
                String value = String.valueOf(Optional.ofNullable(keyValueMap.get(actualSetting)).orElseGet(() -> currentMap != null ? currentMap.get(actualSetting) : validationDetails.getDefaultValue()));
                ValidationDetails.DependencyInfo dependencyInfo = entry2.getValue();
                List must = ListUtils.emptyIfNull(dependencyInfo.getMust());
                Set<String> mustNot = this.getMustNot(dependencyInfo, category);
                Set<String> should = this.getShould(dependencyInfo, category);
                Iterator iterator = must.iterator();
                Set<Object> expandedMust = new HashSet();
                while (iterator.hasNext()) {
                    String setting = (String)iterator.next();
                    if (!setting.contains("[") || !setting.contains("]")) continue;
                    Collection<String> settings = ProposedSetting.getInstance().getCategoryProposedSettingMap(category).values();
                    expandedMust = settings.stream().filter(s -> Pattern.matches(setting, s)).collect(Collectors.toSet());
                }
                must.addAll(expandedMust);
                if (!val.equalsIgnoreCase(value)) continue;
                List mustExp = must.stream().filter(v -> keyValueMap.containsKey(v) ? Util.isEmptyValInMap(keyValueMap, v) : Util.isEmptyValInMap(currentMap, v)).map(v -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)v)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                List mustNotExp = mustNot.stream().filter(keyValueMap::containsKey).map(v -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)v)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                List shouldExp = should.stream().filter(keyValueMap::containsKey).map(v -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)v)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                String userDefSetting = ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting);
                if (CollectionUtils.isEmpty(mustExp) && CollectionUtils.isEmpty(mustNotExp) && (CollectionUtils.isEmpty(should) || !CollectionUtils.isEmpty(shouldExp))) continue;
                if (!mustExp.isEmpty()) {
                    List userDefinedMust = must.stream().map(m -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)m)).collect(Collectors.toList());
                    MessageHandler.getInstance().showError(Messages.getString("mustPresent", StringUtils.join(mustExp, (String)", "), StringUtils.join(userDefinedMust, (String)", "), userDefSetting, value));
                }
                if (!mustNotExp.isEmpty()) {
                    List userDefinedMustNot = mustNot.stream().map(m -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)m)).collect(Collectors.toList());
                    MessageHandler.getInstance().showError(Messages.getString("mustNotPresent", StringUtils.join(mustNotExp, (String)", "), StringUtils.join(userDefinedMustNot, (String)", "), userDefSetting, value));
                }
                if (!CollectionUtils.isEmpty(should) && CollectionUtils.isEmpty(shouldExp)) {
                    List userDefinedShould = should.stream().map(m -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)m)).collect(Collectors.toList());
                    MessageHandler.getInstance().showError(Messages.getString("shouldPresent", StringUtils.join(userDefinedShould, (String)", "), userDefSetting, value));
                }
                throw new CFSetupException(Messages.getString("mustPresent", StringUtils.join(mustExp, (String)", "), StringUtils.join((Iterable)must, (String)", "), userDefSetting, value).concat("\n").concat(Messages.getString("mustNotPresent", StringUtils.join(mustNotExp, (String)", "), StringUtils.join(mustNot, (String)", "), userDefSetting, value).concat(Messages.getString("shouldPresent", StringUtils.join(should, (String)", "), userDefSetting, value))));
            }
        }
    }

    public boolean validateRequiredFields(Category category, Map<String, Object> keyValueMap) {
        Set<String> unprovidedReqFields = this.checkMandatoryFields(category, keyValueMap);
        if (!unprovidedReqFields.isEmpty()) {
            String fields = StringUtils.join(unprovidedReqFields, (String)", ");
            MessageHandler.getInstance().showError(Messages.getString("provideVal", fields));
            return false;
        }
        return true;
    }

    public Optional<Map<String, Object>> validateCommand(Category category, Map<String, Object> keyValueMap) {
        HashMap<String, Object> updatedKeyValueMap = new HashMap<String, Object>();
        Map<String, Object> newKeyValueMap = this.applyDefault(category, keyValueMap);
        keyValueMap = Collections.unmodifiableMap(newKeyValueMap);
        LinkedList<String> failedList = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            String actualSetting = entry.getKey();
            Object value = entry.getValue();
            if (this.getValidationDetail(category, actualSetting).isList()) {
                List list = (List)value;
                for (Object v : list) {
                    String val = (String)v;
                    Optional<Object> updatedValue = this.validateAndUpdateValue(category, actualSetting, String.valueOf(val));
                    if (!updatedValue.isPresent()) {
                        failedList.add(actualSetting);
                        continue;
                    }
                    Util.addListToMap(updatedKeyValueMap, actualSetting, updatedValue.get());
                }
                continue;
            }
            Optional<Object> updatedValue = this.validateAndUpdateValue(category, actualSetting, String.valueOf(value));
            if (!updatedValue.isPresent()) {
                failedList.add(actualSetting);
                continue;
            }
            updatedKeyValueMap.put(actualSetting, updatedValue.get());
        }
        if (CollectionUtils.isNotEmpty(failedList)) {
            List userDefinedListFailed = failedList.stream().map(setting -> ProposedSetting.getInstance().getUserDefinedValue(category, (String)setting)).collect(Collectors.toList());
            MessageHandler.getInstance().showError(Messages.getString("validationFailed", category.name(), StringUtils.join(userDefinedListFailed, (String)"\n")));
            return Optional.empty();
        }
        keyValueMap = Collections.unmodifiableMap(updatedKeyValueMap);
        return Optional.ofNullable(keyValueMap);
    }

    public boolean validateDuplicateServiceName(GenericSetting genericSetting, String actualSetting, String value, String service) {
        if (Category.JVM.equals((Object)genericSetting.getCategory()) || Category.SECURITY == genericSetting.getCategory()) {
            return true;
        }
        Category category = genericSetting.getCategory();
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        if (MapUtils.isNotEmpty(validationDetailsMap)) {
            ValidationDetails validationDetails = validationDetailsMap.get(actualSetting);
            TreeMap caseInsensitiveMap = new TreeMap(genericSetting.getMap());
            if (validationDetails != null && validationDetails.isServicekey() && caseInsensitiveMap.containsKey(value) && !value.equalsIgnoreCase(service)) {
                MessageHandler.getInstance().showError(Messages.getString("duplicateServiceKey", category.name(), ProposedSetting.getInstance().getUserDefinedValue(category, actualSetting), value));
                return false;
            }
        }
        return true;
    }

    public boolean validateAddDuplicateServiceName(GenericSetting genericSetting, Map<String, ?> keyValueMap) {
        if (Boolean.valueOf(System.getProperty("AddCommandAsUpdate")).booleanValue()) {
            return true;
        }
        Category category = genericSetting.getCategory();
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        TreeMap map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        map.putAll(genericSetting.getMap());
        Optional<String> servicekey = ((Map)Optional.ofNullable(validationDetailsMap).orElse(new HashMap())).entrySet().stream().filter(e -> ((ValidationDetails)e.getValue()).isServicekey()).map(Map.Entry::getKey).findFirst();
        servicekey.ifPresent(s -> map.entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(Util.getServiceName(s, keyValueMap, category)) || category != Category.SCHEDULETASK && e.getValue() instanceof Map && ((Map)e.getValue()).containsKey(s) && String.valueOf(((Map)e.getValue()).get(s)).equalsIgnoreCase((String)keyValueMap.get(s)) || genericSetting.getCategory() == Category.CUSTOMTAG && ((String)keyValueMap.get(s)).equalsIgnoreCase((String)e.getValue())).map(e -> Category.CUSTOMTAG == genericSetting.getCategory() ? (String)keyValueMap.get(s) : this.getExistingValue((String)s, (String)e.getKey(), e.getValue())).findFirst().ifPresent(existingValue -> {
            MessageHandler.getInstance().showError(Messages.getString("duplicateServiceKey", category.name(), ProposedSetting.getInstance().getUserDefinedValue(category, (String)s), existingValue));
            throw new CFSetupException(Messages.getString("duplicateServiceKey", category.name(), ProposedSetting.getInstance().getUserDefinedValue(category, (String)s), existingValue));
        }));
        return true;
    }

    private String getExistingValue(String settingKey, String mapKey, Object object) {
        if (object instanceof Map && ((Map)object).containsKey(settingKey)) {
            return String.valueOf(((Map)object).get(settingKey));
        }
        return mapKey;
    }

    public boolean validateServiceName(GenericSetting genericSetting, String service, Set<String> keys) {
        Category category = genericSetting.getCategory();
        Map<String, ValidationDetails> validationDetailsMap = this.validationMap.get((Object)category);
        if (MapUtils.isNotEmpty(validationDetailsMap)) {
            Optional<String> serviceKey = validationDetailsMap.entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).isServicekey()).map(Map.Entry::getKey).findFirst();
            Set<String> dependentSettings = this.getServicedependentKeys(category, keys);
            if (serviceKey.isPresent() && StringUtils.isBlank((CharSequence)service) && !dependentSettings.isEmpty()) {
                MessageHandler.getInstance().showError(Messages.getString("blankServiceName", genericSetting.getCategory().name()));
                return false;
            }
            if (category == Category.SERVER && !genericSetting.getMap().containsKey(service)) {
                MessageHandler.getInstance().showError(Messages.getString("serviceDoesNotExist", service, genericSetting.getCategory().name()));
                return false;
            }
        }
        return true;
    }

    public Set<String> getServicedependentKeys(Category category, Set<String> keys) {
        keys = new HashSet<String>(keys);
        Map<String, ValidationDetails> validationDetailsMap = this.getcategoryValidationMap(category);
        Set independentSettings = validationDetailsMap.entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).isServiceIndependent()).map(Map.Entry::getKey).collect(Collectors.toSet());
        keys.removeAll(independentSettings);
        return keys;
    }

    public Map<String, ValidationDetails> getcategoryValidationMap(Category category) {
        return this.validationMap.getOrDefault((Object)category, new HashMap());
    }

    public String getServiceKey(Category category) {
        return this.getcategoryValidationMap(category).entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).isServicekey()).map(Map.Entry::getKey).findFirst().orElse("");
    }

    public ValidationDetails getValidationDetail(Category category, String setting) {
        return this.validationMap.get((Object)category) != null ? (this.validationMap.get((Object)category).get(setting) != null ? this.validationMap.get((Object)category).get(setting) : new EmptyValidationDetail()) : new EmptyValidationDetail();
    }

    public Set<String> getEncryptedFields(Category category) {
        return SettingValidation.getInstance().getcategoryValidationMap(category).entrySet().stream().filter(e -> ((ValidationDetails)e.getValue()).isEncrypted()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private Set<String> getMustNot(ValidationDetails.DependencyInfo dependencyInfo, Category category) {
        HashSet<String> mustNot = new HashSet<String>();
        if (CollectionUtils.isEmpty(dependencyInfo.getMust_not())) {
            return mustNot;
        }
        mustNot = new HashSet(ListUtils.emptyIfNull(dependencyInfo.getMust_not()));
        Iterator iterator = mustNot.iterator();
        HashSet expandedMustNot = new HashSet();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            Set<String> settings = ProposedSetting.getInstance().getCategoryProposedSettingMap(category).keySet();
            expandedMustNot.addAll(settings.stream().filter(s -> Pattern.matches(setting, s)).collect(Collectors.toSet()));
        }
        mustNot.addAll(expandedMustNot);
        return mustNot;
    }

    private Set<String> getShould(ValidationDetails.DependencyInfo dependencyInfo, Category category) {
        HashSet<String> should = new HashSet<String>();
        if (CollectionUtils.isEmpty(dependencyInfo.getShould())) {
            return should;
        }
        should = new HashSet(ListUtils.emptyIfNull(dependencyInfo.getShould()));
        Iterator iterator = should.iterator();
        HashSet expandedShould = new HashSet();
        while (iterator.hasNext()) {
            String setting = (String)iterator.next();
            Set<String> settings = ProposedSetting.getInstance().getCategoryProposedSettingMap(category).keySet();
            expandedShould.addAll(settings.stream().filter(s -> Pattern.matches(setting, s)).collect(Collectors.toSet()));
        }
        should.addAll(expandedShould);
        return should;
    }

    public Set<Category> getCategoriesWithEncryptedFields() {
        return Arrays.stream(Category.values()).filter(category -> this.getcategoryValidationMap((Category)((Object)category)).entrySet().stream().filter(entry -> ((ValidationDetails)entry.getValue()).isEncrypted()).findFirst().isPresent()).collect(Collectors.toSet());
    }
}

