/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.passwordreset;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.Scanner;

public class PasswordReset {
    private static String PASSWORD_FILE_PATH;
    private static final String ENCRYPTED = "encrypted";
    private static final String PASSWORD = "password";
    private static final String RDSPASSWORD = "rdspassword";
    private static final String ALGORITHM = "SHA-256";
    private static String JETTY_PATH;
    private static final String JETTY_SECURITY_FILE = "/etc/security.properties";

    public static void main(String[] args) {
        String cfusionHome = System.getProperty("CFUSION_HOME");
        PASSWORD_FILE_PATH = cfusionHome + "/lib/password.properties";
        JETTY_PATH = cfusionHome + "/jetty";
        String clName = PasswordReset.class.getClassLoader().getClass().getCanonicalName();
        if (clName != null && clName.equalsIgnoreCase("coldfusion.bootstrap.BootstrapClassLoader")) {
            System.err.println("Unexpected behavior. Please see documentation for correct usage.");
            System.exit(-1);
        }
        Scanner scan = new Scanner(System.in);
        String index = "";
        while (true) {
            System.out.println("Enter 1 for changing Admin Password and 2 for changing Admin Component(jetty) password : ");
            try {
                index = scan.nextLine();
                if ("1".equals(index) || "2".equals(index)) break;
                System.out.println("Invalid Input");
            }
            catch (Exception e) {
                System.out.println("Invalid Input");
            }
        }
        if ("1".equals(index)) {
            PasswordReset.resetAdminPassword();
        } else {
            PasswordReset.resetAdminComponentPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAdminComponentPassword() {
        block7: {
            Scanner scan = new Scanner(System.in);
            while (!new File(JETTY_PATH + JETTY_SECURITY_FILE).exists()) {
                System.out.println("Enter path of the Jetty server : ");
                JETTY_PATH = scan.nextLine();
                String finalpath = JETTY_PATH + JETTY_SECURITY_FILE;
                if (new File(finalpath).exists()) continue;
                System.out.println("Invalid Path. File " + JETTY_PATH + "/etc/security.properties does not exist");
            }
            JETTY_PATH = JETTY_PATH + JETTY_SECURITY_FILE;
            String newadminpassword = "";
            while (0 == newadminpassword.length()) {
                System.out.println("Enter new Admin Component(jetty) Password : ");
                newadminpassword = PasswordReset.readPassword(scan);
                if (0 != newadminpassword.length()) continue;
                System.err.println("Admin Component password can not be empty");
            }
            newadminpassword = PasswordReset.hash(PasswordReset.hash(newadminpassword, ALGORITHM), ALGORITHM);
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(new File(JETTY_PATH)));
                Properties prop = new Properties();
                prop.load(reader);
                prop.put(PASSWORD, newadminpassword);
                PasswordReset.closeReader(reader);
                writer = new BufferedWriter(new FileWriter(new File(JETTY_PATH)));
                prop.store(writer, "");
                PasswordReset.closeReader(reader);
            }
            catch (IOException e) {
                System.err.println(e);
                break block7;
            }
            finally {
                PasswordReset.closeReader(reader);
                PasswordReset.closeWriter(writer);
            }
            PasswordReset.closeWriter(writer);
        }
        System.out.println("Your Admin Component(jetty) password has been reset.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetAdminPassword() {
        block6: {
            Scanner scan = new Scanner(System.in);
            String newadminpassword = "";
            String newrdspassword = "";
            while (0 == newadminpassword.length()) {
                System.out.println("Enter new Admin Password : ");
                newadminpassword = PasswordReset.readPassword(scan);
                if (0 != newadminpassword.length()) continue;
                System.err.println("Admin password can not be empty");
            }
            System.out.println("Enter new RDS Password : ");
            newrdspassword = PasswordReset.readPassword(scan);
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new BufferedReader(new FileReader(new File(PASSWORD_FILE_PATH)));
                Properties prop = new Properties();
                prop.load(reader);
                prop.put(RDSPASSWORD, newrdspassword);
                prop.put(PASSWORD, newadminpassword);
                prop.put(ENCRYPTED, "false");
                PasswordReset.closeReader(reader);
                writer = new BufferedWriter(new FileWriter(new File(PASSWORD_FILE_PATH)));
                prop.store(writer, "");
                PasswordReset.closeReader(reader);
            }
            catch (IOException e) {
                System.err.println(e);
                break block6;
            }
            finally {
                PasswordReset.closeReader(reader);
                PasswordReset.closeWriter(writer);
            }
            PasswordReset.closeWriter(writer);
        }
        System.out.println("Your Admin and RDS password has been reset. Re-start the server to reflect the changes.");
    }

    private static String readPassword(Scanner scan) {
        Console c = System.console();
        String pass = "";
        pass = c == null ? scan.nextLine().trim() : new String(c.readPassword());
        String confirmpassword = "";
        System.out.println("Confirm new Password : ");
        confirmpassword = c == null ? scan.nextLine().trim() : new String(c.readPassword());
        if (!confirmpassword.equals(pass)) {
            System.err.println("Passwords do not match");
            System.out.println("Re-Enter new Password : ");
            PasswordReset.readPassword(scan);
        }
        return pass;
    }

    private static void closeReader(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    private static void closeWriter(BufferedWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    private static String hash(String input, String algorithm) {
        byte[] byteinput = null;
        try {
            byteinput = input.getBytes();
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            digest.reset();
            digest.update(byteinput);
            byteinput = digest.digest();
            return PasswordReset.stringify(byteinput);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }
}

